;;; epoxml.el -- Editing Process Organizer / xml-mode for emacs.
;;<plaintext>

;; Author: Toshikazu Ando <ando@park.ruru.ne.jp>
;; Maintainer: Toshikazu Ando <ando@park.ruru.ne.jp>
;; Created: 2001 Feb.25
;; Version: $Lastupdate: Sun Jan 19 10:12:48 2003 $ on inspire.
;; URL : http://park.ruru.ne.jp/ando/work/who/epojava/
;; Keywords: epo, xml

;; Abstract.
;;   This program support functions.
;;   * epo support.
;;   * indent.
;;   * tag view.
;;   * replace indent all lines.
;;
;; Setting epojava.
;;     looking for the epoan.el
;;
;----------------------------------------------------------------------

;---------------------------------------------------------------------
(require 'epocclib)
(require 'epo-xml)
;---------------------------------------------------------------------
(defvar epoxml-mode-map nil "epoxml keymap")
(defvar epoxml-space-face 'epoxml-space-face
  "Face name to use for function names.")
(defface epoxml-space-face
   '((((class color)) (:background  "hotpink"))
     (t (:reverse-video t)))
  "Face to use for highlighting leading spaces in Font-Lock mode
(from Makefile-mode).")
(defconst epoxml-font-lock-keywords-1
  '(("<[!?]\\([a-z][-.a-z0-9_]*\\)" 1 font-lock-keyword-face)
    ("</?\\([a-z][-.a-z0-9_]*\\)" 1 font-lock-function-name-face)
    ("</?[a-z][-.a-z0-9_]*:\\([a-z][-.a-z:0-9_]*\\)"
     1 font-lock-keyword-face)
    ("</?[a-z][-.a-z0-9_]*:\\([a-z][-.a-z:0-9_]*\\)"
     1 font-lock-keyword-face)
    ("\\s +\\([a-z][-.a-z0-9:_]*\\)\\s *=" 1 font-lock-variable-name-face)
    ("<! *--.*-- *>" . font-lock-comment-face)
    ;; Highlight lines that contain just whitespace.
    ;; They can cause trouble, especially if they start with a tab.
    ("^[ \t]+$" . epoxml-space-face)))
(defvar epoxml-font-lock-keywords epoxml-font-lock-keywords-1
  "*Default expressions to highlight in Relax mode.")
(defvar epoxml-table-regexp "^\\s *\\(<\\sw+[^/\r\n]*\\)$"
  "*epcc-table xml hit list")
(defvar epoxml-mode-name "epoxml" "default mode name")
(defvar epoxml-basic-offset 2 "*indent offset")
(defvar epoxml-basic-short-offset 1 "*indent offset")

;---------------------------------------------------------------------

;;
;; Define key table
;;
(if epoxml-mode-map
    nil
  (setq epoxml-mode-map (make-sparse-keymap))
  (substitute-key-definition
   'epo-version 'epocclib-version epo-mode-map)
  (substitute-key-definition
   'epop-start-menu 'epocclib-start-menu epo-mode-map)
  (define-key epoxml-mode-map "\t"
    '(lambda () (interactive)
       (if (and indent-line-function (fboundp indent-line-function))
	   (funcall indent-line-function))))
  (define-key epoxml-mode-map "\M-q"  'epoxml-indent-all)
  (define-key epoxml-mode-map "\M-Q"  'epoxml-indent-all)
  (define-key epoxml-mode-map "\M-\r" 'epoi-intelligent-newline)
  (epo-define-key epoxml-mode-map "u" 'epocclib-update-file)
  (epo-define-key epoxml-mode-map "t" 'epocclib-start-menu)
  (epo-define-key epoxml-mode-map "b" 'epocclib-structure-b-input)
  (epo-define-key epoxml-mode-map "s" 'epocclib-structure-s-input)
  (epo-define-key epoxml-mode-map "f" 'epocclib-structure-f-input)
  (epo-define-key epoxml-mode-map "l" 'epocclib-structure-l-input)
  (epo-define-key epoxml-mode-map "n" 'epocclib-structure-n-input)
  (epo-define-key epoxml-mode-map "@" 'epocclib-structure-att-input)
  (epo-define-key epoxml-mode-map "!" 'epocclib-structure-ext-input)
  (epo-define-key epoxml-mode-map "h" 'describe-mode)
  (epo-define-key epoxml-mode-map "g" 'epor-resolve-relation)
  (epo-define-key epoxml-mode-map "G" 'epocclib-table-mode-in)
  (epo-define-key epoxml-mode-map "d" 'epoxml-wordjump)
  (epo-define-key epoxml-mode-map "a" 'epoxml-complete-mark)
  (epo-define-key epoxml-mode-map ":" 'epocclib-untranslate-region)
  (epo-define-key epoxml-mode-map ";" 'epocclib-translate-region)
  (epo-define-key epoxml-mode-map "<" 'epocclib-uncomment-region)
  (epo-define-key epoxml-mode-map ">" 'comment-region)

  (defvar epoxml-mode-menu-comp-map (make-sparse-keymap "Completion"))
  (epocclib-define-menu
   'epoxml-mode-menu-comp-map
   (nreverse
    (list
     (cons (list 'block "Block")
	   (cons "Block" 'epocclib-structure-b-input))
     (cons (list 'section "Inline")
	   (cons "Inline" 'epocclib-structure-s-input))
     (cons (list 'func "xml")
	   (cons "xml" 'epocclib-structure-f-input))
     (cons (list 'large "dtd")
	   (cons "dtd" 'epocclib-structure-l-input)) )))
  (defvar epoxml-mode-menu-chng-map (make-sparse-keymap "Mode"))
  (epocclib-define-menu
   'epoxml-mode-menu-chng-map
   (nreverse
    (list
     (cons (list 'auto "XML(Auto)")
	   (cons "XML(Auto)" 'epoxml-mode))
     (cons (list 'xsl "XSL")
	   (cons "XSL" (lambda () (interactive) (epoxml-mode 'xsl))))
     (cons (list 'xhtml "XHTML")
	   (cons "XHTML" (lambda () (interactive) (epoxml-mode 'xhtml))))
     (cons (list 'relax "Relax")
	   (cons "Relax" (lambda () (interactive) (epoxml-mode 'rlx))))
     (cons (list 'sdoc "SmartDoc")
	   (cons "SmartDoc" (lambda () (interactive) (epoxml-mode 'sdoc))))
     (cons (list 'ant "Ant")
	   (cons "Ant" (lambda () (interactive) (epoxml-mode 'ant))))
     (cons (list 'wapp "web.xml")
	   (cons "web.xml" (lambda () (interactive) (epoxml-mode 'wapp))))
     (cons (list 'sev "server.xml")
	   (cons "server.xml" (lambda () (interactive) (epoxml-mode 'sev))))
     (cons (list 'scof "Struts-config")
	   (cons "Struts-config"
		 (lambda () (interactive) (epoxml-mode 'scof))))
     (cons (list 'jsp "jsp")
	   (cons "jsp" (lambda () (interactive) (epoxml-mode 'jsp))))
     (cons (list 'tld "jsp-taglib")
	   (cons "jsp-taglib" (lambda () (interactive) (epoxml-mode 'tld))))
     (cons (list 'jnlp "Jnlp")
	   (cons "Jnlp" (lambda () (interactive) (epoxml-mode 'jnlp))))
     (cons (list 'xi "Xi")
	   (cons "Xi" (lambda () (interactive) (epoxml-mode 'xi))))
     (cons (list 'gsml "Gsml")
	   (cons "Gsml" (lambda () (interactive) (epoxml-mode 'gsml)))) )))
  (defvar epoxml-mode-menu-map (make-sparse-keymap epoxml-mode-name))
  (epocclib-define-menu
   'epoxml-mode-menu-map
   (nreverse
    (list
     (cons (list 'comp "Completion")
	   (cons "Completion" epoxml-mode-menu-comp-map))
     (cons (list 'typeset "Typeset")
	   (cons "Typeset" 'epocclib-start-menu))
     (cons (list 'mode "Mode")
	   (cons "Mode" epoxml-mode-menu-chng-map))
     (cons (list 'method "Tag view")
	   (cons "Tag view" 'epocclib-table-mode-in))
     (cons (list 'word "Word jump")
	   (cons "Word jump" 'epoxml-wordjump))
     (cons (list 'indent "Indent all")
	   (cons "Indent all" 'epocclib-indent-all))
     (cons (list 'update "Update all file")
	   (cons "Update all file" 'epocclib-update-file))
     (cons (list 'ver "Version")
	   (cons "Version" 'epocclib-version))
     (cons (list 'help "For help")
	   (cons "For help" 'describe-mode)) )))
  (define-key epoxml-mode-map [menu-bar epoxml]
    (cons epoxml-mode-name epoxml-mode-menu-map))
  (if (featurep 'xemacs)
      (add-hook
       'epoxml-mode-hook
       '(lambda ()
	  (or (assoc epoxml-mode-name current-menubar)
	      (progn
		(set-buffer-menubar (copy-sequence current-menubar))
		(add-submenu nil epoxml-mode-menu-map)))))))

(defun epoxml-mode (&optional now-mode-name)
  "The Editing Process Organizer / java mode for GNU emacs.

Key bindings:
 \\[epoxml-mode-map] : indent-command
 \\[epocclib-indent-all] : indent-command all lines.
 \\[describe-mode] : for help"
  (interactive)
  (if (not now-mode-name) (setq now-mode-name (epo-xml-select-file)))
  (kill-all-local-variables)
  (make-local-variable 'comment-start)
  (make-local-variable 'comment-end)
  (make-local-variable 'indent-line-function)
  (make-local-variable 'epoxml-basic-offset)
  (setq major-mode 'epoxml-mode
	mode-name (concat "epo" (symbol-name now-mode-name))
	defun-prompt-regexp nil
	comment-start "<!-- "
	comment-end " -->"
	indent-line-function 'epoxml-indent-command)
  (if (or (string= (symbol-name now-mode-name) "xi")
	  (string= (symbol-name now-mode-name) "jsp")
	  (string= (symbol-name now-mode-name) "xhtml")
	  (string= (symbol-name now-mode-name) "sdoc"))
      (setq epoxml-basic-offset epoxml-basic-short-offset))
  (epocclib-enable (symbol-name now-mode-name)) ;; invoke epo-mode
  (use-local-map epoxml-mode-map)
  (if (not window-system) nil
    (make-local-variable 'font-lock-defaults)
    (setq font-lock-defaults '(epoxml-font-lock-keywords nil t)) )
  (make-local-variable 'epocclib-table-regexp)
  (setq epocclib-table-regexp epoxml-table-regexp)
  (if window-system (font-lock-mode nil))
  (if window-system (font-lock-mode 1))
  (setq indent-tabs-mode nil)
  (run-hooks 'epoxml-mode-hook))

;---------------------------------------------------------------------

(defun epoxml-indent-command ()
  "epoxml sdoc ΍"
  (let ( (len) (next-flag t) )
    (if (string-equal epo:current-language "sdoc")
	(save-excursion
	  (beginning-of-line)
	  (if (looking-at "^[\t ]*$")
	      (progn (replace-match "")
		     (setq next-flag nil)))))
    (if next-flag (epoxml-indent-command-post))))

(defun epoxml-indent-command-post ()
  "epoxml ŃCfgꂽ"
  (let ((len) (replace-chars) (replace2-chars))
    (save-excursion
      (beginning-of-line) ;; vZ̔ώG邽ߍs擪ւ܂ړ
      (catch 'epoxml-indent-command-tag
	(if (bobp) ; 擪sȂindent 0
	    (progn
	      (epoxml-indent-to 0)
	      (throw 'epoxml-indent-command-tag t)))
	(save-excursion
	  (skip-chars-forward " \t")
	  (if (eobp) ; ŌȂindent 0
	      (progn
		(epoxml-indent-to 0)
		(throw 'epoxml-indent-command-tag t))))
	(save-excursion
	  (skip-chars-backward " \t\r\n") ; ߂
	  (setq replace-chars (char-before (point))
		replace2-chars (char-before (- (point) 1))
		len (epoxml-indent-len) ))
	(if replace-chars
	    (if (= ?> replace-chars)
		(epoxml-indent-command2 replace2-chars) ; OsƓ}
	      (epoxml-indent-command3))
	  (epoxml-indent-to 0)))) ; 擪s
    ;; ȉ̓J[\ړp
    (save-excursion
      (end-of-line) (setq len (point)))
    (save-excursion
      (beginning-of-line) ; sɈړ
      (skip-chars-forward " \t\r\n" len) ; 
      (setq len (point)))
    (if (< (point) len) (goto-char len))))

(defun epoxml-indent-command2 (replace2-chars)
  "Kw[ȂāA
ȂǂȂȂĂ̂ŕB
  O̕ > ŏIĂƂ̏B
"
  (let ((len) (my1-chars) (my2-chars) (prepend2-chars) (pos 0) (flag t))
    (save-excursion
      (while flag
	  (skip-chars-backward "^<>") ; ꂪ܂Ŗ߂
	  (setq pos
		(if (char-before (point))
		    (if (= ?< (char-before (point))) (- pos 1) (+ pos 1))
		  0))
	  (setq flag (< 0 pos)) ;(or (< 0 pos) (bobp)))
	  (if flag (goto-char (- (point) 1))))
      (setq prepend2-chars (char-before (+ (point) 1))
	    len (epoxml-indent-len)))
    (if (or (= ?/ replace2-chars) ; Õ^O̍Ōオ/>ŏI
	    (= ?- replace2-chars) ; Õ^O̍ŌオRgŏI
	    (= ?? replace2-chars) ; Õ^O̍Ōオ?> ŏI
	    (= ?% replace2-chars) ; Õ^O̍Ōオ%> ŏI
	    (= ?! prepend2-chars) ; Õ^O <! Ŏn܂
	    (= ?/ prepend2-chars) ; Õ^O </ Ŏn܂
	    (= ?- prepend2-chars) ; Õ^O <- Ŏn܂
	    (= ?? prepend2-chars) ; Õ^O <? Ŏn܂
	    (= ?% prepend2-chars)) ; Õ^O <% Ŏn܂
	nil ; Õ^O <- Ƃ /> B
      (setq len (+ len epoxml-basic-offset)))
    (save-excursion
      (beginning-of-line) ; s̃^O𒲂ׂB
      (skip-chars-forward " \t") ; 擪sɃXy[X΃XLbv
      (setq my1-chars (char-before (+ (point) 1)))
      (setq my2-chars (char-before (+ (point) 2))))
    (if (or
	 (= ?> my1-chars)  ;  >
	 (and (= ?/ my1-chars) (= ?> my2-chars))  ;  />
	 (and (= ?] my1-chars) (= ?> my2-chars))  ;  ]>
	 (and (= ?< my1-chars) (= ?/ my2-chars))) ;  </
	(setq len (- len epoxml-basic-offset) ))
    (epoxml-indent-to len)))

(defun epoxml-indent-command3 () ; Os̏I肪 > łȂB
  "Kw[ȂāAȂǂȂȂĂ̂ŕ"
  (let ((limmit) (len) (char-back) (end1-chars) (end2-chars))
    (save-excursion
      (setq limmit (- (point) 1))
      (skip-chars-backward "^<") ; ꂪ܂Ŗ߂
      (setq char-back (char-before (+ 1 (point))))
      (setq len (epoxml-indent-len))
      (skip-chars-forward "^>" limmit)
      (end-of-line)
      (setq end1-chars (char-before (- (point) 1)))
      (setq end2-chars (char-before (point))))
    (save-excursion
      (beginning-of-line)
      (skip-chars-forward " \t")
      (if (and (not (or (= ?/ char-back) (= ?! char-back) (= ?% char-back)))
	       (not (and (= ?/ end1-chars) (= ?> end2-chars))))
	  (setq len (+ len epoxml-basic-offset)))
      (if (and
	   (= ?< (char-before (+ 1 (point))))
	   (= ?/ (char-before (+ 2 (point)))))
	  (setq len (- len epoxml-basic-offset))))
    (epoxml-indent-to len)))

(defun epoxml-indent-to (number)
  "w肳ꂽ number Cfg"
  (beginning-of-line) ; sɈړ
  (if (< number 0) (setq number 0)) ; ꉞی̂
  (let ((start) (end) (len) (char-data))
    (setq start (point))
    (skip-chars-forward " \t") ; n߂܂ňړ
    (setq end (point)
	  len (- end start)
	  char-data (char-before))
    (if (and (= number len) char-data (not (= char-data ?\t))) nil
      (delete-region start end) ; 󔒂
      (indent-to number)))) ; Kv󔒒ǉ

(defun epoxml-indent-len ()
  "CfgvZ"
  (beginning-of-line) ; sɈړ
  (let ((start))
    (setq start (point))
    (skip-chars-forward " \t") ; n߂܂ňړ
    (- (point) start)))

(defun epoxml-complete-mark ()
  "mark of \"<\",\"<\" key."
  (interactive)
  (if (string-equal epo:current-language "sdoc")
      (message "1:< 2:> 3:& 4:\" 5:' 6:nbsp 7:nbsp(tex)")
    (message "1:< 2:> 3:& 4:\" 5:' 6:nbsp"))
  (let ((c (read-char)))
    (cond 
     ((= ?1 c) (insert "&lt;"))
     ((= ?2 c) (insert "&gt;"))
     ((= ?3 c) (insert "&amp;"))
     ((= ?4 c) (insert "&quot;"))
     ((= ?5 c) (insert "&apos;"))
     ((= ?6 c)
      (insert (if (string-equal epo:current-language "sdoc")
		  "&#160;" "&nbsp;")))
     ((= ?7 c)
      (insert
       (if (string-equal epo:current-language "sdoc")
	   "<native format=\"latex2e\" normalizer=\"none\">\\ </native>"
	 nil)))
     (nil))))

;;;---------------------------------------------------------------------
(defun epoxml-wordjump (&optional other)
  "epoxml wordjump display

Key bindings:
 g : open.
 C-u g : open same window.
 \\[epocclib-view-file] : view mode.
 \\[epocclib-table-quit] : quit."
  (interactive "P")
  (let ((alist
	 '(("./" "./") ("../" "../") ("../../" "../../")
	   ("../../../" "../../../"))))
    (epocclib-wordjump
     (cdr (assoc (completing-read "Project : " alist nil t) alist))
     (list (concat "." (file-name-extension (buffer-file-name)))) other)))

(defun epoxml-indent-all ()
  (interactive)
  (save-excursion
    (message "delete rear space")
    (goto-char (point-min))
    (while (re-search-forward "[\t ]+$" nil t) (replace-match ""))
    (message "delete front space")
    (goto-char (point-min))
    (while (re-search-forward "^[\t ]+" nil t) (replace-match " "))
    ;; nomal indent
    (epocclib-indent-all)))

; end.
(provide 'epoxml)
;;; epoxml.el ends here
