#!/bin/bash

. ./common.sh
. ../option

echo "*** Detectng gtar, gmake, gpatch"
TAR=tar
PATCH=patch
MAKE=make
gpatch --version &>/dev/null && PATCH=gpatch
gtar --version &>/dev/null && TAR=gtar
gmake --version &>/dev/null && MAKE=gmake

echo "*** extracting e-pTeX source"
pushd $TMP_PREFIX/source/texk/web2c 
$TAR jxf $SRC/eptex-*.tar.bz2
mkdir -p $TMP_PREFIX/share/texmf/ptex/plain/base/
cp eptex-*/*.src $TMP_PREFIX/share/texmf/ptex/plain/base/
cp eptex-*/eptexdefs.lib $TMP_PREFIX/share/texmf/ptex/plain/base/
cp -r ptexdir/ eptexdir
cp -r eptex-*/* eptexdir/ 
cd ../..
echo "*** applying ep-tl07.patch"
cat $SRC/ep-tl07.patch | sed "s/PATCH/$PATCH/" > ep-tl07.patch
$PATCH -p1 < ep-tl07.patch || exit 1
rm -f ep-tl07.patch

if test -f $SRC/uptex-*.tar.gz; then
  echo "*** extracting upTeX source"
  cd ..
  $TAR zxf $SRC/uptex-*.tar.gz
  cd source/texk/web2c
  cp -r ptexdir/ uptexdir
  cd uptexdir 
  mv ptex-base.ch uptex-base.ch
  mv ppltotf.ch uppltotf.ch
  mv ptftopl.ch uptftopl.ch
  mv jbibtex.ch upjbibtex.ch
  mv pdvitype.ch updvitype.ch
  cd ../../..
  cp texk/web2c/omegaware/ovp2ovf.web texk/web2c/omegaware/upovp2ovf.web
  cp texk/web2c/omegaware/ovp2ovf.ch  texk/web2c/omegaware/upovp2ovf.ch


  if test "$JAPANESE" = "international"; then
    mv texk/dvipsk texk/dvipsk.orig
    cp -r texk/pdvipsk texk/dvipsk # will writeback later
    mv texk/xdvik texk/xdvik.orig 
    cp -r texk/pxdvik texk/xdvik # will writeback later
  fi

  echo "*** applying uptex_src-*.patch"
  $PATCH -p2 -f < $TMP_PREFIX/uptex-*/patch/ptetex3-*_uptex_src-*.patch &>/dev/null

  echo "*** applying up-tl07.patch"
  cp -r texk/web2c/uptexdir/ texk/web2c/euptexdir
  cp texk/web2c/eptexdir/etex.diff texk/web2c/euptexdir
  cat $SRC/up-tl07.patch | sed "s/PATCH/$PATCH/" > up-tl07.patch
  $PATCH -p1 < up-tl07.patch || exit 1
  rm -f up-tl07.patch

  if test "$JAPANESE" = "international"; then
    rm -rf texk/pxdvik texk/pdvipsk
    mv texk/xdvik texk/pxdvik
    mv texk/dvipsk texk/pdvipsk
    mv texk/xdvik.orig texk/xdvik
    mv texk/dvipsk.orig texk/dvipsk
  fi
else 
  echo "*** upTeX source does not found. upTeX will be not compiled"
fi

echo "*** patching texmfmem.h"
pushd texk/web2c
  cat texmfmem.h \
    | sed "s/#if\ \!defined(Omega)/#if\ \!defined(Omega)\ \&\&\ \!defined(epTeX)\ \&\&\ \!defined(eupTeX)/" \
      > texmfmem2.h
  mv texmfmem.h texmfmem.h.orig
  cp -f  texmfmem2.h texmfmem.h
popd

if test "$FAM256" = "1"; then
  cd texk/web2c
  echo "*** FAM256 patching"
  cat <<EOF >> eptexdir/kanji.h
#define getintone(w) ((w).cint1)
#define setintone(w,a) ((w).cint1=(a))
EOF
  cat <<EOF >> eptexdir/eptex.defines
@define function getintone();
@define procedure setintone();
EOF
  if test -f $SRC/uptex-*.tar.gz; then
    cat <<EOF >> euptexdir/kanji.h
#define getintone(w) ((w).cint1)
#define setintone(w,a) ((w).cint1=(a))
EOF
    cat <<EOF >> euptexdir/euptex.defines
@define function getintone();
@define procedure setintone();
EOF
  fi
  cd ../..
fi

if test -f $SRC/uptex-*.tar.gz; then
  echo "*** applying uptex_ptexenc-0.999.patch"
  cd texk/ptexenc
  $PATCH -p1 < $SRC/uptex_ptexenc-0.999.patch || exit 1
  cd ../..
fi
popd

if test -f $SRC/uptex-*.tar.gz; then
  echo "*** extracing upTeX binary fonts"
  pushd $TMP_PREFIX/share/texmf
  $TAR zxf $SRC/uptex_font-0.22.tar.gz || exit
  rm -rf fonts/*uptex*/
  $PATCH  -p3 -f <$TMP_PREFIX/uptex-*/patch/ptetex3-*_uptex_texmf-*.patch || exit
  popd
fi

make stage4


if test "$FAM256" = "1"; then
  echo "*** Make FAM256 enabled binaries of e-pTeX and e-upTeX ***"
  echo "         Return key to continue, or Ctrl+C to abort"
  read

  echo "[update] Banner of e-pTeX"
  pushd $TMP_PREFIX/source/texk/web2c 
  sed "s/PTEX-VERSION/`cat ptexdir/ptex.version`-`cat eptexdir/eptex.version`_FAM256-PATCHED/" \
      eptexdir/ptexextra.in >eptexdir/eptexextra.h

  echo "[patch ] Applying FAM256 patch to e-pTeX"
    cp eptex.web eptex.web.orig
    ./tie -m eptex.web eptex.web.orig eptexdir/fam256.ch || exit 1

  if test -f $SRC/uptex-*.tar.gz; then
    echo "[update] Banner of e-upTeX"
    cat euptexdir/ptexextra.in \
         | sed s/PTEX-VERSION/`cat ptexdir/ptex.version`/ \
         | sed s/UPTEX-VERSION/`cat uptexdir/uptex.version`/ \
         | sed "s/EPTEX-VERSION/`cat eptexdir/eptex.version`_FAM256-PATCHED/" \
         >euptexdir/euptexextra.h
    echo "[patch ] Applying FAM256 patch to e-upTeX"
    cp euptex.web euptex.web.orig
    cat <<EOF > fam256.diff
--- fam256.ch.orig      2009-03-04 23:26:27.000000000 +0900
+++ fam256.ch   2009-03-05 09:45:26.062449559 +0900
@@ -267,9 +260,9 @@
 @z
 %-----------------------------------------------
 @x
-char_given,math_given: scanned_result(cur_chr)(int_val);
+char_given,kchar_given,math_given: scanned_result(cur_chr)(int_val);
 @y
-char_given,math_given,omath_given: scanned_result(cur_chr)(int_val);
+char_given,kchar_given,math_given,omath_given: scanned_result(cur_chr)(int_val);
 @z
 %-----------------------------------------------
 @x
@@ -1079,6 +1079,7 @@
 @d mu_skip_def_code=5 {|shorthand_def| for \.{\\\\muskipdef}}
 @d toks_def_code=6 {|shorthand_def| for \.{\\\\toksdef}}
 @d char_sub_def_code=7 {|shorthand_def| for \.{\\\\charsubdef}}
+@d kchar_def_code=8 {|shorthand_def| for \.{\\\\kchardef}}
 @y
 @d omath_char_def_code=2 {|shorthand_def| for \.{\\\\omathchardef}}
 @d count_def_code=3 {|shorthand_def| for \.{\\\\countdef}}
@@ -1087,6 +1088,7 @@
 @d mu_skip_def_code=6 {|shorthand_def| for \.{\\\\muskipdef}}
 @d toks_def_code=7 {|shorthand_def| for \.{\\\\toksdef}}
 @d char_sub_def_code=8 {|shorthand_def| for \.{\\\\charsubdef}}
+@d kchar_def_code=9 {|shorthand_def| for \.{\\\\kchardef}}
 @z
 %-----------------------------------------------
 @x
EOF
    cp eptexdir/fam256.ch fam256.ch
    $PATCH -p0 < fam256.diff || exit 1
    ./tie -m euptex.web euptex.web.orig fam256.ch  || exit 1
  fi


echo "[build ] eptex"
  rm eptex.p eptex.pool eptexextra.o 
  $MAKE eptex 

  if test -f $SRC/uptex-*.tar.gz; then
    echo "[build ] euptex"
    rm euptex.p euptex.pool euptexextra.o 
    $MAKE euptex || exit 1
  fi

  cp -f texmfmem.h.orig texmfmem.h
  cp eptex ../../../bin/
  ln -s eptex ../../../bin/eplatex
  cp eptex.pool ../../../share/texmf/web2c/

  if test -f $SRC/uptex-*.tar.gz; then
    cp euptex ../../../bin/
    ln -s euptex ../../../bin/euplatex
    cp euptex.pool ../../../share/texmf/web2c/
  fi
  popd
fi
echo "------------------------"
$TMP_PREFIX/bin/eptex -version  |head -1
if test -f $SRC/uptex-*.tar.gz; then
  $TMP_PREFIX/bin/euptex -version |head -1
fi

exit 0

# making tl07-compile-xxxxxx.tar.bz2
tar jcvf tl07-compile-090309.tar.bz2 ep-tl07.patch compile.txt \
    option tl07-bld1.sh uptex_ptexenc-0.999.patch up-tl07.patch \
    ptexlive-*/5macro_uptex.sh tl07-bld2.sh
