#!/bin/bash
# Build Step 1 - extracting / patching source file and build

. ./option
export CFLAGS
unset CXXFLAGS
unset LDFLAGS

cd $CMP_TEMP
echo "[clean ]"
rm -rf texlive-*-source uptex-*
echo "[unpack] texlive-*-source.tar"
$TAR xf $SRC/texlive-*-source.tar
pushd $SRC &>/dev/null
UPTEX_VER=`ls  uptex-*.tar.gz|sed "s/uptex-/u/;s/.tar.gz//"`
EPTEX_VER=`ls  eptex-*.tar.bz2|sed "s/eptex-//;s/.tar.bz2//"`
popd &>/dev/null
echo "[unpack] uptex-*.tar.gz"
$TAR zxf $SRC/uptex-*.tar.gz 
cd texlive-*-source/texk
echo "[unpack] makejvf-1.1a.tar.gz"
$TAR zxf $SRC/makejvf-1.1a.tar.gz
echo "[unpack] mendexk2.6e.tar.gz"
echo "[unpack] ptexenc-0.999.tar.gz"
$TAR zxf $SRC/mendexk2.6e.tar.gz
$TAR zxf $SRC/ptexenc-0.999.tar.gz
cd web2c
echo "[unpack] ptex-src-3.1.10.tar.gz"
$TAR zxf $SRC/ptex-src-3.1.10.tar.gz
echo "[unpack] eptex-*.tar.gz"
$TAR jxf $SRC/eptex-*.tar.bz2
mv ptex-src-3.1.10/ ptexdir
cd ..
mv makejvf-1.1a/ makejvf
mv mendexk2.6e/ mendexk
mv ptexenc-0.999/ ptexenc
echo "[patch ] ptexlive's patch"
. ptexenc/patches/texlive2008.sh &>/dev/null
$PATCH -p1 -d mendexk < ptexenc/patches/mendexk2.6e-ptexenc.patch  &>/dev/null
$PATCH -p1 -d makejvf < ptexenc/patches/makejvf-1.1a-ptexenc.patch &>/dev/null
cat web2c/ptexdir/ptexextra.in \
  | sed s/3.141592/3.1415926/ > web2c/ptexdir/ptexextra.in2
mv web2c/ptexdir/ptexextra.in2 web2c/ptexdir/ptexextra.in
cd ..

# e-pTeX, upTeX
echo "[copy  ] ptexdir -> eptexdir"
cp -r texk/web2c/ptexdir texk/web2c/eptexdir
cp -r texk/web2c/eptex-*/* texk/web2c/eptexdir/ 
echo "[patch ] ep-tl08.patch"
cat $SRC/ep-tl08.patch | sed "s/PATCH/$PATCH/" > ep-tl08.patch
$PATCH -p1 < ep-tl08.patch || exit 1
rm -f ep-tl08.patch
cd texk/dvipsk
echo "[unpack] dvipsk-5.97-p1.7b-tl.tar.gz"
$TAR zxf $SRC/dvipsk-5.97-p1.7b-tl.tar.gz 
echo "[patch ] dvipsk-5.97-p1.7b-tl.diff"
$PATCH -p1 < dvipsk-5.97-p1.7b-tl.diff &>/dev/null
cd ../xdvik
echo "[patch ] xdvik-tl08.patch.gz"
$ZCAT $SRC/xdvik-tl08.patch.gz | $PATCH -p1 &>/dev/null
autoconf
cd ../web2c/
echo "[copy  ] ptexdir -> uptexdir"
cp -r ptexdir/ uptexdir
cd uptexdir
mv ptex-base.ch uptex-base.ch
mv ptftopl.ch uptftopl.ch
mv ppltotf.ch uppltotf.ch
mv pdvitype.ch updvitype.ch
mv jbibtex.ch  upjbibtex.ch
cd ../../../
echo "[copy  ] upovp2ovf"
cp texk/web2c/omegaware/ovp2ovf.web texk/web2c/omegaware/upovp2ovf.web 
cp texk/web2c/omegaware/ovp2ovf.ch texk/web2c/omegaware/upovp2ovf.ch 
echo "[patch ] uptex_src-*.patch"
cat $CMP_TEMP/uptex-*/patch/ptetex3-*_uptex_src-*.patch \
  |sed "s/3.141592/3.1415926/" > $CMP_TEMP/uptex-base-tmp.patch
$PATCH -p2 -f < $CMP_TEMP/uptex-base-tmp.patch &>/dev/null
cd texk/web2c/
echo "[copy  ] uptexdir -> euptexdir"
cp -r uptexdir/ euptexdir
cd euptexdir/      
cat ../eptexdir/etex.diff | sed "s/, Version 3.141592/, Version 3.1415926/" > etex.diff
cd ../../..
echo "[patch ] up-tl08.patch"
cat $SRC/up-tl08.patch \
  | sed "s/UPTEXVER/$UPTEX_VER/;s/EPTEXVER/$EPTEX_VER/" \
  | sed "s/PATCH/$PATCH/" > $CMP_TEMP/up-tl08.patch 
$PATCH -p1 < $CMP_TEMP/up-tl08.patch  || exit 1
cd texk/ptexenc
echo "[patch ] uptex_ptexenc-0.999.patch"
$PATCH -p1 < $SRC/uptex_ptexenc-0.999.patch || exit 1
cd ../..

echo "[patch ] texmfmem.h           (for e-pTeX)"
cat texk/web2c/texmfmem.h \
  | sed "s/#if\ \!defined(Omega)/#if\ \!defined(Omega)\ \&\&\ \!defined(epTeX)\ \&\&\ \!defined(eupTeX)/" \
  > texk/web2c/texmfmem2.h
mv texk/web2c/texmfmem.h texk/web2c/texmfmem.h.orig
cp -f  texk/web2c/texmfmem2.h texk/web2c/texmfmem.h

# FAM256 
if test "$FAM256" = "1"; then
  echo "[patch ] eptexdir/kanji.h etc (for FAM256 patch)"
  cat <<EOF >> texk/web2c/eptexdir/kanji.h
#define getintone(w) ((w).cint1)
#define setintone(w,a) ((w).cint1=(a))
EOF
  cat <<EOF >> texk/web2c/eptexdir/eptex.defines
  @define function getintone();
  @define procedure setintone();
EOF
  cat <<EOF >> texk/web2c/euptexdir/kanji.h
#define getintone(w) (w).cint1
#define setintone(w,a) ((w).cint1=(a))
EOF
  cat <<EOF >> texk/web2c/euptexdir/euptex.defines
  @define function getintone();
  @define procedure setintone();
EOF
fi

cd $CMP_TEMP/texlive-*-source
./Build $CONF_OPT 

# FAM256 
if test "$FAM256" = "1"; then
  echo "*** Make FAM256 enabled binaries of e-pTeX and e-upTeX ***"
  echo "         Return key to continue, or Ctrl+C to abort"
  read
  cd $CMP_TEMP/texlive-*-source/Work/texk/web2c

echo "[update] Banner of e-pTeX and e-upTeX"
  sed s/PTEX-VERSION/`cat ptexdir/ptex.version`-`cat eptexdir/eptex.version`_FAM256-PATCHED/ \
     ../../../texk/web2c/eptexdir/ptexextra.in >eptexdir/eptexextra.h
  cat ../../../texk/web2c/euptexdir/ptexextra.in \
         | sed s/PTEX-VERSION/`cat ptexdir/ptex.version`/ \
         | sed s/UPTEX-VERSION/`cat uptexdir/uptex.version`/ \
         | sed "s/EPTEX-VERSION/`cat eptexdir/eptex.version`_FAM256-PATCHED/" \
         >euptexdir/euptexextra.h

echo "[patch ] Applying FAM256 patch to e-pTeX"
  cp eptex.web eptex.web.orig
  ./tie -m eptex.web eptex.web.orig ../../../texk/web2c/eptexdir/fam256.ch || exit 1

echo "[patch ] Applying FAM256 patch to e-upTeX"
  cp euptex.web euptex.web.orig
  cat <<EOF > fam256.diff
--- fam256.ch.orig      2009-03-04 23:26:27.000000000 +0900
+++ fam256.ch   2009-03-05 09:45:26.062449559 +0900
@@ -267,9 +267,9 @@
 @z
 %-----------------------------------------------
 @x
-char_given,math_given: scanned_result(cur_chr)(int_val);
+char_given,kchar_given,math_given: scanned_result(cur_chr)(int_val);
 @y
-char_given,math_given,omath_given: scanned_result(cur_chr)(int_val);
+char_given,kchar_given,math_given,omath_given: scanned_result(cur_chr)(int_val);
 @z
 %-----------------------------------------------
 @x
@@ -1079,6 +1079,7 @@
 @d mu_skip_def_code=5 {|shorthand_def| for \.{\\\\muskipdef}}
 @d toks_def_code=6 {|shorthand_def| for \.{\\\\toksdef}}
 @d char_sub_def_code=7 {|shorthand_def| for \.{\\\\charsubdef}}
+@d kchar_def_code=8 {|shorthand_def| for \.{\\\\kchardef}}
 @y
 @d omath_char_def_code=2 {|shorthand_def| for \.{\\\\omathchardef}}
 @d count_def_code=3 {|shorthand_def| for \.{\\\\countdef}}
@@ -1087,6 +1088,7 @@
 @d mu_skip_def_code=6 {|shorthand_def| for \.{\\\\muskipdef}}
 @d toks_def_code=7 {|shorthand_def| for \.{\\\\toksdef}}
 @d char_sub_def_code=8 {|shorthand_def| for \.{\\\\charsubdef}}
+@d kchar_def_code=9 {|shorthand_def| for \.{\\\\kchardef}}
 @z
 %-----------------------------------------------
 @x
EOF
  cp ../../../texk/web2c/eptexdir/fam256.ch fam256.ch
  $PATCH -p0 < fam256.diff || exit 1
  ./tie -m euptex.web euptex.web.orig fam256.ch  || exit 1

echo "[build ] eptex"
  rm eptex.p eptex.pool eptexextra.o 
  $MAKE eptex || exit 1

echo "[build ] euptex"
  rm euptex.p euptex.pool euptexextra.o 
  $MAKE euptex || exit 1

echo "[copy  ] e-pTeX / e-upTeX binary to inst/bin/"
  ARCH=`ls $CMP_TEMP/texlive-*-source/inst/bin`
  cp eptex ../../../inst/bin/$ARCH/
  cp euptex ../../../inst/bin/$ARCH/
  cp eptex.pool ../../../inst/texmf/web2c/
  cp euptex.pool ../../../inst/texmf/web2c/
fi

echo "------------------------"
ARCH=`ls $CMP_TEMP/texlive-*-source/inst/bin`
$CMP_TEMP/texlive-*-source/inst/bin/$ARCH/eptex -version  |head -1
$CMP_TEMP/texlive-*-source/inst/bin/$ARCH/euptex -version |head -1


#This script ends here.
exit 0


# DEBUG: install binary
CMP_TEMP=/tmp
TL=/opt/TeX
ARCH=`ls $CMP_TEMP/texlive-*-source/inst/bin`
sudo cp $CMP_TEMP/texlive-*-source/inst/bin/$ARCH/eptex $TL/bin/$ARCH/
sudo cp $CMP_TEMP/texlive-*-source/inst/bin/$ARCH/euptex $TL/bin/$ARCH/
sudo cp $CMP_TEMP/texlive-*-source/inst/bin/$ARCH/ptex $TL/bin/$ARCH/
sudo cp $CMP_TEMP/texlive-*-source/inst/bin/$ARCH/uptex $TL/bin/$ARCH/
sudo cp $CMP_TEMP/texlive-*-source/inst/texmf/web2c/eptex.pool  $TL/texmf/web2c/
sudo cp $CMP_TEMP/texlive-*-source/inst/texmf/web2c/euptex.pool $TL/texmf/web2c/
sudo cp $CMP_TEMP/texlive-*-source/inst/texmf/web2c/ptex.pool  $TL/texmf/web2c/
sudo cp $CMP_TEMP/texlive-*-source/inst/texmf/web2c/uptex.pool $TL/texmf/web2c/
exit 0

# DEBUG: Making tl08-compile-*.tar.bz2
tar jcvf tl08-compile-090309.tar.bz2 bld*.sh \
    xdvik-tl08.patch.gz updmap-tl08 option hyphen/ \
    up-tl08.patch ep-tl08.patch compile.txt utf-tl08.patch \
    otf-tl08.patch uptex_ptexenc-0.999.patch
