#!/bin/bash
# Build Step 2 - extract [u]ptex-texmf and macros

. ./option

TEXMF=$CMP_TEMP/texlive-20080816-source/inst/texmf
TEXMFDIST=$TL/texmf-dist
pushd $SRC
UPTEX_VER=`ls  uptex-*.tar.gz|sed "s/uptex-//;s/.tar.gz//"`
EPTEX_VER=`ls  eptex-*.tar.bz2|sed "s/eptex-//;s/.tar.bz2//"`
popd

cd $TEXMF
echo "[unpack] ptex-texmf-2.5.tar.gz"
$TAR zxf $SRC/ptex-texmf-2.5.tar.gz
cp -r ptex-texmf/* .
rm -rf ptex-texmf/
echo "[unpack] uptex_font-0.22.tar.gz"
$TAR zxf $SRC/uptex_font-0.22.tar.gz 
echo "[patch ] ptetex3-*_uptex_texmf-*.patch"
$PATCH  -p3 -f < $CMP_TEMP/uptex-$UPTEX_VER/patch/ptetex3-*_uptex_texmf-*.patch \
  &>/dev/null

echo "*** Babel ***"
mkdir -p $TEXMF/ptex/generic/config/
echo "[copy  ] language.dat"
cp $SRC/hyphen/language.dat $TEXMF/ptex/generic/config/language.dat
echo "[copy  ] language.def"
cp $SRC/hyphen/language.def $TEXMF/ptex/generic/config/language.def
rm -rf $TEXMF/ptex/generic/hyphen/
mkdir -p $TEXMF/ptex/generic/hyphen/

# modified from common.sh (in ptexlive)
eightbit2hex() {
    echo "[to hex] \$TEXMF/$1/$2"
    test -d "$TEXMF/p$1" || mkdir -p "$TEXMF/p$1"
    perl -p -e 's/([\x80-\xff])/sprintf("^^%x", ord $1)/eg' \
        < "$TEXMFDIST/$1/$2" > "$TEXMF/p$1/$2" || exit 1
}

zcp() {
    echo "[to hex and copy] \$TEXMF/ptex/generic/hyphen/$1"
    perl -p -e 's/([\x80-\xff])/sprintf("^^%x", ord $1)/eg' < "hyphen/$1" \
        > "$TEXMF/ptex/generic/hyphen/$1" || exit 1
}

# from CTAN/hyphen
eightbit2hex tex/generic/hyph-utf8/loadhyph loadhyph-grc.tex

cd $SRC
#german
zcp dehyphtex.tex
#bulgarian
zcp bghyphen.tex
zcp catmik.tex
zcp mik2t2.tex
zcp bghyphsi.tex
#croatian
zcp hrhyph.tex
#czech
zcp czhyph.tex
#hungarian
zcp huhyphen.tex
#icelandic
zcp icehyph.tex
#mongolian
zcp mnhyphen.tex
zcp mnhyphn.tex
#russian
echo "[unpack] ruhyphen.zip"
(cd $SRC/hyphen && unzip -o ruhyphen.zip &>/dev/null)
mkdir -p $TEXMF/ptex/generic/hyphen/ruhyphen
zcp ruhyphen/catkoi.tex
zcp ruhyphen/enrhm2.tex
zcp ruhyphen/ruhyphal.tex
zcp ruhyphen/cyryoal.tex
zcp ruhyphen/hypht2.tex
zcp ruhyphen/ruhyphas.tex
zcp ruhyphen/cyryoas.tex  
zcp ruhyphen/koi2koi.tex 
zcp ruhyphen/ruhyphct.tex
zcp ruhyphen/cyryoct.tex  
zcp ruhyphen/koi2lcy.tex 
zcp ruhyphen/ruhyphdv.tex
zcp ruhyphen/cyryodv.tex  
zcp ruhyphen/koi2ot2.tex 
zcp ruhyphen/ruhyphen.tex
zcp ruhyphen/cyryomg.tex  
zcp ruhyphen/koi2t2a.tex 
zcp ruhyphen/ruhyphmg.tex
zcp ruhyphen/cyryovl.tex  
zcp ruhyphen/koi2ucy.tex
zcp ruhyphen/ruhyphvl.tex
zcp ruhyphen/cyryozn.tex  
zcp ruhyphen/ruenhyph.tex  
zcp ruhyphen/ruhyphzn.tex
rm -rf hyphen/ruhyphen
#serbian
zcp srhyphc.tex
#turkish
zcp trhyph.tex
#uppersorbian 
zcp sorhyph.tex
#ukrainian
eightbit2hex tex/generic/ukrhyph/ catlcy.tex
eightbit2hex tex/generic/ukrhyph/ lcy2koi.tex
eightbit2hex tex/generic/ukrhyph/ lcy2lcy.tex
eightbit2hex tex/generic/ukrhyph/ lcy2ot2.tex
eightbit2hex tex/generic/ukrhyph/ lcy2t2a.tex
eightbit2hex tex/generic/ukrhyph/ lcy2ucy.tex
eightbit2hex tex/generic/ukrhyph/ rules60.tex
eightbit2hex tex/generic/ukrhyph/ rules90.tex
eightbit2hex tex/generic/ukrhyph/ rules_ph.tex
eightbit2hex tex/generic/ukrhyph/ ukrenhyp.tex
eightbit2hex tex/generic/ukrhyph/ ukrhypfa.tex
eightbit2hex tex/generic/ukrhyph/ ukrhyph.koi
eightbit2hex tex/generic/ukrhyph/ ukrhyph.lcy
eightbit2hex tex/generic/ukrhyph/ ukrhyph.ot2
eightbit2hex tex/generic/ukrhyph/ ukrhyph.t2a
eightbit2hex tex/generic/ukrhyph/ ukrhyph.tex
eightbit2hex tex/generic/ukrhyph/ ukrhyph.ucy
eightbit2hex tex/generic/ukrhyph/ ukrhypmp.tex
eightbit2hex tex/generic/ukrhyph/ ukrhypmt.tex
eightbit2hex tex/generic/ukrhyph/ ukrhypsm.tex
eightbit2hex tex/generic/ukrhyph/ ukrhypst.tex

eightbit2hex tex/generic/hyph-utf8/patterns hyph-ca.tex
eightbit2hex tex/generic/hyph-utf8/patterns hyph-zh-latn.tex
eightbit2hex tex/generic/hyph-utf8/patterns hyph-da.tex
eightbit2hex tex/generic/hyph-utf8/patterns hyph-nl.tex
eightbit2hex tex/generic/hyph-utf8/patterns hyph-eo.tex
eightbit2hex tex/generic/hyph-utf8/patterns hyph-fi.tex
eightbit2hex tex/generic/hyph-utf8/patterns hyph-fr.tex
eightbit2hex tex/generic/hyph-utf8/patterns hyph-gl.tex
eightbit2hex tex/generic/hyph-utf8/patterns hyph-ga.tex
eightbit2hex tex/generic/hyph-utf8/patterns hyph-no.tex
eightbit2hex tex/generic/hyph-utf8/patterns hyph-pl.tex
eightbit2hex tex/generic/hyph-utf8/patterns hyph-pt.tex
eightbit2hex tex/generic/hyph-utf8/patterns hyph-es.tex
eightbit2hex tex/generic/hyph-utf8/patterns hyph-sv.tex
eightbit2hex tex/generic/hyph-utf8/patterns hyph-cy.tex
eightbit2hex tex/generic/hyph-utf8/patterns hyph-ro.tex
eightbit2hex tex/generic/hyph-utf8/patterns hyph-la.tex
eightbit2hex tex/generic/hyph-utf8/patterns hyph-eu.tex

echo " "
echo "[copy  ] eptex.src, euptex.src, eptexdefs.lib"
cp $CMP_TEMP/texlive-*-source/texk/web2c/eptex-*/*.src $TEXMF/ptex/plain/base/
cp $CMP_TEMP/texlive-*-source/texk/web2c/eptex-*/eptexdefs.lib $TEXMF/ptex/plain/base/

mkdir -p $CMP_TEMP/pl
echo "[copy  ] pltotf etc. for utf / otf package"
cp $CMP_TEMP/texlive-*-source/inst/bin/*/ppltotf $CMP_TEMP/pl/pltotf
cp $CMP_TEMP/texlive-*-source/inst/bin/*/uppltotf $CMP_TEMP/pl/
cp $CMP_TEMP/texlive-*-source/inst/bin/*/ovp2ovf $CMP_TEMP/pl/
cp $CMP_TEMP/texlive-*-source/inst/bin/*/opl2ofm $CMP_TEMP/pl/
echo "[unpack] ptexlive-*.tar.gz"
cd $CMP_TEMP
$TAR zxf $SRC/ptexlive-*.tar.gz 
echo "[unpack] jis.tar.gz"
$TAR xf ptexlive-*/archive/jis.tar.gz 
cp -r jis/tfm/ptex/*.tfm $TEXMF/fonts/tfm/ptex/
cp -r jis/vf/*.vf $TEXMF/fonts/vf/ptex/
mkdir -p $TEXMF/fonts/map/dvips/
cp jis/jis.map $TEXMF/fonts/map/dvips/
rm -rf jis/
echo "[unpack] morisawa.tar.gz"
$TAR xf ptexlive-*/archive/morisawa.tar.gz 
cp morisawa/tfm/ptex/*.tfm  $TEXMF/fonts/tfm/ptex/
cp morisawa/vf/*.vf $TEXMF/fonts/vf/ptex/
cp morisawa/morisawa.map $TEXMF/fonts/map/dvips/
rm -rf morisawa/
echo "[macro ] jsclasses"
mkdir -p $TEXMF/ptex/platex/jsclasses
cd $TEXMF/ptex/platex/jsclasses
unzip -o $CMP_TEMP/uptex-$UPTEX_VER/patch/jsclasses-*.zip  &>/dev/null
echo "[macro ] utf"
mkdir -p $TEXMF/ptex/platex/utf
cd $TEXMF/ptex/platex/utf
unzip -o $CMP_TEMP/ptexlive-*/macro/utfsrc.zip  &>/dev/null
$PATCH -p0 < $CMP_TEMP/ptexlive-*/macro/utfsrc-speedup.patch  &>/dev/null
$PATCH -p0 < $CMP_TEMP/uptex-$UPTEX_VER/patch/utfsrc_uptex-0.08.patch &>/dev/null
(cd utfsrc || exit; PATH="$CMP_TEMP/pl:$PATH" ./makeutf)
mkdir -p ../../../fonts/tfm/utf
mv utfsrc/tfm/* ../../../fonts/tfm/utf
mkdir -p ../../../fonts/vf/utf
mv utfsrc/vf/* ../../../fonts/vf/utf
mv utfsrc/sty/* .
rm -rf utfsrc/  

if test "$OTFINST" = "1"; then
  mkdir -p $TEXMF/ptex/platex/otf
  cd $TEXMF/ptex/platex/otf
  unzip -o $CMP_TEMP/ptexlive-*/macro/otfstable.zip  &>/dev/null
  $PATCH -p0 < $CMP_TEMP/ptexlive-*/macro/otfstable-speedup.patch &>/dev/null
  $TAR zxf $CMP_TEMP/uptex-$UPTEX_VER/patch/otfstable-uptex-0.03.tar.gz 
  (cd otfstable/fontmap/ || exit
  mv "ckt.map(for udvips)"         ckt.map
  mv "cktx.map(for dvipdfmx)"      cktx.map
  mv "hiragino.map(for udvips)"    hiragino.map
  mv "hiraginox.map(for dvipdfmx)" hiraginox.map
  mv "morisawa.map(for udvips)"    morisawa.map
  mv "morisawax.map(for dvipdfmx)" morisawax.map
  )
  (cd otfstable || exit; PATH="$CMP_TEMP/pl:$PATH" ./makeotf ;\
     PATH="$PATH:$CMP_TEMP/pl" ./umakeotf)
  mkdir -p ../../../fonts/ofm/otf
  mv otfstable/ofm/* ../../../fonts/ofm/otf
  mkdir -p ../../../fonts/tfm/otf
  mv otfstable/tfm/* ../../../fonts/tfm/otf
  mkdir -p ../../../fonts/vf/otf
  mv otfstable/vf/* ../../../fonts/vf/otf
  mv otfstable/sty/* .
  cat otfstable/fontmap/hiraginox.map  \
    | sed "s/\(W.\)$/\1.otf/g" > ../../../fonts/map/dvipdfmx/otf-hiragino.map  
  cp otfstable/fontmap/kozukax.map  ../../../fonts/map/dvipdfmx/otf-kozuka.map
  cp otfstable/fontmap/morisawax.map  ../../../fonts/map/dvipdfmx/otf-morisawa.map
  cat <<EOF > ../../../fonts/map/dvipdfmx/otf-noEmbed.map || exit
% OTF for dvipdfmx

%%%%% min %%%%%
otf-ujmr-h      UniJIS-UTF16-H   !Ryumin-Light
otf-ujmr-v      UniJIS-UTF16-V   !Ryumin-Light
otf-cjmr-h      Identity-H       !Ryumin-Light
otf-cjmr-v      Identity-V       !Ryumin-Light
hminr-h         H                !Ryumin-Light
hminr-v         V                !Ryumin-Light
uphminr-h       UniJIS-UTF16-H   !Ryumin-Light
uphminr-v       UniJIS-UTF16-V   !Ryumin-Light

%%%%% goth %%%%%
otf-ujgr-h      UniJIS-UTF16-H   !GothicBBB-Medium
otf-ujgr-v      UniJIS-UTF16-V   !GothicBBB-Medium
otf-cjgr-h      Identity-H       !GothicBBB-Medium
otf-cjgr-v      Identity-V       !GothicBBB-Medium
hgothr-h        H                !GothicBBB-Medium
hgothr-v        V                !GothicBBB-Medium
uphgothr-h      UniJIS-UTF16-H   !GothicBBB-Medium
uphgothr-v      UniJIS-UTF16-V   !GothicBBB-Medium

%%%%% bold min %%%%%
otf-ujmb-h      UniJIS-UTF16-H   !Ryumin-Light,Bold
otf-ujmb-v      UniJIS-UTF16-V   !Ryumin-Light,Bold
otf-cjmb-h      Identity-H       !Ryumin-Light,Bold
otf-cjmb-v      Identity-V       !Ryumin-Light,Bold
hminb-h         H                !Ryumin-Light,Bold
hminb-v         V                !Ryumin-Light,Bold
uphminb-h       UniJIS-UTF16-H   !Ryumin-Light,Bold
uphminb-v       UniJIS-UTF16-V   !Ryumin-Light,Bold

%%%%% bold goth %%%%%
otf-ujgb-h      UniJIS-UTF16-H   !GothicBBB-Medium,Bold
otf-ujgb-v      UniJIS-UTF16-V   !GothicBBB-Medium,Bold
otf-cjgb-h      Identity-H       !GothicBBB-Medium,Bold
otf-cjgb-v      Identity-V       !GothicBBB-Medium,Bold
hgothb-h        H                !GothicBBB-Medium,Bold
hgothb-v        V                !GothicBBB-Medium,Bold
uphgothb-h      UniJIS-UTF16-H   !GothicBBB-Medium,Bold
uphgothb-v      UniJIS-UTF16-V   !GothicBBB-Medium,Bold

%%%%% maru goth %%%%%
otf-ujmgr-h     UniJIS-UTF16-H   !Ryumin-Light        
otf-ujmgr-v     UniJIS-UTF16-V   !Ryumin-Light
otf-cjmgr-h     Identity-H       !Ryumin-Light
otf-cjmgr-v     Identity-V       !Ryumin-Light
hmgothr-h       H                !Ryumin-Light
hmgothr-v       V                !Ryumin-Light
uphmgothr-h     UniJIS-UTF16-H   !Ryumin-Light
uphmgothr-v     UniJIS-UTF16-V   !Ryumin-Light
EOF

  cat ../../../fonts/map/dvipdfmx/otf-noEmbed.map  \
    | sed "s/\!Ryumin-Light/ipam.ttf/g;s/\!GothicBBB-Medium/ipag.ttf/g" \
    > ../../../fonts/map/dvipdfmx/otf-ipa.map  
  cat <<EOF > ../../../fonts/map/dvipdfmx/otf-cktx.map || exit
% OTF for dvipdfmx

%%%%% traditional Chinese -- serif %%%%%
otf-utmr-h      UniCNS-UTF16-H  !MSung-Light
otf-utmr-v      UniCNS-UTF16-V  !MSung-Light
otf-ctmr-h      Identity-H      !MSung-Light
otf-ctmr-v      Identity-V      !MSung-Light

%%%%% traditional Chinese -- sans serif %%%%%
otf-utgr-h      UniCNS-UTF16-H  !MHei-Medium
otf-utgr-v      UniCNS-UTF16-V  !MHei-Medium
otf-ctgr-h      Identity-H      !MHei-Medium
otf-ctgr-v      Identity-V      !MHei-Medium

%%%%% simplified Chinese -- serif %%%%%
otf-ucmr-h      UniGB-UTF16-H   !STSong-Light
otf-ucmr-v      UniGB-UTF16-V   !STSong-Light
otf-ccmr-h      Identity-H      !STSong-Light
otf-ccmr-v      Identity-V      !STSong-Light

%%%%% simplified Chinese -- sans serif %%%%%
otf-ucgr-h      UniGB-UTF16-H   !STHeitiStd-Regular
otf-ucgr-v      UniGB-UTF16-V   !STHeitiStd-Regular
otf-ccgr-h      Identity-H      !STHeitiStd-Regular
otf-ccgr-v      Identity-V      !STHeitiStd-Regular

%%%%% hangeul -- serif %%%%%
otf-ukmr-h      UniKS-UTF16-H   !HYSMyeongJo-Medium
otf-ukmr-v      UniKS-UTF16-V   !HYSMyeongJo-Medium
otf-ckmr-h      Identity-H      !HYSMyeongJo-Medium
otf-ckmr-v      Identity-V      !HYSMyeongJo-Medium

%%%%% hangeul -- sans serif %%%%%
otf-ukgr-h      UniKS-UTF16-H   !HYGoThic-Medium
otf-ukgr-v      UniKS-UTF16-V   !HYGoThic-Medium
otf-ckgr-h      Identity-H      !HYGoThic-Medium
otf-ckgr-v      Identity-V      !HYGoThic-Medium
EOF

  rm -rf otfstable/
fi

echo "[clean ] pltotf etc. for utf / otf package"
rm -rf $CMP_TEMP/pl 
cd $SRC

echo "[make  ] Chinese / Korean font map for dvipdfmx"
cat <<EOF >> $TEXMF/fonts/map/dvipdfmx/otf-cktx.map 
%%
%% upTeX
%%

upstsl-h	UniGB-UTF16-H		!STSong-Light
upstsl-v	UniGB-UTF16-V		!STSong-Light
upstht-h	UniGB-UTF16-H		!STHeiti-Regular
upstht-v	UniGB-UTF16-V		!STHeiti-Regular
upmsl-h		UniCNS-UTF16-H		!MSung-Light
upmsl-v		UniCNS-UTF16-V		!MSung-Light
upmhm-h		UniCNS-UTF16-H		!MHei-Medium
upmhm-v		UniCNS-UTF16-V		!MHei-Medium
uphysmjm-h	UniKS-UTF16-H		!HYSMyeongJo-Medium
uphysmjm-v	UniKS-UTF16-V		!HYSMyeongJo-Medium
uphygt-h	UniKS-UTF16-H		!HYGoThic-Medium
uphygt-v	UniKS-UTF16-V		!HYGoThic-Medium
EOF

echo "[patch ] font map for dvipdfmx ..."
cat <<EOF >> $TEXMF/fonts/map/dvipdfmx/otf-noEmbed.map

% UTF for dvipdfmx

unijmin-h   UniJIS-UTF16-H    !Ryumin-Light
unijmin-v   UniJIS-UTF16-V    !Ryumin-Light
cidmin-h    Identity-H        !Ryumin-Light
cidmin-v    Identity-V        !Ryumin-Light
hmr         H                 !Ryumin-Light
hmrv        V                 !Ryumin-Light

unijgoth-h  UniJIS-UTF16-H    !GothicBBB-Medium
unijgoth-v  UniJIS-UTF16-V    !GothicBBB-Medium
cidgoth-h   Identity-H        !GothicBBB-Medium
cidgoth-v   Identity-V        !GothicBBB-Medium
hkb         H                 !GothicBBB-Medium
hkbv        V                 !GothicBBB-Medium

%%
%% upTeX
%%

urml		UniJIS-UTF16-H		!Ryumin-Light
urmlv		UniJIS-UTF16-V		!Ryumin-Light
ugbm		UniJIS-UTF16-H		!GothicBBB-Medium
ugbmv		UniJIS-UTF16-V		!GothicBBB-Medium

uprml-h		UniJIS-UTF16-H		!Ryumin-Light
uprml-v		UniJIS-UTF16-V		!Ryumin-Light
upgbm-h		UniJIS-UTF16-H		!GothicBBB-Medium
upgbm-v		UniJIS-UTF16-V		!GothicBBB-Medium
uprml-hq	UniJIS-UCS2-H		!Ryumin-Light
upgbm-hq	UniJIS-UCS2-H		!GothicBBB-Medium
EOF

cat <<EOF >> $TEXMF/fonts/map/dvipdfmx/otf-morisawa.map

% UTF for dvipdfmx

unijmin-h   UniJIS-UTF16-H    A-OTF-RyuminPro-Light.otf
unijmin-v   UniJIS-UTF16-V    A-OTF-RyuminPro-Light.otf
cidmin-h    Identity-H        A-OTF-RyuminPro-Light.otf
cidmin-v    Identity-V        A-OTF-RyuminPro-Light.otf
hmr         H                 A-OTF-RyuminPro-Light.otf
hmrv        V                 A-OTF-RyuminPro-Light.otf

unijgoth-h  UniJIS-UTF16-H    A-OTF-GothicBBBPro-Medium.otf
unijgoth-v  UniJIS-UTF16-V    A-OTF-GothicBBBPro-Medium.otf
cidgoth-h   Identity-H        A-OTF-GothicBBBPro-Medium.otf
cidgoth-v   Identity-V        A-OTF-GothicBBBPro-Medium.otf
hkb         H                 A-OTF-GothicBBBPro-Medium.otf
hkbv        V                 A-OTF-GothicBBBPro-Medium.otf

%%
%% upTeX
%%

urml		UniJIS-UTF16-H		A-OTF-RyuminPro-Light.otf
urmlv		UniJIS-UTF16-V		A-OTF-RyuminPro-Light.otf
ugbm		UniJIS-UTF16-H		A-OTF-GothicBBBPro-Medium.otf
ugbmv		UniJIS-UTF16-V		A-OTF-GothicBBBPro-Medium.otf

uprml-h		UniJIS-UTF16-H		A-OTF-RyuminPro-Light.otf
uprml-v		UniJIS-UTF16-V		A-OTF-RyuminPro-Light.otf
upgbm-h		UniJIS-UTF16-H		A-OTF-GothicBBBPro-Medium.otf
upgbm-v		UniJIS-UTF16-V		A-OTF-GothicBBBPro-Medium.otf
uprml-hq	UniJIS-UCS2-H		A-OTF-RyuminPro-Light.otf
upgbm-hq	UniJIS-UCS2-H		A-OTF-GothicBBBPro-Medium.otf
EOF

cat <<EOF >> $TEXMF/fonts/map/dvipdfmx/otf-kozuka.map

% UTF for dvipdfmx

unijmin-h   UniJIS-UTF16-H    KozMinPro-Regular-Acro.otf
unijmin-v   UniJIS-UTF16-V    KozMinPro-Regular-Acro.otf
cidmin-h    Identity-H        KozMinPro-Regular-Acro.otf
cidmin-v    Identity-V        KozMinPro-Regular-Acro.otf
hmr         H                 KozMinPro-Regular-Acro.otf
hmrv        V                 KozMinPro-Regular-Acro.otf

unijgoth-h  UniJIS-UTF16-H    KozGoStd-Regular.otf
unijgoth-v  UniJIS-UTF16-V    KozGoStd-Regular.otf
cidgoth-h   Identity-H        KozGoStd-Regular.otf
cidgoth-v   Identity-V        KozGoStd-Regular.otf
hkb         H                 KozGoStd-Regular.otf
hkbv        V                 KozGoStd-Regular.otf

%%
%% upTeX
%%

urml		UniJIS-UTF16-H		KozMinPro-Regular-Acro.otf
urmlv		UniJIS-UTF16-V		KozMinPro-Regular-Acro.otf
ugbm		UniJIS-UTF16-H		KozGoStd-Regular.otf
ugbmv		UniJIS-UTF16-V		KozGoStd-Regular.otf

uprml-h		UniJIS-UTF16-H		KozMinPro-Regular-Acro.otf
uprml-v		UniJIS-UTF16-V		KozMinPro-Regular-Acro.otf
upgbm-h		UniJIS-UTF16-H		KozGoStd-Regular.otf
upgbm-v		UniJIS-UTF16-V		KozGoStd-Regular.otf
uprml-hq	UniJIS-UCS2-H		KozMinPro-Regular-Acro.otf
upgbm-hq	UniJIS-UCS2-H		KozGoStd-Regular.otf
EOF

cat <<EOF >> $TEXMF/fonts/map/dvipdfmx/otf-ipa.map

% UTF for dvipdfmx

unijmin-h   UniJIS-UTF16-H    ipam.ttf
unijmin-v   UniJIS-UTF16-V    ipam.ttf
cidmin-h    Identity-H        ipam.ttf
cidmin-v    Identity-V        ipam.ttf
hmr         H                 ipam.ttf
hmrv        V                 ipam.ttf

unijgoth-h  UniJIS-UTF16-H    ipag.ttf
unijgoth-v  UniJIS-UTF16-V    ipag.ttf
cidgoth-h   Identity-H        ipag.ttf
cidgoth-v   Identity-V        ipag.ttf
hkb         H                 ipag.ttf
hkbv        V                 ipag.ttf

%%
%% upTeX
%%

urml		UniJIS-UTF16-H		ipam.ttf
urmlv		UniJIS-UTF16-V		ipam.ttf
ugbm		UniJIS-UTF16-H		ipag.ttf
ugbmv		UniJIS-UTF16-V		ipag.ttf

uprml-h		UniJIS-UTF16-H		ipam.ttf
uprml-v		UniJIS-UTF16-V		ipam.ttf
upgbm-h		UniJIS-UTF16-H		ipag.ttf
upgbm-v		UniJIS-UTF16-V		ipag.ttf
uprml-hq	UniJIS-UCS2-H		ipam.ttf
upgbm-hq	UniJIS-UCS2-H		ipag.ttf
EOF

cat <<EOF >> $TEXMF/fonts/map/dvipdfmx/otf-hiragino.map

% UTF for dvipdfmx

unijmin-h   UniJIS-UTF16-H    HiraMinPro-W3.otf
unijmin-v   UniJIS-UTF16-V    HiraMinPro-W3.otf
cidmin-h    Identity-H        HiraMinPro-W3.otf
cidmin-v    Identity-V        HiraMinPro-W3.otf
hmr         H                 HiraMinPro-W3.otf
hmrv        V                 HiraMinPro-W3.otf

unijgoth-h  UniJIS-UTF16-H    HiraKakuPro-W6.otf
unijgoth-v  UniJIS-UTF16-V    HiraKakuPro-W6.otf
cidgoth-h   Identity-H        HiraKakuPro-W6.otf
cidgoth-v   Identity-V        HiraKakuPro-W6.otf
hkb         H                 HiraKakuPro-W6.otf
hkbv        V                 HiraKakuPro-W6.otf

%%
%% upTeX
%%

urml		UniJIS-UTF16-H		HiraMinPro-W3.otf
urmlv		UniJIS-UTF16-V		HiraMinPro-W3.otf
ugbm		UniJIS-UTF16-H		HiraKakuPro-W6.otf
ugbmv		UniJIS-UTF16-V		HiraKakuPro-W6.otf

uprml-h		UniJIS-UTF16-H		HiraMinPro-W3.otf
uprml-v		UniJIS-UTF16-V		HiraMinPro-W3.otf
upgbm-h		UniJIS-UTF16-H		HiraKakuPro-W6.otf
upgbm-v		UniJIS-UTF16-V		HiraKakuPro-W6.otf
uprml-hq	UniJIS-UCS2-H		HiraMinPro-W3.otf
upgbm-hq	UniJIS-UCS2-H		HiraKakuPro-W6.otf
EOF

