
# Makefile fragment for upTeX and web2c. 

Makefile: $(srcdir)/euptexdir/euptex.mk

euptex = @JPTEX@ euptex 

# The C sources.
euptex_c = euptexini.c euptex0.c euptex1.c euptex2.c
euptex_o = euptexini.o euptex0.o euptex1.o euptex2.o \
	    euptex-pool.o euptexextra.o euptexdir/kanji.o
euplib_o = euptexdir/printversion.o euptexdir/usage.o euptexdir/openclose.o
euplib   = euptexdir/plib.a

# Making euptex.
euptex: $(euptex_o) $(euplib) $(ptexenc)
	$(kpathsea_link) $(euptex_o) $(euplib) $(ptexenc) $(socketlibs) $(LOADLIBES)


# C file dependencies
versions = eptexdir/eptex.version uptexdir/uptex.version ptexdir/ptex.version 
$(euptex_c) euptexcoerce.h euptexd.h: euptex.p $(web2c_texmf)
	test -d euptexdir || mkdir euptexdir
	$(web2c) euptex
euptexextra.c: euptexdir/euptexextra.h lib/texmfmp.c
	sed s/TEX-OR-MF-OR-MP/euptex/ $(srcdir)/lib/texmfmp.c >$@
euptexdir/euptexextra.h: $(srcdir)/euptexdir/ptexextra.in $(versions)
	cat $(srcdir)/euptexdir/ptexextra.in \
         | sed s/PTEX-VERSION/`cat ptexdir/ptex.version`/ \
         | sed s/UPTEX-VERSION/`cat uptexdir/uptex.version`/ \
         | sed s/EPTEX-VERSION/`cat eptexdir/eptex.version`/ >$@

# Tangling
euptex.p euptex.pool: tangle euptex.web
	$(TANGLE) euptex.web 

# Generation of the web and ch file.
#   Rules:
euptex.web: tie etex.p
	$(TIE) -m euptex.web etex.web etex.ch $(srcdir)/euptexdir/euptex-base.ch \
          $(srcdir)/euptexdir/ptex-include.ch \
          $(srcdir)/euptexdir/fam256.ch
euptex-pool.c: euptex.pool $(makecpool) tmf-pool.h
	$(makecpool) euptex.pool $(srcdir)/tmf-pool.h >$@ || rm -f $@

$(euplib): $(euplib_o)
	rm -f $@
	$(AR) $(ARFLAGS) $@ $(euplib_o)
	$(RANLIB) $@

# Additional dependencies for relinking.
$(ptexenc):
	cd $(ptexenc_dir) && $(MAKE) libptexenc.la

# Cleaning up.
clean:: euptex-clean
euptex-clean:
	$(LIBTOOL) --mode=clean $(RM) $(euptex)
	rm -f $(euptex_o) $(euptex_c) euptexextra.c euptexcoerce.h euptexd.h
	rm -f euptexdir/euptexextra.h
	rm -f euptexdir/kanji.o $(euplib_o) $(euplib)
	rm -f euptex.p euptex.pool euptex.web euptex.ch
	rm -f euptex.fmt euptex.log
	rm -f hello.dvi hello.log xfoo.out openout.log one.two.log uno.log
	rm -f just.log batch.log write18.log mltextst.log texput.log
	rm -f missfont.log
	rm -rf tfm

# Dumps
all_eupfmts = euptex.fmt euplatex.fmt $(eupfmts)

dumps: @JPTEX@ eupfmts
eupfmts: $(all_eupfmts)

eupfmtdir = $(web2cdir)/euptex
$(eupfmtdir)::
	$(SHELL) $(top_srcdir)/../mkinstalldirs $(eupfmtdir)

euptex.fmt: euptex
	$(dumpenv) $(MAKE) progname=euptex files="euptex.src plain.tex umin10.tfm" prereq-check
	$(dumpenv) ./euptex -etex --progname=euptex --jobname=euptex --ini -kanji=uptex \*\\input euptex.src \\dump </dev/null

euplatex.fmt: uptex
	$(dumpenv) $(MAKE) progname=euplatex files="uplatex.ltx" prereq-check
	$(dumpenv) ./euptex -etex --progname=euplatex --jobname=euplatex --ini -kanji=uptex \*\\input euplatex.ltx </dev/null

# Install
install-euptex: install-euptex-exec install-euptex-data
install-euptex-exec: install-euptex-programs install-euptex-links
install-euptex-data: @FMU@ install-euptex-dumps
install-euptex-dumps: install-euptex-fmts

install-programs: @JPTEX@ install-euptex-programs
install-euptex-programs: $(euptex) $(bindir)
	for p in $(euptex); do $(INSTALL_LIBTOOL_PROG) $$p $(bindir); done

install-links: @JPTEX@ install-euptex-links
install-euptex-links: install-euptex-programs
	#cd $(bindir) && (rm -f pinitex pvirtex; \
	#  $(LN) ptex pinitex; $(LN) ptex pvirtex)

install-fmts: @JPTEX@ install-euptex-fmts
install-euptex-fmts: upfmts $(upfmtdir)
	eupfmts="$(all_eupfmts)"; \
	  for f in $$epfmts; do $(INSTALL_DATA) $$f $(eupfmtdir)/$$f; done
	eupfmts="$(eupfmts)"; \
	  for f in $$eupfmts; do base=`basename $$f .fmt`; \
	    (cd $(bindir) && (rm -f $$base; $(LN) euptex $$base)); done

install-data:: @JPTEX@ install-euptex-data
install-euptex-pool: euptex.pool $(texpooldir)
	$(INSTALL_DATA) euptex.pool $(texpooldir)/euptex.pool

# end of uptex.mk
