/**
 * 
 */
package jp.sourceforge.erep.gef.screen.command;

import jp.sourceforge.erep.model.diagram.DiagramFactory;
import jp.sourceforge.erep.model.diagram.Dimension;
import jp.sourceforge.erep.model.diagram.Node;
import jp.sourceforge.erep.model.diagram.Point;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

/**
 * @author shida
 * 
 */
public class ChangeXYCommand extends Command {

	private Node node;

	private Rectangle rectangle;

	private Point oldLocation;

	private Dimension oldSize;

	/**
	 * @param node
	 * @param rectangle
	 */
	public ChangeXYCommand(Node node, Rectangle rectangle) {
		super();
		this.node = node;
		this.rectangle = rectangle;
	}

	@Override
	public void execute() {
		super.execute();
		oldLocation = node.getLocation();
		oldSize = node.getSize();
		Dimension d = DiagramFactory.eINSTANCE.createDimension();
		d.setWidth(rectangle.width);
		d.setHeight(rectangle.height);
		node.setSize(d);
		Point p = DiagramFactory.eINSTANCE.createPoint();
		p.setX(rectangle.x);
		p.setY(rectangle.y);
		node.setLocation(p);
	}

	@Override
	public void undo() {
		super.undo();
		node.setLocation(oldLocation);
		node.setSize(oldSize);
	}
}
