/**
 * 
 */
package jp.sourceforge.erep.gef.screen.command;

import jp.sourceforge.erep.model.diagram.Container;
import jp.sourceforge.erep.model.diagram.DiagramFactory;
import jp.sourceforge.erep.model.diagram.Dimension;
import jp.sourceforge.erep.model.diagram.Node;
import jp.sourceforge.erep.model.diagram.Point;

import org.eclipse.gef.commands.Command;

/**
 * @author shida
 *
 */
public class CreateNodeCommand extends Command {

	private Node node;

	private Container container;
	
	private org.eclipse.draw2d.geometry.Point point;
	
	private org.eclipse.draw2d.geometry.Dimension dimension;
	
	private static final int PREFERED_SIZE_X = 100;
	
	private static final int PREFERED_SIZE_Y = 100;
	

	/**
	 * @param container
	 * @param node
	 * @param point
	 * @param dimension
	 */
	public CreateNodeCommand(Container container, Node node, org.eclipse.draw2d.geometry.Point point, org.eclipse.draw2d.geometry.Dimension dimension) {
		super();
		// TODO Auto-generated constructor stub
		this.container = container;
		this.dimension = dimension;
		this.node = node;
		this.point = point;
	}

	@SuppressWarnings("unchecked")
	@Override
	public void execute() {
		super.execute();
		Point p = DiagramFactory.eINSTANCE.createPoint();
		Dimension d = DiagramFactory.eINSTANCE.createDimension();
		p.setX(point.x);
		p.setY(point.y);
		if (dimension != null) {
			d.setWidth(dimension.width);
			d.setHeight(dimension.height);
		} else {
			if (node.getDefaultFigureSize() != null) {
				d = node.getDefaultFigureSize();
			} else {
				d.setWidth(PREFERED_SIZE_X);
				d.setHeight(PREFERED_SIZE_Y);					
			}
		}
		node.setLocation(p);
		node.setSize(d);
		container.getContain().add(node);
	}
	
	@Override
	public void undo() {
		super.undo();
		container.getContain().remove(node);
	}
}
