/**
 * 
 */
package jp.sourceforge.erep.gef.screen.command;

import jp.sourceforge.erep.model.diagram.Connector;
import jp.sourceforge.erep.model.diagram.Node;

import org.eclipse.gef.commands.Command;

/**
 * @author shida
 *
 */
public class DeleteConnectorCommand extends Command {

	private Connector connector;
	
	private Node source;
	
	private Node target;
	
	
	/**
	 * @param connector
	 */
	public DeleteConnectorCommand(Connector connector) {
		super();
		this.connector = connector;
	}

	@Override
	public boolean canExecute() {
		return connector.getSource() != null && connector.getTarget() != null;
	}
	
	@Override
	public void execute() {
		super.execute();
		source = connector.getSource();
		target = connector.getTarget();
		connector.setSource(null);
		connector.setTarget(null);
	}
	
	@Override
	public void undo() {
		super.undo();
		connector.setSource(source);
		connector.setTarget(target);
	}
}
