/**
 * 
 */
package jp.sourceforge.erep.gef.screen.command;

import jp.sourceforge.erep.model.diagram.Connector;
import jp.sourceforge.erep.model.diagram.Node;

import org.eclipse.gef.commands.Command;

/**
 * @author shida
 *
 */
public class ReconnectTargetCommand extends Command {

	private Connector connector;
	
	private Node target;
	
	private Node old;
	
	/**
	 * @param connector
	 * @param target
	 */
	public ReconnectTargetCommand(Connector connector, Node target) {
		super();
		this.connector = connector;
		this.target = target;
	}

	@Override
	public void execute() {
		super.execute();
		old = connector.getTarget();
		connector.setTarget(target);
	}
	
	@Override
	public void undo() {
		super.undo();
		connector.setTarget(old);
	}
}
