/**
 * 
 */
package jp.sourceforge.erep.gef.screen.part;


import java.util.HashSet;
import java.util.Set;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;

/**
 * @author shida
 *
 */
public abstract class BaseConnectorEditPart extends AbstractConnectionEditPart {


	public abstract void notifyChanged(Notification notification);
	
	@Override
	public void deactivate() {
		super.deactivate();
		for (Notifier n : notifiers) {
			removeNotifier(n);
		}
	}
	
	/**
	 * CxgĎIuWFNgǉ.
	 * @param notifier
	 */
	@SuppressWarnings("unchecked")
	public void addNotifier(Notifier notifier) {
		if (!notifier.eAdapters().contains(adapter)) {
			notifier.eAdapters().add(adapter);			
		}
	}
	
	/**
	 * CxgĎIuWFNg.
	 * @param notifier 
	 */
	public void removeNotifier(Notifier notifier) {
		if (notifier.eAdapters().contains(adapter)) {
			notifier.eAdapters().remove(adapter);
		}
	}
	private class GraphicalConnectionAdapter implements Adapter {
		private Notifier target;

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.emf.common.notify.Adapter#notifyChanged(org.eclipse.emf.common.notify.Notification)
		 */
		public void notifyChanged(Notification notification) {
			BaseConnectorEditPart.this.notifyChanged(notification);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.emf.common.notify.Adapter#getTarget()
		 */
		public Notifier getTarget() {
			return target;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.emf.common.notify.Adapter#setTarget(org.eclipse.emf.common.notify.Notifier)
		 */
		public void setTarget(Notifier newTarget) {
			target = newTarget;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.emf.common.notify.Adapter#isAdapterForType(java.lang.Object)
		 */
		public boolean isAdapterForType(Object type) {
			return type.equals(target);
		}

	}

	@Override
	protected void refreshVisuals() {
		updateVisuals();
		super.refreshVisuals();
	}
	
	protected void updateVisuals() {
		
	}
	
	private GraphicalConnectionAdapter adapter = new GraphicalConnectionAdapter();

	private Set<Notifier> notifiers = new HashSet<Notifier>();
	
}
