/**
 * 
 */
package jp.sourceforge.erep.gef.screen.part;

import java.util.List;

import jp.sourceforge.erep.gef.screen.policy.ContainerEditPolicy;
import jp.sourceforge.erep.model.diagram.Diagram;

import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ShortestPathConnectionRouter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.LayerConstants;

/**
 * @author shida
 *
 */
public class DiagramEditPart extends BaseGraphicalEditPart {

	/* (non-Javadoc)
	 * @see org.eclipse.gef.editparts.AbstractGraphicalEditPart#createFigure()
	 */
	@Override
	protected IFigure createFigure() {
		FreeformLayer layer = new FreeformLayer();
		layer.setLayoutManager(new FreeformLayout());
		setConnectionRouting(layer);
		return layer;
	}
	
	/**
	 * },tBMAɑ΂ăRlNV[eBOݒ肵܂.
	 * @param container
	 */
	private void setConnectionRouting(IFigure container) {
		ConnectionLayer layer = (ConnectionLayer) getLayer(LayerConstants.CONNECTION_LAYER);
		layer.setConnectionRouter(new ShortestPathConnectionRouter(container));
	}
	/* (non-Javadoc)
	 * @see org.eclipse.gef.editparts.AbstractEditPart#createEditPolicies()
	 */
	@Override
	protected void createEditPolicies() {
		installEditPolicy(EditPolicy.LAYOUT_ROLE, new ContainerEditPolicy());
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.common.notify.Adapter#notifyChanged(org.eclipse.emf.common.notify.Notification)
	 */
	public void notifyChanged(Notification notification) {
		refreshChildren();
	}

	@Override
	protected List getModelChildren() {
		return getDiagram().getContain();
	}
	
	private Diagram getDiagram() {
		return (Diagram) getModel();
	}
}
