/**
 * 
 */
package jp.sourceforge.erep.gef.screen.part;

import java.util.List;

import jp.sourceforge.erep.gef.screen.figure.NodeFigure;
import jp.sourceforge.erep.gef.screen.policy.ConnectNodeEditPolicy;
import jp.sourceforge.erep.gef.screen.policy.NodeComponentEditPolicy;
import jp.sourceforge.erep.model.diagram.Node;

import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;

/**
 * @author shida
 *
 */
public class NodeEditPart extends BaseGraphicalEditPart implements org.eclipse.gef.NodeEditPart {

	/* (non-Javadoc)
	 * @see org.eclipse.gef.editparts.AbstractGraphicalEditPart#createFigure()
	 */
	@Override
	protected IFigure createFigure() {
		NodeFigure figure = new NodeFigure();
		figure.setBackgroundColor(ColorConstants.lightGreen);
		figure.setLayoutManager(new XYLayout());
		figure.setFill(true);
		return figure;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gef.editparts.AbstractEditPart#createEditPolicies()
	 */
	@Override
	protected void createEditPolicies() {
//		installEditPolicy(EditPolicy.LAYOUT_ROLE, new ContainerEditPolicy());
		installEditPolicy(EditPolicy.COMPONENT_ROLE, new NodeComponentEditPolicy());
		installEditPolicy(EditPolicy.GRAPHICAL_NODE_ROLE, new ConnectNodeEditPolicy());
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.common.notify.Adapter#notifyChanged(org.eclipse.emf.common.notify.Notification)
	 */
	public void notifyChanged(Notification notification) {
		refreshVisuals();
		refreshSourceConnections();
		refreshTargetConnections();
		refreshChildren();
	}

	@Override
	protected List getModelChildren() {
		return getNode().getContain();
	}
	
	@Override
	protected List getModelSourceConnections() {
		return getNode().getOutgoing();
	}
	
	@Override
	protected List getModelTargetConnections() {
		return getNode().getIncoming();
	}
	
	public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
		return new ChopboxAnchor(getFigure());
	}

	public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
		return new ChopboxAnchor(getFigure());
	}

	public ConnectionAnchor getSourceConnectionAnchor(Request request) {
		return new ChopboxAnchor(getFigure());
	}

	public ConnectionAnchor getTargetConnectionAnchor(Request request) {
		return new ChopboxAnchor(getFigure());
	}
	
	private Node getNode() {
		return (Node) getModel();
	}
	
	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();
		Dimension dimension = new Dimension(getNode().getSize().getWidth(), getNode().getSize().getHeight());
		Point point = new Point(getNode().getLocation().getX(), getNode().getLocation().getY());
		Rectangle rectangle = new Rectangle(point, dimension);
		getFigure().setBounds(rectangle);
		((GraphicalEditPart) getParent()).setLayoutConstraint(this,
				getFigure(), rectangle);
	}
}
