/**
 * 
 */
package jp.sourceforge.erep.gef.screen.policy;

import java.util.Iterator;

import jp.sourceforge.erep.gef.screen.command.DeleteConnectorCommand;
import jp.sourceforge.erep.gef.screen.command.DeleteNodeCommand;
import jp.sourceforge.erep.model.diagram.Connector;
import jp.sourceforge.erep.model.diagram.Node;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.GroupRequest;

/**
 * @author shida
 * 
 */
public class NodeComponentEditPolicy extends ComponentEditPolicy {

	@Override
	protected Command createDeleteCommand(GroupRequest deleteRequest) {
		CompoundCommand command = new CompoundCommand("delete all selection");
		EditPart element = (EditPart) getHost();
		if (element.getModel() instanceof Node) {
			Node node = (Node) element.getModel();
			command.add(new DeleteNodeCommand(node));
			removeConnection(command, node);
			removeChildrenConnection(command, node);
		}
		return command;
	}

	private void removeChildrenConnection(CompoundCommand command, Node node) {
		for (Iterator iter = node.getContain().iterator(); iter.hasNext();) {
			Node element = (Node) iter.next();
			removeConnection(command, element);
			removeChildrenConnection(command, element);
		}
	}

	private void removeConnection(CompoundCommand command, Node node) {
		for (Iterator iterator = node.getIncoming().iterator(); iterator
				.hasNext();) {
			Connector c = (Connector) iterator.next();
			command.add(new DeleteConnectorCommand(c));
		}
		for (Iterator iterator = node.getOutgoing().iterator(); iterator
				.hasNext();) {
			Connector c = (Connector) iterator.next();
			command.add(new DeleteConnectorCommand(c));
		}
	}
}
