/**
 * 
 */
package jp.sourceforge.erep.gef.screen.tree.part;

import java.util.List;

import jp.sourceforge.erep.model.screen.Decision;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

/**
 * @author shida
 *
 */
public class DecisionTreeEditPart extends BaseTreeEditPart {

	private static final Image IMAGE = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(ISharedImages.IMG_OBJ_ELEMENT).createImage();
	
	/* (non-Javadoc)
	 * @see org.eclipse.emf.common.notify.Adapter#notifyChanged(org.eclipse.emf.common.notify.Notification)
	 */
	public void notifyChanged(Notification notification) {
		refreshVisuals();
		refreshChildren();
	}
	
	@SuppressWarnings("unchecked")
	@Override
	protected List getModelChildren() {
		return getDecision().getOutgoing();
	}

	private Decision getDecision() {
		return (Decision) getModel();
	}
	
	@Override
	protected String getText() {
		return "";
	}
	
	@Override
	protected Image getImage() {
		return IMAGE;
	}
}
