/*
 * ESE, a HyperText Transfer Protocol server
 * Copyright (C) 1996-2001 Akira Higuchi <a-higuti@math.sci.hokudai.ac.jp>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "esehttpd.h"

static unsigned char base64table[256];

static void
eh_base64_table_init (void)
{
  int i;
  for (i = 0; i < 256; i++) base64table[i] = 64;
  for (i = 'A'; i <= 'Z'; i++) base64table[i] = i - 'A';
  for (i = 'a'; i <= 'z'; i++) base64table[i] = i - 'a' + 26;
  for (i = '0'; i <= '9'; i++) base64table[i] = i - '0' + 52;
  base64table['+'] = 62;
  base64table['/'] = 63;
  base64table['='] = 0;
}

int
eh_base64_decode (char *str_signed) {
  int len, npad;
  char *padp;
  unsigned char *str, *rp, *wp;
  if (base64table['a'] == 0)
    eh_base64_table_init ();
  len = strlen (str_signed);
  if ((len & 0x03) != 0)
    return -1;
  if (len == 0)
    return 0;
  padp = strchr (str_signed, '=');
  if (padp && padp - str_signed < len - 2)
    return -1;
  npad = padp ? str_signed + len - padp : 0;
  if (npad == 2 && str_signed[len - 1] != '=')
    return -1;
  for (rp = wp = str = (unsigned char *)str_signed;
       rp < str + len; rp += 4, wp += 3) {
    unsigned long u0, u1, u2, u3;
    unsigned long val;
    u0 = base64table[rp[0]];
    u1 = base64table[rp[1]];
    u2 = base64table[rp[2]];
    u3 = base64table[rp[3]];
    if (u0 > 63 || u1 > 63 || u2 > 63 || u3 > 63)
      return -1;
    val = (u0 << 18) | (u1 << 12) | (u2 << 6) | u3;
    wp[0] = val >> 16;
    wp[1] = (val >> 8) & 0xff;
    wp[2] = val & 0xff;
  }
  wp[-npad] = '\0';
  return (wp - str) - npad;
}
