/*
 * ESE, a HyperText Transfer Protocol server
 * Copyright (C) 1996-2001 Akira Higuchi <a-higuti@math.sci.hokudai.ac.jp>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef EH_FILECACHE_H
#define EH_FILECACHE_H

struct eh_filecache_entry_s;

/*
  A filecache is basically a doubly linked list (first, ..., last).
  The list remove_delayed_entries contains entries that have removed from
  the list (first, ..., last) because of expiration but not freed because
  it's referred by wvec. The hash table cent_ht contains references for
  the members of the list (first, ..., last).
*/
   
typedef struct {
  int num_ent;
  int ent_max;
  struct eh_filecache_entry_s *first, *last;
  struct eh_filecache_entry_s *remove_delayed_entries;
  eh_strhash_t *cent_ht;        /* hash_map <char *, eh_filecache_entry_t *> */
} eh_filecache_t;

typedef struct eh_filecache_entry_s {
  eh_filecache_t *ef_backref;
  struct eh_filecache_entry_s *next, *prev;
  const char *hash_key_backref;
  char *header;
  void *body;
  size_t header_len;
  struct stat statbuf;
  time_t last_stat_call_time;
  const char *mime_type;
  size_t wvec_refcount;
  int remove_delayed_flag;
} eh_filecache_entry_t;

eh_filecache_t *eh_filecache_new (int ent_max);
void eh_filecache_delete (eh_filecache_t *ef);
eh_filecache_entry_t *eh_filecache_find (eh_filecache_t *ef,
					 const char *filename);
/* The argument malloced_header must be x_malloc'ed, and mapped_body
   mmap'ed. These are x_free/munmap'ed by filecache later. */
eh_filecache_entry_t *eh_filecache_insert (eh_filecache_t *ef,
					   const char *filename,
					   char *malloced_header,
					   size_t header_len,
					   void *mapped_body,
					   const struct stat *statbuf,
					   time_t last_stat_call_time,
					   const char *mime_type);
void eh_filecache_entry_set_last_stat_call_time (eh_filecache_entry_t *ent,
						 time_t last_stat_call_time);
void eh_filecache_entry_wvec_ref (eh_filecache_entry_t *ent);
void eh_filecache_entry_wvec_unref (void *ent);
int eh_filecache_get_num_entries (eh_filecache_t *ef);

#endif
