/*
 * ESE, a HyperText Transfer Protocol server
 * Copyright (C) 1996-2001 Akira Higuchi <a-higuti@math.sci.hokudai.ac.jp>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "modbase.h"
#include <fstream>

#include <sys/mman.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>

class eh_modbbs : public eh_modbase {
protected:
  string base_dirname;
  static string cached_body;
  static int cached_article_num;
protected:
  string int_to_string (int val) {
    char buffer[33];
    int r;
    r = snprintf (buffer, 32, "%d", val);
    buffer[32] = '\0';
    return string (buffer);
  }
  void run () {
    base_dirname = "";
    size_t ri = script_filename.rfind ('/');
    if (ri == script_filename.length ()) {
      do_get_notfound ();
      return;
    }
    base_dirname = string (&script_filename[0], ri);
    if (request_method == "POST")
      do_post ();
    else
      do_get ();
  }
  void do_get () {
    int len = base_dirname.length ();
    int len2 = script_filename.length ();
    string bname (&script_filename[len], &script_filename[len2]);
    if (bname == "/postform")
      do_get_postform ();
    else if (bname == "/")
      do_get_toppage ();
    else
      do_get_notfound ();
  }
  void do_get_notfound () {
    response.status = 404;
  }
  int save_file (string filename, string data) {
    string fn = base_dirname + "/" + filename;
    ofstream of (fn.c_str ());
    if (of.fail ())
      return -1;
    of << data << flush;
    if (of.fail ())
      return -1;
    return 0;
  }
  string load_file (string filename) {
    string fn = base_dirname + "/" + filename;
    int fd = ::open (fn.c_str (), O_RDONLY);
    if (fd < 0)
      return "";
    struct stat sbuf;
    if (::fstat (fd, &sbuf) < 0) {
      close (fd);
      return "";
    }
    void *ptr;
    if ((ptr = ::mmap (NULL, sbuf.st_size, PROT_READ, MAP_SHARED, fd, 0))
	== (void *)-1) {
      close (fd);
      return "";
    }
    string s ((char *)ptr, sbuf.st_size);
    ::munmap (ptr, sbuf.st_size);
    close (fd);
    return s;
  }
  int get_last_article_num () {
    string s = load_file ("last_article_num");
    if (s == "")
      return -1;
    return atoi (s.c_str ());
  }
  int set_last_article_num (int num) {
    string s = int_to_string (num);
    return save_file ("last_article_num", s);
  }
  void do_get_toppage () {
    response.status = 200;
    response.headers = "Content-Type: text/html\r\n";
    response.body = ""
      "<html>"
      "<head><title>ESE HTTP Server: ModBBS</title></head>\n"
      "<body>\n"
      "<H1>ESE HTTP Server: ModBBS</H1>\n";
    int last_article_num = get_last_article_num ();
    if (last_article_num == cached_article_num) {
      response.body = cached_body;
      return;
    }
    int fnum = last_article_num - 20;
    if (fnum < 0)
      fnum = 0;
    for (int i = last_article_num; i >= fnum; i--) {
      string s = int_to_string (i);
      string d = load_file (s);
      map <string, string> fdata = decode_form_data (d.data (),
						     d.data () + d.length ());
      response.body += "<hr>\n";
      response.body += "<h2>[" + int_to_string (i) + "] "
	+ escape_html (fdata["TITLE"]) + "</h2>\n";
      response.body += "<pre>" + escape_html (fdata["TEXT"]) + "</pre>\n";
    }
    response.body += "<hr>\n";
    response.body += "<a href=\"postform\">post a new article</a>\n";
    response.body += "</body></html>\n";
    cached_article_num = last_article_num;
    cached_body = response.body;
  }
  void do_get_postform () {
    response.status = 200;
    response.headers = "Content-Type: text/html\r\n";
    response.body += ""
      "<html>\n"
      "<head><title>ESE HTTP Server: ModBBS</title></head>\n"
      "<body>\n"
      "<form action=\"./postform\" method=\"post\">\n"
      "<p>Subject: <input name=\"TITLE\" value=\"\"></input></p>\n"
      "<p><textarea name=\"TEXT\" value=\"\" cols=\"70\" rows=\"10\">"
      "</textarea></p>\n"
      "<input type=\"submit\" value = \"Submit\"></input>\n"
      "</form>"
      "</body></html>";
  }
  void do_post () {
    int num = get_last_article_num () + 1;
    string s = int_to_string (num);
    string d (body_begin, body_end);
    if (save_file (s.c_str (), d) < 0) {
      do_post_failed ();
      return;
    }
    if (set_last_article_num (num) < 0) {
      do_post_failed ();
      return;
    }
    response.status = 302;
    response.headers = "Location: ./";
  }
  void do_post_failed () {
    response.status = 500;
  }
};

string eh_modbbs::cached_body;
int eh_modbbs::cached_article_num = -1;

REGISTER_HMOD("modbbs", eh_modbbs, 1);

