/*
 * ESE, a HyperText Transfer Protocol server
 * Copyright (C) 1996-2001 Akira Higuchi <a-higuti@math.sci.hokudai.ac.jp>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef EH_APP_H
#define EH_APP_H

typedef struct eh_app_s {
  eh_config_global_t *econf;
  eh_filecache_t *fcache;
  size_t filecache_threshold;
  size_t reply_count;
  int script_eval_count;
  pid_t *child;
  int num_child;
  int my_worker_id; /* -1: parent  non-negative: child */
  int num_vserver;
  int rlimit_nofile;
  eh_vserver_t *vserver;
} eh_app_t;

extern int debug;
extern int num_requests;

void eh_app_init (eh_app_t *app, const char *conffile);
void eh_app_start_servers (eh_app_t *app);
void eh_app_chroot_setuid (eh_app_t *app);
void eh_app_start_workers (eh_app_t *app);
int  eh_app_select_loop (eh_app_t *app);
void eh_app_increment_script_eval_count (eh_app_t *app);
void eh_app_discard (eh_app_t *app);

pid_t eh_app_fork_worker (eh_app_t *app, int worker_num);

#endif
