/*
 * ESE, a HyperText Transfer Protocol server
 * Copyright (C) 1996-2001 Akira Higuchi <a-higuti@math.sci.hokudai.ac.jp>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#if !defined(DEBUG) && !defined(NDEBUG)
#define NDEBUG
#endif

#include "config.h"

#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/mman.h>
#include <sys/uio.h>
#include <sys/poll.h>
#include <sys/param.h>
#include <netinet/tcp.h>
#include <fcntl.h>
#include <signal.h>
#include <netdb.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <stdarg.h>
#include <stddef.h>
#include <dirent.h>
#include <ctype.h>
#include <crypt.h>
#include <time.h>
#include <syslog.h>
#include <assert.h>
#include <regex.h>

#ifdef __cplusplus
/* hack */
#define PERL5
#endif
#include <openssl/ssl.h>
#include <openssl/err.h>
#include <openssl/rand.h>
#undef PERL5

#define ESEHTTPD_NAME "ESE/2"
#define ESEHTTPD_DEFAULT_TYPE "text/plain"
#define EH_READ_MAX 4096


#ifndef ESEHTTPD_SERVERROOT
#define ESEHTTPD_SERVERROOT PREFIX "/lib/esehttpd/"
#endif

#define ESEHTTPD_CONF ESEHTTPD_SERVERROOT "conf/esehttpd.conf"
#define ESEHTTPD_DOCUMENTROOT ESEHTTPD_SERVERROOT "www/html"
#define ESEHTTPD_TYPESCONFIG ESEHTTPD_SERVERROOT "conf/mime.types"
#define ESEHTTPD_LOGFILE ESEHTTPD_SERVERROOT "log/error_log"

#ifdef __cplusplus
extern "C" {
#endif
#include "mem.h"
#include "util.h"
#include "strhash.h"
#include "strbuf.h"
#include "log.h"
#include "fd.h"
#include "headers.h"
#include "filespool.h"
#include "conf.h"
#include "accesslog.h"
#include "filecache.h"
#include "request.h"
#include "rhandler.h"
#include "connection.h"
#include "reply.h"
#include "statuscode.h"
#include "static.h"
#include "html.h"
#include "directory.h"
#include "date.h"
#include "filemisc.h"
#include "mimetype.h"
#include "base64.h"
#include "auth.h"
#include "htaccess.h"
#include "vserver.h"
#include "app.h"
#include "cgicommon.h"
#ifdef __cplusplus
}
#endif
