/*
 * ESE, a HyperText Transfer Protocol server
 * Copyright (C) 1996-2001 Akira Higuchi <a-higuti@math.sci.hokudai.ac.jp>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "esehttpd.h"

static void
eh_hello_on_read_reqbody (eh_rhandler_t *eh, const char *buf, size_t buflen)
{
  eh_connection_t *ec = (eh_connection_t *)eh->extdata;
  assert (buflen <= eh->body_length_left);
  eh_debug ("");
  eh->body_length_left -= buflen;
  if (eh->body_length_left == 0) {
    eh_debug ("finish");
    eh_connection_request_finish (ec);
  }
}

static int
eh_hello_do_timeout (eh_rhandler_t *eh)
{
  return 1;
}

static void
eh_hello_on_delete (eh_rhandler_t *eh)
{
  eh_debug ("");
  x_free (eh);
}

eh_rhandler_t eh_hello_tmpl = {
  0, NULL,
  eh_hello_on_read_reqbody,
  eh_hello_do_timeout,
  eh_hello_on_delete,
};

eh_rhandler_t *
eh_rhandler_hello_new (struct eh_connection_s *ec, const eh_request_t *er,
		       void *rhfunc_data)
{
  int reqbody_len = 0;
  eh_rhandler_t *eh;
  const char *s;
  char *message = "<HTML><BODY>hello, world</BODY></HTML>";
  eh_debug ("");
  eh_connection_append_wvec_response (ec, er->method, "200",
				      "Content-Type: text/html\r\n",
				      message, strlen (message));
  s = er->headers.predef.content_length;
  if (s) {
    reqbody_len = atoi (s);
  }
  if (reqbody_len == 0) {
    eh_connection_request_finish (ec);
    return NULL;
  }
  eh = (eh_rhandler_t *)x_malloc (sizeof (*eh));
  memcpy (eh, &eh_hello_tmpl, sizeof (*eh));
  eh->body_length_left = reqbody_len;
  eh->extdata = (void *)ec;
  return eh;
}

REGISTER_HANDLER("hello", eh_rhandler_hello_new, NULL, 1);
