/*
 * Decompiled with CFR 0.152.
 */
package estoc.dbm;

import estoc.dbm.DataAccess;
import estoc.dbm.DataAccessImpl;
import estoc.dbm.DbType;
import estoc.dbm.SqlCreatorImpl;
import estoc.dbm.TableAccess;
import estoc.dbm.TableAccessDerby;
import estoc.dbm.TableAccessH2;
import java.sql.Connection;

public class AccessManager {
    private final DbType dbType;

    public AccessManager(DbType dbType) {
        if (dbType == null) {
            throw new IllegalArgumentException();
        }
        this.dbType = dbType;
    }

    public DataAccess getDataAccess(Connection connection) {
        SqlCreatorImpl sqlCreatorImpl = new SqlCreatorImpl();
        return new DataAccessImpl(connection, sqlCreatorImpl);
    }

    public TableAccess getTableAccess(Connection connection) {
        TableAccess tableAccess = null;
        switch (this.dbType) {
            case H2: {
                tableAccess = new TableAccessH2(connection);
                break;
            }
            case Derby: {
                tableAccess = new TableAccessDerby(connection);
                break;
            }
            default: {
                throw new UnsupportedOperationException("DbType=" + (Object)((Object)this.dbType));
            }
        }
        return tableAccess;
    }
}

