/*
 * Decompiled with CFR 0.152.
 */
package estoc.dbm;

import estoc.dbm.ColumnInfo;
import estoc.dbm.DataAccess;
import estoc.dbm.DbmUtil;
import estoc.dbm.SqlCreator;
import estoc.dbm.annotate.Table;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

class DataAccessImpl
implements DataAccess {
    private static final Logger LOG = Logger.getLogger("global");
    private final Connection connection;
    private final SqlCreator creator;
    Map<Class<?>, List<ColumnInfo>> fieldMap = new HashMap();
    Map<Class<?>, PreparedStatement> selectStmts = new HashMap();
    Map<Class<?>, PreparedStatement> insertStmts = new HashMap();
    Map<Class<?>, PreparedStatement> updateStmts = new HashMap();
    Map<Class<?>, PreparedStatement> deleteStmts = new HashMap();

    public DataAccessImpl(Connection connection, SqlCreator sqlCreator) {
        this.connection = connection;
        this.creator = sqlCreator;
    }

    private List<ColumnInfo> getDeclaredFields(Class<?> clazz) {
        List<ColumnInfo> list = this.fieldMap.get(clazz);
        if (list == null) {
            Field[] fieldArray;
            list = new ArrayList<ColumnInfo>();
            for (Field field : fieldArray = clazz.getDeclaredFields()) {
                list.add(new ColumnInfo(field));
            }
            this.fieldMap.put(clazz, list);
        }
        return list;
    }

    @Override
    public <T> T select(Class<T> clazz, Object ... objectArray) throws SQLException {
        PreparedStatement preparedStatement = this.selectStmts.get(clazz);
        if (preparedStatement == null || preparedStatement.getConnection() != this.connection) {
            preparedStatement = this.createSelectStmt(clazz);
        }
        this.setParams(preparedStatement, objectArray);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet != null && resultSet.next()) {
            return DbmUtil.fillData(clazz, resultSet);
        }
        return null;
    }

    private <T> PreparedStatement createSelectStmt(Class<T> clazz) throws SQLException {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        LinkedHashSet<String> linkedHashSet2 = new LinkedHashSet<String>();
        for (Field field : clazz.getDeclaredFields()) {
            ColumnInfo columnInfo = new ColumnInfo(field);
            if (!columnInfo.isColumn()) continue;
            linkedHashSet.add(field.getName());
            if (!columnInfo.isPk()) continue;
            linkedHashSet2.add(field.getName());
        }
        if (linkedHashSet2.size() == 0) {
            throw new UnsupportedOperationException("When if you use SELECT, table have to be defined PK");
        }
        String string = this.getTableName(clazz);
        String string2 = this.creator.getSelectSql(string, linkedHashSet2, linkedHashSet);
        PreparedStatement preparedStatement = this.connection.prepareStatement(string2);
        this.selectStmts.put(clazz, preparedStatement);
        return preparedStatement;
    }

    @Override
    public boolean delete(Object object) throws SQLException {
        Class<?> clazz = object.getClass();
        PreparedStatement preparedStatement = this.deleteStmts.get(clazz);
        if (preparedStatement == null || preparedStatement.getConnection() != this.connection) {
            preparedStatement = this.createDeleteStmt(clazz);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (ColumnInfo columnInfo : this.getDeclaredFields(clazz)) {
            if (!columnInfo.isPk()) continue;
            arrayList.add(DbmUtil.getVlaueFromField(object, columnInfo));
        }
        this.setParams(preparedStatement, arrayList.toArray());
        return preparedStatement.executeUpdate() == 1;
    }

    private PreparedStatement createDeleteStmt(Class<?> clazz) throws SQLException {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (ColumnInfo object2 : this.getDeclaredFields(clazz)) {
            if (!object2.isPk()) continue;
            linkedHashSet.add(object2.getName());
        }
        if (linkedHashSet.size() == 0) {
            throw new UnsupportedOperationException("When if you use DELETE, table have to be defined PK");
        }
        String string = this.getTableName(clazz);
        String string2 = this.creator.getDeleteSql(string, linkedHashSet);
        PreparedStatement preparedStatement = this.connection.prepareStatement(string2);
        this.deleteStmts.put(clazz, preparedStatement);
        return preparedStatement;
    }

    @Override
    public <T> T insert(T t) throws SQLException {
        Class<?> clazz = t.getClass();
        PreparedStatement preparedStatement = this.insertStmts.get(clazz);
        if (preparedStatement == null || preparedStatement.getConnection() != this.connection) {
            preparedStatement = this.createInsertStmt(clazz);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Date date = new Date();
        ArrayList<ColumnInfo> arrayList2 = new ArrayList<ColumnInfo>();
        ArrayList<ColumnInfo> arrayList3 = new ArrayList<ColumnInfo>();
        for (ColumnInfo object : this.getDeclaredFields(clazz)) {
            if (!object.isColumn()) continue;
            if (object.isAutoInc()) {
                arrayList2.add(object);
                continue;
            }
            if (object.isTimeStamp()) {
                arrayList3.add(object);
                arrayList.add(date);
                continue;
            }
            arrayList.add(DbmUtil.getVlaueFromField(t, object));
        }
        this.setParams(preparedStatement, arrayList.toArray());
        LOG.info("insert " + t.toString());
        if (preparedStatement.executeUpdate() == 1) {
            for (ColumnInfo columnInfo : arrayList3) {
                DbmUtil.setVlaueToField(t, columnInfo, date);
            }
            ResultSet resultSet = preparedStatement.getGeneratedKeys();
            for (ColumnInfo columnInfo : arrayList2) {
                Number number;
                if (!resultSet.next()) break;
                Object object = resultSet.getObject(1);
                if (object instanceof Integer) {
                    if (columnInfo.getType() == Integer.class) {
                        DbmUtil.setVlaueToField(t, columnInfo, object);
                        continue;
                    }
                    if (columnInfo.getType() == Long.class) {
                        number = ((Integer)object).longValue();
                        DbmUtil.setVlaueToField(t, columnInfo, number);
                        continue;
                    }
                    throw new UnsupportedOperationException("Unsupport type:" + columnInfo.getType());
                }
                if (object instanceof Long) {
                    if (columnInfo.getType() == Integer.class) {
                        number = ((Long)object).intValue();
                        DbmUtil.setVlaueToField(t, columnInfo, number);
                        continue;
                    }
                    if (columnInfo.getType() == Long.class) {
                        DbmUtil.setVlaueToField(t, columnInfo, object);
                        continue;
                    }
                    throw new UnsupportedOperationException("Unsupport type:" + columnInfo.getType());
                }
                throw new UnsupportedOperationException("Unsupport result type:" + object);
            }
            return t;
        }
        return null;
    }

    private PreparedStatement createInsertStmt(Class<?> clazz) throws SQLException {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (ColumnInfo object2 : this.getDeclaredFields(clazz)) {
            if (!object2.isColumn() || object2.isAutoInc()) continue;
            linkedHashSet.add(object2.getName());
        }
        String string = this.getTableName(clazz);
        String string2 = this.creator.getInsertSql(string, linkedHashSet);
        PreparedStatement preparedStatement = this.connection.prepareStatement(string2);
        this.insertStmts.put(clazz, preparedStatement);
        return preparedStatement;
    }

    @Override
    public <T> T update(T t) throws SQLException {
        Class<?> clazz = t.getClass();
        PreparedStatement preparedStatement = this.updateStmts.get(clazz);
        if (preparedStatement == null || preparedStatement.getConnection() != this.connection) {
            preparedStatement = this.createUpdateStmt(clazz);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<ColumnInfo> arrayList3 = new ArrayList<ColumnInfo>();
        Date date = new Date();
        for (ColumnInfo object : this.getDeclaredFields(clazz)) {
            if (object.isPk()) {
                arrayList2.add(DbmUtil.getVlaueFromField(t, object));
                continue;
            }
            if (!object.isColumn()) continue;
            if (object.isTimeStamp()) {
                arrayList3.add(object);
                arrayList.add(date);
                continue;
            }
            arrayList.add(DbmUtil.getVlaueFromField(t, object));
        }
        ArrayList arrayList4 = new ArrayList();
        arrayList4.addAll(arrayList);
        arrayList4.addAll(arrayList2);
        this.setParams(preparedStatement, arrayList4.toArray());
        LOG.info("update " + t.toString());
        if (preparedStatement.executeUpdate() == 1) {
            for (ColumnInfo columnInfo : arrayList3) {
                DbmUtil.setVlaueToField(t, columnInfo, date);
            }
            return t;
        }
        return null;
    }

    private PreparedStatement createUpdateStmt(Class<?> clazz) throws SQLException {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        LinkedHashSet<String> linkedHashSet2 = new LinkedHashSet<String>();
        for (ColumnInfo object2 : this.getDeclaredFields(clazz)) {
            if (object2.isPk()) {
                linkedHashSet.add(object2.getName());
                continue;
            }
            if (!object2.isColumn()) continue;
            linkedHashSet2.add(object2.getName());
        }
        if (linkedHashSet.size() == 0) {
            throw new UnsupportedOperationException("When if you use UPDATE, table have to be defined PK");
        }
        String string = this.getTableName(clazz);
        String string2 = this.creator.getUpdateSql(string, linkedHashSet, linkedHashSet2);
        PreparedStatement preparedStatement = this.connection.prepareStatement(string2);
        this.updateStmts.put(clazz, preparedStatement);
        return preparedStatement;
    }

    private String getTableName(Class<?> clazz) {
        Table table = clazz.getAnnotation(Table.class);
        return table.value();
    }

    private void setParams(PreparedStatement preparedStatement, Object[] objectArray) throws SQLException {
        int n = 1;
        for (Object object : objectArray) {
            Object object2;
            if (object instanceof String) {
                preparedStatement.setString(n, (String)object);
            } else if (object instanceof Date) {
                object2 = (Date)object;
                preparedStatement.setTimestamp(n, new Timestamp(((Date)object2).getTime()));
            } else if (object instanceof Integer) {
                preparedStatement.setInt(n, (Integer)object);
            } else if (object instanceof BigDecimal) {
                preparedStatement.setBigDecimal(n, (BigDecimal)object);
            } else if (object instanceof Double) {
                preparedStatement.setDouble(n, (Double)object);
            } else if (object instanceof Boolean) {
                preparedStatement.setBoolean(n, (Boolean)object);
            } else if (object instanceof byte[]) {
                object2 = new ByteArrayInputStream((byte[])object);
                preparedStatement.setBinaryStream(n, (InputStream)object2);
            } else if (object == null) {
                preparedStatement.setObject(n, null);
            } else {
                throw new UnsupportedOperationException("Unsupport type " + object);
            }
            ++n;
        }
    }
}

