/*
 * Decompiled with CFR 0.152.
 */
package estoc.dbm;

import estoc.dbm.ColumnInfo;
import estoc.dbm.annotate.Column;
import estoc.dbm.annotate.Table;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;

public abstract class TableAccess {
    private static final Logger LOG = Logger.getLogger("global");
    private final Connection connection;

    public abstract void drop(Class<?> var1) throws SQLException;

    public abstract void create(Class<?> var1) throws SQLException;

    public TableAccess(Connection connection) {
        try {
            if (connection == null || connection.isClosed()) {
                throw new IllegalArgumentException();
            }
            this.connection = connection;
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }

    protected String getTableName(Class<?> clazz) {
        Table table = clazz.getAnnotation(Table.class);
        String string = table.value();
        return string;
    }

    protected List<ColumnInfo> getColumnInfo(Class<?> clazz) {
        ArrayList<ColumnInfo> arrayList = new ArrayList<ColumnInfo>();
        for (Field field : clazz.getDeclaredFields()) {
            if (field.getAnnotation(Column.class) == null) continue;
            arrayList.add(new ColumnInfo(field));
        }
        return arrayList;
    }

    protected String getDbType(Class<?> clazz, int n) {
        if (clazz == String.class) {
            return this.getStringType(n);
        }
        if (clazz == Date.class) {
            return this.getDateType(n);
        }
        if (clazz == Integer.class) {
            return this.getIntType(n);
        }
        if (clazz == byte[].class) {
            return this.getBinaryType(n);
        }
        if (clazz == Boolean.class) {
            return this.getBooleanType(n);
        }
        if (clazz == Double.class) {
            return this.getDoubleType(n);
        }
        if (clazz == BigDecimal.class) {
            return this.getDecimalType(n);
        }
        throw new UnsupportedOperationException("Unsupported type" + clazz);
    }

    protected abstract String getStringType(int var1);

    protected abstract String getDateType(int var1);

    protected abstract String getIntType(int var1);

    protected abstract String getBinaryType(int var1);

    protected abstract String getBooleanType(int var1);

    protected abstract String getDoubleType(int var1);

    protected abstract String getDecimalType(int var1);

    protected void executeDiretory(String string) throws SQLException {
        LOG.info("sql= " + string);
        this.connection.createStatement().executeUpdate(string);
    }
}

