/*
 * Decompiled with CFR 0.152.
 */
package estoc.dbm;

import estoc.dbm.ColumnInfo;
import estoc.dbm.TableAccess;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

class TableAccessDerby
extends TableAccess {
    public TableAccessDerby(Connection connection) {
        super(connection);
    }

    @Override
    public void drop(Class<?> clazz) throws SQLException {
        String string = this.getTableName(clazz);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DROP TABLE ").append(string).toString();
        this.executeDiretory(stringBuilder.toString());
    }

    @Override
    public void create(Class<?> clazz) throws SQLException {
        String string = this.getTableName(clazz);
        List<ColumnInfo> list = this.getColumnInfo(clazz);
        String string2 = this.createTableSql(string, list);
        this.executeDiretory(string2);
        for (ColumnInfo columnInfo : list) {
            if (!columnInfo.isIndex()) continue;
            string2 = this.createIndexSql(string, columnInfo);
            this.executeDiretory(string2);
        }
    }

    private String createTableSql(String string, List<ColumnInfo> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" CREATE TABLE ").append(string).append(" ( ");
        boolean bl = false;
        for (ColumnInfo columnInfo : list) {
            if (bl) {
                stringBuilder.append(",");
            } else {
                bl = true;
            }
            if (!columnInfo.isPk()) continue;
            stringBuilder.append(" PRIMARY KEY ");
        }
        for (ColumnInfo columnInfo : list) {
            if (bl) {
                stringBuilder.append(",");
            } else {
                bl = true;
            }
            stringBuilder.append(columnInfo.getName()).append(" ");
            stringBuilder.append(this.getDbType(columnInfo.getType(), columnInfo.getTypeOpt()));
            if (columnInfo.isNotNull() || columnInfo.isPk()) {
                stringBuilder.append(" NOT NULL ");
            }
            if (columnInfo.isAutoInc()) {
                stringBuilder.append(" AUTO_INCREMENT ");
            }
            if (!columnInfo.isPk()) continue;
            stringBuilder.append(" PRIMARY KEY ");
        }
        stringBuilder.append(" ) ");
        return stringBuilder.toString();
    }

    private String createIndexSql(String string, ColumnInfo columnInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" CREATE INDEX IF NOT EXISTS ").append("idx_").append(columnInfo.getName());
        stringBuilder.append(" ON ").append(string).append(" (").append(columnInfo.getName()).append(")");
        return stringBuilder.toString();
    }

    @Override
    protected String getBinaryType(int n) {
        if (n == -1) {
            return "VARCHAR FOR BIT DATA";
        }
        return "VARCHAR (" + n + ") " + "FOR BIT DATA";
    }

    @Override
    protected String getDateType(int n) {
        return "TIMESTAMP";
    }

    @Override
    protected String getIntType(int n) {
        return "INT";
    }

    @Override
    protected String getStringType(int n) {
        if (n == -1) {
            return "VARCHAR";
        }
        return "VARCHAR(" + n + ")";
    }

    @Override
    protected String getBooleanType(int n) {
        return "BOOLEAN";
    }

    @Override
    protected String getDoubleType(int n) {
        return "DOUBLE";
    }

    @Override
    protected String getDecimalType(int n) {
        if (n == -1) {
            return "DECIMAL";
        }
        return "DECIMAL(" + n + ")";
    }
}

