/*
 * Decompiled with CFR 0.152.
 */
package jp.uclab.sticky;

import com.evernote.edam.notestore.NoteFilter;
import com.evernote.edam.notestore.NoteList;
import com.evernote.edam.notestore.NoteStore;
import com.evernote.edam.type.Note;
import com.evernote.edam.type.NoteSortOrder;
import com.evernote.edam.type.Notebook;
import com.evernote.edam.type.User;
import com.evernote.edam.userstore.AuthenticationResult;
import com.evernote.edam.userstore.UserStore;
import java.awt.AWTException;
import java.awt.DisplayMode;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jp.uclab.sticky.EVNote;
import jp.uclab.sticky.EncodedProperties;
import jp.uclab.sticky.SocketThread;
import jp.uclab.sticky.Sticky;
import jp.uclab.sticky.StickyProperty;
import jp.uclab.sticky.UserForm;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.THttpClient;
import org.apache.thrift.transport.TTransport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class StickyManager
extends Thread {
    public static String iniFile = "Sticky.ini";
    String TAG = "!";
    int WIDTH_MAX = 400;
    int HEIGHT_MAX = 500;
    int LIST_MAX = 5;
    int SLEEP_TIME = 60000;
    String userStoreUrl = "https://www.evernote.com/edam/user";
    String noteStoreUrlBase = "http://www.evernote.com/edam/note/";
    String consumerKey = "kaji66";
    String consumerSecret = "95365e5b9d294fb1";
    String cacheDirName = "cache";
    String username;
    String password;
    boolean toFront = false;
    UserForm uf;
    List<Notebook> notebooks;
    String authToken;
    NoteStore.Client noteStore;
    int displayWidth;
    int displayHeight;
    ArrayList<Sticky> stickyList = new ArrayList();
    ArrayList<EVNote> evnoteList = new ArrayList();
    public static Pattern pattern = Pattern.compile("<.+?>", 32);
    SocketThread socketThread;

    public StickyManager() {
    }

    public StickyManager(String username, String password) {
        this.init(username, password);
    }

    public void init(String username, String password) {
        this.initAWT();
        this.username = username;
        this.password = password;
        try {
            this.initProperties();
        }
        catch (Exception e) {
            System.err.println("ini\u30d5\u30a1\u30a4\u30eb\u8aad\u307f\u8fbc\u307f\u5931\u6557\uff0e");
        }
        this.loadCache();
        try {
            System.out.println("Evernote\u30b5\u30fc\u30d0\u306b\u63a5\u7d9a\uff0e");
            this.initEvernote();
            System.out.println("\u63a5\u7d9a\u6210\u529f\uff0e");
        }
        catch (Exception e) {
            System.err.println("\u63a5\u7d9a\u5931\u6557\uff0e");
        }
        this.start();
    }

    public void initProperties() {
        try {
            EncodedProperties prop = new EncodedProperties();
            prop.load(iniFile);
            this.TAG = prop.getProperty("TAG", "!");
            this.WIDTH_MAX = Integer.parseInt(prop.getProperty("WIDTH_MAX"));
            this.HEIGHT_MAX = Integer.parseInt(prop.getProperty("HEIGHT_MAX"));
            this.LIST_MAX = Integer.parseInt(prop.getProperty("LIST_MAX"));
            this.SLEEP_TIME = Integer.parseInt(prop.getProperty("SLEEP_TIME")) * 1000 * 60;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initAWT() {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        DisplayMode displayMode = env.getDefaultScreenDevice().getDisplayMode();
        this.displayWidth = displayMode.getWidth();
        this.displayHeight = displayMode.getHeight();
        final SystemTray tray = SystemTray.getSystemTray();
        Image image = Toolkit.getDefaultToolkit().getImage("icon_small.png");
        PopupMenu popup = new PopupMenu();
        final TrayIcon icon = new TrayIcon(image, "Evernote Sticky", popup);
        MenuItem openMenu = new MenuItem("Show All");
        openMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StickyManager.this.openAllSticky();
            }
        });
        MenuItem hideMenu = new MenuItem("Hide All");
        hideMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StickyManager.this.hideSticky();
            }
        });
        MenuItem frontMenu = new MenuItem("Switch");
        frontMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StickyManager.this.switchShowing();
            }
        });
        MenuItem updateMenu = new MenuItem("Sync");
        updateMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    System.out.println("\u540c\u671f\u958b\u59cb");
                    StickyManager.this.searchEvernote();
                    StickyManager.this.updateSticky();
                    System.out.println("\u540c\u671f\u5b8c\u4e86");
                }
                catch (Exception ex) {
                    System.err.println("\u691c\u7d22\u5931\u6557\uff0e");
                }
            }
        });
        MenuItem exitMenu = new MenuItem("Exit");
        exitMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                tray.remove(icon);
                System.exit(0);
            }
        });
        popup.add(openMenu);
        popup.add(hideMenu);
        popup.add(frontMenu);
        popup.add(updateMenu);
        popup.add(exitMenu);
        try {
            tray.add(icon);
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
    }

    public void initEvernote() throws Exception {
        THttpClient userStoreTrans = new THttpClient(this.userStoreUrl);
        TBinaryProtocol userStoreProt = new TBinaryProtocol((TTransport)userStoreTrans);
        UserStore.Client userStore = new UserStore.Client((TProtocol)userStoreProt, (TProtocol)userStoreProt);
        boolean versionOk = userStore.checkVersion("Evernote's EDAMDemo (Java)", (short)1, (short)15);
        if (!versionOk) {
            System.err.println("Incomatible EDAM client protocol version");
            return;
        }
        AuthenticationResult authResult = userStore.authenticate(this.username, this.password, this.consumerKey, this.consumerSecret);
        User user = authResult.getUser();
        this.authToken = authResult.getAuthenticationToken();
        String noteStoreUrl = String.valueOf(this.noteStoreUrlBase) + user.getShardId();
        THttpClient noteStoreTrans = new THttpClient(noteStoreUrl);
        TBinaryProtocol noteStoreProt = new TBinaryProtocol((TTransport)noteStoreTrans);
        this.noteStore = new NoteStore.Client((TProtocol)noteStoreProt, (TProtocol)noteStoreProt);
        this.notebooks = this.noteStore.listNotebooks(this.authToken);
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    System.out.println("\u540c\u671f\u958b\u59cb");
                    this.searchEvernote();
                    this.updateSticky();
                    System.out.println("\u540c\u671f\u5b8c\u4e86");
                    StickyManager.sleep(this.SLEEP_TIME);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("\u691c\u7d22\u5931\u6557\uff0e");
                try {
                    StickyManager.sleep(this.SLEEP_TIME);
                    System.out.println("Evernote\u30b5\u30fc\u30d0\u306b\u518d\u63a5\u7d9a\uff0e");
                    this.initEvernote();
                    System.out.println("\u63a5\u7d9a\u6210\u529f\uff0e");
                    continue;
                }
                catch (Exception ex) {
                    System.err.println("\u63a5\u7d9a\u5931\u6557\uff0e");
                    continue;
                }
            }
            break;
        }
    }

    public void updateSticky() {
        int currentHeight = 10;
        int totalNum = 0;
        ArrayList<Sticky> newStickyList = new ArrayList<Sticky>();
        int i = 0;
        while (i < this.evnoteList.size()) {
            EVNote evn = this.evnoteList.get(i);
            Sticky sticky = this.getSticky(evn);
            if (sticky == null) {
                sticky = Sticky.createSticky(evn);
            } else {
                sticky.setEVNote(evn);
            }
            newStickyList.add(sticky);
            if (!sticky.moved) {
                int w = sticky.dialog.getBounds().width;
                int h = sticky.dialog.getBounds().height;
                if (sticky.dialog.getBounds().width > this.WIDTH_MAX) {
                    w = this.WIDTH_MAX;
                }
                if (sticky.dialog.getBounds().width > this.HEIGHT_MAX) {
                    h = this.HEIGHT_MAX;
                }
                sticky.dialog.setBounds(new Rectangle(this.displayWidth - sticky.dialog.getBounds().width - 10, currentHeight, w, h));
                currentHeight = sticky.dialog.getLocation().y + sticky.dialog.getBounds().height + 10;
                if (!this.stickyList.contains(sticky)) {
                    sticky.dialog.setVisible(true);
                }
            }
            ++totalNum;
            if (currentHeight > this.displayHeight) break;
            ++i;
        }
        for (Sticky sticky : this.stickyList) {
            if (newStickyList.contains(sticky)) continue;
            sticky.dialog.dispose();
        }
        this.stickyList = newStickyList;
        this.saveCache();
    }

    public Sticky getSticky(EVNote evn) {
        String guid = evn.note.getGuid();
        for (Sticky sticky : this.stickyList) {
            if (!sticky.evn.note.getGuid().equals(guid)) continue;
            return sticky;
        }
        return null;
    }

    public void searchEvernote() throws Exception {
        this.evnoteList.clear();
        for (Notebook notebook : this.notebooks) {
            NoteFilter filter = new NoteFilter();
            filter.setOrder(NoteSortOrder.CREATED.getValue());
            filter.setAscending(false);
            filter.setNotebookGuid(notebook.getGuid());
            filter.setWords("tag:" + this.TAG);
            NoteList noteList = this.noteStore.findNotes(this.authToken, filter, 0, this.LIST_MAX);
            List<Note> notes = noteList.getNotes();
            for (Note note : notes) {
                String content = this.noteStore.getNoteContent(this.authToken, note.getGuid());
                List<String> tags = this.noteStore.getNoteTagNames(this.authToken, note.getGuid());
                if (tags != null) {
                    tags.remove(this.TAG);
                }
                String fullContent = content = this.evn2html(content);
                EVNote evn = new EVNote(note.getTitle(), tags, content, note, fullContent);
                this.evnoteList.add(evn);
            }
        }
    }

    public void openSticky() {
        for (Sticky sticky : this.stickyList) {
            if (sticky.hide) continue;
            sticky.dialog.setVisible(true);
        }
        this.toFront();
    }

    public void openAllSticky() {
        for (Sticky sticky : this.stickyList) {
            sticky.hide = false;
            sticky.dialog.setVisible(true);
        }
        this.toFront();
    }

    public void hideSticky() {
        for (Sticky sticky : this.stickyList) {
            sticky.dialog.setVisible(false);
        }
    }

    public void toFront() {
        for (Sticky sticky : this.stickyList) {
            sticky.dialog.setAlwaysOnTop(true);
            sticky.dialog.setAlwaysOnTop(false);
        }
    }

    public void toBackground() {
        for (Sticky sticky : this.stickyList) {
            sticky.dialog.toBack();
        }
    }

    public void switchShowing() {
        if (!this.toFront) {
            this.toBackground();
            this.toFront = true;
        } else {
            this.toFront();
            this.toFront = false;
        }
    }

    public String evn2html(String content) {
        Document evnDoc = StickyManager.string2Document(content);
        Document htmlDoc = StickyManager.evnDoc2Html(evnDoc);
        String str = StickyManager.document2String(htmlDoc);
        return str;
    }

    public static Document evnDoc2Html(Document document) {
        Document doc = null;
        try {
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
            doc = builder.newDocument();
            Element html = doc.createElement("html");
            Element body = doc.createElement("body");
            doc.appendChild(html);
            html.appendChild(body);
            NodeList list = document.getDocumentElement().getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Node gchild = list.item(i);
                Node importNode = doc.importNode(gchild, true);
                body.appendChild(importNode);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return doc;
    }

    public static String document2String(Document document) {
        return StickyManager.element2String(document.getDocumentElement());
    }

    public static String element2String(Element elem) {
        String result = null;
        StringWriter strWtr = new StringWriter();
        StreamResult strResult = new StreamResult(strWtr);
        TransformerFactory tfac = TransformerFactory.newInstance();
        try {
            Transformer trans = tfac.newTransformer();
            trans.transform(new DOMSource(elem), strResult);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        result = strResult.getWriter().toString();
        return result;
    }

    public static Document string2Document(String str) {
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            StringReader strReader = new StringReader(str);
            doc = builder.parse(new InputSource(strReader));
            builder = factory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return doc;
    }

    public void saveCache() {
        ArrayList<StickyProperty> stickyPropertyList = new ArrayList<StickyProperty>();
        for (Sticky sticky : this.stickyList) {
            StickyProperty sp = new StickyProperty(sticky);
            stickyPropertyList.add(sp);
        }
        File cacheDir = new File(this.cacheDirName);
        if (!cacheDir.exists()) {
            cacheDir.mkdir();
        }
        String cacheFileName = String.valueOf(this.username) + ".bin";
        try {
            File cacheFile = new File(cacheDir, cacheFileName);
            FileOutputStream out = new FileOutputStream(cacheFile);
            ObjectOutputStream oout = new ObjectOutputStream(out);
            oout.writeObject(stickyPropertyList);
            oout.close();
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadCache() {
        File cacheDir = new File(this.cacheDirName);
        if (!cacheDir.exists()) {
            return;
        }
        String cacheFileName = String.valueOf(this.username) + ".bin";
        try {
            File cacheFile = new File(cacheDir, cacheFileName);
            if (cacheFile.exists()) {
                FileInputStream in = new FileInputStream(cacheFile);
                ObjectInputStream oin = new ObjectInputStream(in);
                ArrayList stickyPropertyList = (ArrayList)oin.readObject();
                oin.close();
                in.close();
                for (StickyProperty stickyProperty : stickyPropertyList) {
                    Sticky newSticky = Sticky.createSticky(stickyProperty.evn);
                    this.stickyList.add(newSticky);
                    newSticky.dialog.setBounds(stickyProperty.bounds);
                    newSticky.dialog.setVisible(!stickyProperty.hide);
                    newSticky.moved = stickyProperty.moved;
                    newSticky.hide = stickyProperty.hide;
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        StickyManager sm;
        try {
            FileChannel fc = new FileOutputStream(new File("lock")).getChannel();
            FileLock lock = fc.tryLock();
            if (lock == null) {
                return;
            }
        }
        catch (Exception fc) {
            // empty catch block
        }
        String username = "";
        String password = "";
        try {
            FileInputStream in = new FileInputStream(new File(iniFile));
            Properties prop = new Properties();
            prop.load(in);
            username = prop.getProperty("EVERNOTE_USERNAME", "");
            password = prop.getProperty("EVERNOTE_PASSWORD", "");
            ((InputStream)in).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (username.equals("") || password.equals("")) {
            sm = new StickyManager();
            UserForm.createUserForm(username, password, sm);
            new SocketThread(sm);
        } else {
            sm = new StickyManager(username, password);
            new SocketThread(sm);
        }
    }
}

