/**
 * Autogenerated by Thrift
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 */
package com.evernote.edam.notestore;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.EnumMap;
import java.util.Set;
import java.util.HashSet;
import java.util.EnumSet;
import java.util.Collections;
import com.evernote.edam.util.BitSet;
import java.util.Arrays;

import org.apache.thrift.*;
import org.apache.thrift.meta_data.*;
import org.apache.thrift.protocol.*;

/**
 *  This structure is given out by the NoteStore when a client asks to
 *  receive the current state of an account.  The client asks for the server's
 *  state one chunk at a time in order to allow clients to retrieve the state
 *  of a large account without needing to transfer the entire account in
 *  a single message.
 * 
 *  The server always gives SyncChunks using an ascending series of Update
 *  Sequence Numbers (USNs).
 * 
 * <dl>
 *  <dt>currentTime</dt>
 *    <dd>
 *    The server's current date and time.
 *    </dd>
 * 
 *  <dt>chunkHighUSN</dt>
 *    <dd>
 *    The highest USN for any of the data objects represented
 *    in this sync chunk.  If there are no objects in the chunk, this will not be
 *    set.
 *    </dd>
 * 
 *  <dt>updateCount</dt>
 *    <dd>
 *    The total number of updates that have been performed in
 *    the service for this account.  This is equal to the highest USN within the
 *    account at the point that this SyncChunk was generated.  If updateCount
 *    and chunkHighUSN are identical, that means that this is the last chunk
 *    in the account ... there is no more recent information.
 *    </dd>
 * 
 *  <dt>notes</dt>
 *    <dd>
 *    If present, this is a list of non-expunged notes that
 *    have a USN in this chunk.  This will include notes that are "deleted"
 *    but not expunged (i.e. in the trash).  The notes will include their list
 *    of tags and resources, but the resource content and recognition data
 *    will not be supplied.
 *    </dd>
 * 
 *  <dt>notebooks</dt>
 *    <dd>
 *    If present, this is a list of non-expunged notebooks that
 *    have a USN in this chunk.  This will include notebooks that are "deleted"
 *    but not expunged (i.e. in the trash).
 *    </dd>
 * 
 *  <dt>tags</dt>
 *    <dd>
 *    If present, this is a list of the non-expunged tags that have a
 *    USN in this chunk.
 *    </dd>
 * 
 *  <dt>searches</dt>
 *    <dd>
 *    If present, this is a list of non-expunged searches that
 *    have a USN in this chunk.
 *    </dd>
 * 
 *  <dt>resources</dt>
 *    <dd>
 *    If present, this is a list of the non-expunged resources
 *    that have a USN in this chunk.  This will include the metadata for each
 *    resource, but not its binary contents or recognition data, which must be
 *    retrieved separately.
 *    </dd>
 * 
 *  <dt>expungedNotes</dt>
 *    <dd>
 *    If present, the GUIDs of all of the notes that were
 *    permanently expunged in this chunk.
 *    </dd>
 * 
 *  <dt>expungedNotebooks</dt>
 *    <dd>
 *    If present, the GUIDs of all of the notebooks that
 *    were permanently expunged in this chunk.  When a notebook is expunged,
 *    this implies that all of its child notes (and their resources) were
 *    also expunged.
 *    </dd>
 * 
 *  <dt>expungedTags</dt>
 *    <dd>
 *    If present, the GUIDs of all of the tags that were
 *    permanently expunged in this chunk.
 *    </dd>
 * 
 *  <dt>expungedSearches</dt>
 *    <dd>
 *    If present, the GUIDs of all of the saved searches
 *    that were permanently expunged in this chunk.
 *    </dd>
 *  </dl>
 */
public class SyncChunk implements TBase<SyncChunk._Fields>, java.io.Serializable, Cloneable, Comparable<SyncChunk> {
  private static final TStruct STRUCT_DESC = new TStruct("SyncChunk");

  private static final TField CURRENT_TIME_FIELD_DESC = new TField("currentTime", TType.I64, (short)1);
  private static final TField CHUNK_HIGH_USN_FIELD_DESC = new TField("chunkHighUSN", TType.I32, (short)2);
  private static final TField UPDATE_COUNT_FIELD_DESC = new TField("updateCount", TType.I32, (short)3);
  private static final TField NOTES_FIELD_DESC = new TField("notes", TType.LIST, (short)4);
  private static final TField NOTEBOOKS_FIELD_DESC = new TField("notebooks", TType.LIST, (short)5);
  private static final TField TAGS_FIELD_DESC = new TField("tags", TType.LIST, (short)6);
  private static final TField SEARCHES_FIELD_DESC = new TField("searches", TType.LIST, (short)7);
  private static final TField RESOURCES_FIELD_DESC = new TField("resources", TType.LIST, (short)8);
  private static final TField EXPUNGED_NOTES_FIELD_DESC = new TField("expungedNotes", TType.LIST, (short)9);
  private static final TField EXPUNGED_NOTEBOOKS_FIELD_DESC = new TField("expungedNotebooks", TType.LIST, (short)10);
  private static final TField EXPUNGED_TAGS_FIELD_DESC = new TField("expungedTags", TType.LIST, (short)11);
  private static final TField EXPUNGED_SEARCHES_FIELD_DESC = new TField("expungedSearches", TType.LIST, (short)12);

  private long currentTime;
  private int chunkHighUSN;
  private int updateCount;
  private List<com.evernote.edam.type.Note> notes;
  private List<com.evernote.edam.type.Notebook> notebooks;
  private List<com.evernote.edam.type.Tag> tags;
  private List<com.evernote.edam.type.SavedSearch> searches;
  private List<com.evernote.edam.type.Resource> resources;
  private List<String> expungedNotes;
  private List<String> expungedNotebooks;
  private List<String> expungedTags;
  private List<String> expungedSearches;

  /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
  public enum _Fields implements TFieldIdEnum {
    CURRENT_TIME((short)1, "currentTime"),
    CHUNK_HIGH_USN((short)2, "chunkHighUSN"),
    UPDATE_COUNT((short)3, "updateCount"),
    NOTES((short)4, "notes"),
    NOTEBOOKS((short)5, "notebooks"),
    TAGS((short)6, "tags"),
    SEARCHES((short)7, "searches"),
    RESOURCES((short)8, "resources"),
    EXPUNGED_NOTES((short)9, "expungedNotes"),
    EXPUNGED_NOTEBOOKS((short)10, "expungedNotebooks"),
    EXPUNGED_TAGS((short)11, "expungedTags"),
    EXPUNGED_SEARCHES((short)12, "expungedSearches");

    private static final Map<Integer, _Fields> byId = new HashMap<Integer, _Fields>();
    private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

    static {
      for (_Fields field : EnumSet.allOf(_Fields.class)) {
        byId.put((int)field._thriftId, field);
        byName.put(field.getFieldName(), field);
      }
    }

    /**
     * Find the _Fields constant that matches fieldId, or null if its not found.
     */
    public static _Fields findByThriftId(int fieldId) {
      return byId.get(fieldId);
    }

    /**
     * Find the _Fields constant that matches fieldId, throwing an exception
     * if it is not found.
     */
    public static _Fields findByThriftIdOrThrow(int fieldId) {
      _Fields fields = findByThriftId(fieldId);
      if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
      return fields;
    }

    /**
     * Find the _Fields constant that matches name, or null if its not found.
     */
    public static _Fields findByName(String name) {
      return byName.get(name);
    }

    private final short _thriftId;
    private final String _fieldName;

    _Fields(short thriftId, String fieldName) {
      _thriftId = thriftId;
      _fieldName = fieldName;
    }

    public short getThriftFieldId() {
      return _thriftId;
    }

    public String getFieldName() {
      return _fieldName;
    }
  }

  // isset id assignments
  private static final int __CURRENTTIME_ISSET_ID = 0;
  private static final int __CHUNKHIGHUSN_ISSET_ID = 1;
  private static final int __UPDATECOUNT_ISSET_ID = 2;
  private BitSet __isset_bit_vector = new BitSet(3);

  public static final Map<_Fields, FieldMetaData> metaDataMap = Collections.unmodifiableMap(new EnumMap<_Fields, FieldMetaData>(_Fields.class) {{
    put(_Fields.CURRENT_TIME, new FieldMetaData("currentTime", TFieldRequirementType.REQUIRED, 
        new FieldValueMetaData(TType.I64)));
    put(_Fields.CHUNK_HIGH_USN, new FieldMetaData("chunkHighUSN", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.I32)));
    put(_Fields.UPDATE_COUNT, new FieldMetaData("updateCount", TFieldRequirementType.REQUIRED, 
        new FieldValueMetaData(TType.I32)));
    put(_Fields.NOTES, new FieldMetaData("notes", TFieldRequirementType.OPTIONAL, 
        new ListMetaData(TType.LIST, 
            new StructMetaData(TType.STRUCT, com.evernote.edam.type.Note.class))));
    put(_Fields.NOTEBOOKS, new FieldMetaData("notebooks", TFieldRequirementType.OPTIONAL, 
        new ListMetaData(TType.LIST, 
            new StructMetaData(TType.STRUCT, com.evernote.edam.type.Notebook.class))));
    put(_Fields.TAGS, new FieldMetaData("tags", TFieldRequirementType.OPTIONAL, 
        new ListMetaData(TType.LIST, 
            new StructMetaData(TType.STRUCT, com.evernote.edam.type.Tag.class))));
    put(_Fields.SEARCHES, new FieldMetaData("searches", TFieldRequirementType.OPTIONAL, 
        new ListMetaData(TType.LIST, 
            new StructMetaData(TType.STRUCT, com.evernote.edam.type.SavedSearch.class))));
    put(_Fields.RESOURCES, new FieldMetaData("resources", TFieldRequirementType.OPTIONAL, 
        new ListMetaData(TType.LIST, 
            new StructMetaData(TType.STRUCT, com.evernote.edam.type.Resource.class))));
    put(_Fields.EXPUNGED_NOTES, new FieldMetaData("expungedNotes", TFieldRequirementType.OPTIONAL, 
        new ListMetaData(TType.LIST, 
            new FieldValueMetaData(TType.STRING))));
    put(_Fields.EXPUNGED_NOTEBOOKS, new FieldMetaData("expungedNotebooks", TFieldRequirementType.OPTIONAL, 
        new ListMetaData(TType.LIST, 
            new FieldValueMetaData(TType.STRING))));
    put(_Fields.EXPUNGED_TAGS, new FieldMetaData("expungedTags", TFieldRequirementType.OPTIONAL, 
        new ListMetaData(TType.LIST, 
            new FieldValueMetaData(TType.STRING))));
    put(_Fields.EXPUNGED_SEARCHES, new FieldMetaData("expungedSearches", TFieldRequirementType.OPTIONAL, 
        new ListMetaData(TType.LIST, 
            new FieldValueMetaData(TType.STRING))));
  }});

  static {
    FieldMetaData.addStructMetaDataMap(SyncChunk.class, metaDataMap);
  }

  public SyncChunk() {
  }

  public SyncChunk(
    long currentTime,
    int updateCount)
  {
    this();
    this.currentTime = currentTime;
    setCurrentTimeIsSet(true);
    this.updateCount = updateCount;
    setUpdateCountIsSet(true);
  }

  /**
   * Performs a deep copy on <i>other</i>.
   */
  public SyncChunk(SyncChunk other) {
    __isset_bit_vector.clear();
    __isset_bit_vector.or(other.__isset_bit_vector);
    this.currentTime = other.currentTime;
    this.chunkHighUSN = other.chunkHighUSN;
    this.updateCount = other.updateCount;
    if (other.isSetNotes()) {
      List<com.evernote.edam.type.Note> __this__notes = new ArrayList<com.evernote.edam.type.Note>();
      for (com.evernote.edam.type.Note other_element : other.notes) {
        __this__notes.add(new com.evernote.edam.type.Note(other_element));
      }
      this.notes = __this__notes;
    }
    if (other.isSetNotebooks()) {
      List<com.evernote.edam.type.Notebook> __this__notebooks = new ArrayList<com.evernote.edam.type.Notebook>();
      for (com.evernote.edam.type.Notebook other_element : other.notebooks) {
        __this__notebooks.add(new com.evernote.edam.type.Notebook(other_element));
      }
      this.notebooks = __this__notebooks;
    }
    if (other.isSetTags()) {
      List<com.evernote.edam.type.Tag> __this__tags = new ArrayList<com.evernote.edam.type.Tag>();
      for (com.evernote.edam.type.Tag other_element : other.tags) {
        __this__tags.add(new com.evernote.edam.type.Tag(other_element));
      }
      this.tags = __this__tags;
    }
    if (other.isSetSearches()) {
      List<com.evernote.edam.type.SavedSearch> __this__searches = new ArrayList<com.evernote.edam.type.SavedSearch>();
      for (com.evernote.edam.type.SavedSearch other_element : other.searches) {
        __this__searches.add(new com.evernote.edam.type.SavedSearch(other_element));
      }
      this.searches = __this__searches;
    }
    if (other.isSetResources()) {
      List<com.evernote.edam.type.Resource> __this__resources = new ArrayList<com.evernote.edam.type.Resource>();
      for (com.evernote.edam.type.Resource other_element : other.resources) {
        __this__resources.add(new com.evernote.edam.type.Resource(other_element));
      }
      this.resources = __this__resources;
    }
    if (other.isSetExpungedNotes()) {
      List<String> __this__expungedNotes = new ArrayList<String>();
      for (String other_element : other.expungedNotes) {
        __this__expungedNotes.add(other_element);
      }
      this.expungedNotes = __this__expungedNotes;
    }
    if (other.isSetExpungedNotebooks()) {
      List<String> __this__expungedNotebooks = new ArrayList<String>();
      for (String other_element : other.expungedNotebooks) {
        __this__expungedNotebooks.add(other_element);
      }
      this.expungedNotebooks = __this__expungedNotebooks;
    }
    if (other.isSetExpungedTags()) {
      List<String> __this__expungedTags = new ArrayList<String>();
      for (String other_element : other.expungedTags) {
        __this__expungedTags.add(other_element);
      }
      this.expungedTags = __this__expungedTags;
    }
    if (other.isSetExpungedSearches()) {
      List<String> __this__expungedSearches = new ArrayList<String>();
      for (String other_element : other.expungedSearches) {
        __this__expungedSearches.add(other_element);
      }
      this.expungedSearches = __this__expungedSearches;
    }
  }

  public SyncChunk deepCopy() {
    return new SyncChunk(this);
  }

  @Deprecated
  public SyncChunk clone() {
    return new SyncChunk(this);
  }

  public long getCurrentTime() {
    return this.currentTime;
  }

  public void setCurrentTime(long currentTime) {
    this.currentTime = currentTime;
    setCurrentTimeIsSet(true);
  }

  public void unsetCurrentTime() {
    __isset_bit_vector.clear(__CURRENTTIME_ISSET_ID);
  }

  /** Returns true if field currentTime is set (has been asigned a value) and false otherwise */
  public boolean isSetCurrentTime() {
    return __isset_bit_vector.get(__CURRENTTIME_ISSET_ID);
  }

  public void setCurrentTimeIsSet(boolean value) {
    __isset_bit_vector.set(__CURRENTTIME_ISSET_ID, value);
  }

  public int getChunkHighUSN() {
    return this.chunkHighUSN;
  }

  public void setChunkHighUSN(int chunkHighUSN) {
    this.chunkHighUSN = chunkHighUSN;
    setChunkHighUSNIsSet(true);
  }

  public void unsetChunkHighUSN() {
    __isset_bit_vector.clear(__CHUNKHIGHUSN_ISSET_ID);
  }

  /** Returns true if field chunkHighUSN is set (has been asigned a value) and false otherwise */
  public boolean isSetChunkHighUSN() {
    return __isset_bit_vector.get(__CHUNKHIGHUSN_ISSET_ID);
  }

  public void setChunkHighUSNIsSet(boolean value) {
    __isset_bit_vector.set(__CHUNKHIGHUSN_ISSET_ID, value);
  }

  public int getUpdateCount() {
    return this.updateCount;
  }

  public void setUpdateCount(int updateCount) {
    this.updateCount = updateCount;
    setUpdateCountIsSet(true);
  }

  public void unsetUpdateCount() {
    __isset_bit_vector.clear(__UPDATECOUNT_ISSET_ID);
  }

  /** Returns true if field updateCount is set (has been asigned a value) and false otherwise */
  public boolean isSetUpdateCount() {
    return __isset_bit_vector.get(__UPDATECOUNT_ISSET_ID);
  }

  public void setUpdateCountIsSet(boolean value) {
    __isset_bit_vector.set(__UPDATECOUNT_ISSET_ID, value);
  }

  public int getNotesSize() {
    return (this.notes == null) ? 0 : this.notes.size();
  }

  public java.util.Iterator<com.evernote.edam.type.Note> getNotesIterator() {
    return (this.notes == null) ? null : this.notes.iterator();
  }

  public void addToNotes(com.evernote.edam.type.Note elem) {
    if (this.notes == null) {
      this.notes = new ArrayList<com.evernote.edam.type.Note>();
    }
    this.notes.add(elem);
  }

  public List<com.evernote.edam.type.Note> getNotes() {
    return this.notes;
  }

  public void setNotes(List<com.evernote.edam.type.Note> notes) {
    this.notes = notes;
  }

  public void unsetNotes() {
    this.notes = null;
  }

  /** Returns true if field notes is set (has been asigned a value) and false otherwise */
  public boolean isSetNotes() {
    return this.notes != null;
  }

  public void setNotesIsSet(boolean value) {
    if (!value) {
      this.notes = null;
    }
  }

  public int getNotebooksSize() {
    return (this.notebooks == null) ? 0 : this.notebooks.size();
  }

  public java.util.Iterator<com.evernote.edam.type.Notebook> getNotebooksIterator() {
    return (this.notebooks == null) ? null : this.notebooks.iterator();
  }

  public void addToNotebooks(com.evernote.edam.type.Notebook elem) {
    if (this.notebooks == null) {
      this.notebooks = new ArrayList<com.evernote.edam.type.Notebook>();
    }
    this.notebooks.add(elem);
  }

  public List<com.evernote.edam.type.Notebook> getNotebooks() {
    return this.notebooks;
  }

  public void setNotebooks(List<com.evernote.edam.type.Notebook> notebooks) {
    this.notebooks = notebooks;
  }

  public void unsetNotebooks() {
    this.notebooks = null;
  }

  /** Returns true if field notebooks is set (has been asigned a value) and false otherwise */
  public boolean isSetNotebooks() {
    return this.notebooks != null;
  }

  public void setNotebooksIsSet(boolean value) {
    if (!value) {
      this.notebooks = null;
    }
  }

  public int getTagsSize() {
    return (this.tags == null) ? 0 : this.tags.size();
  }

  public java.util.Iterator<com.evernote.edam.type.Tag> getTagsIterator() {
    return (this.tags == null) ? null : this.tags.iterator();
  }

  public void addToTags(com.evernote.edam.type.Tag elem) {
    if (this.tags == null) {
      this.tags = new ArrayList<com.evernote.edam.type.Tag>();
    }
    this.tags.add(elem);
  }

  public List<com.evernote.edam.type.Tag> getTags() {
    return this.tags;
  }

  public void setTags(List<com.evernote.edam.type.Tag> tags) {
    this.tags = tags;
  }

  public void unsetTags() {
    this.tags = null;
  }

  /** Returns true if field tags is set (has been asigned a value) and false otherwise */
  public boolean isSetTags() {
    return this.tags != null;
  }

  public void setTagsIsSet(boolean value) {
    if (!value) {
      this.tags = null;
    }
  }

  public int getSearchesSize() {
    return (this.searches == null) ? 0 : this.searches.size();
  }

  public java.util.Iterator<com.evernote.edam.type.SavedSearch> getSearchesIterator() {
    return (this.searches == null) ? null : this.searches.iterator();
  }

  public void addToSearches(com.evernote.edam.type.SavedSearch elem) {
    if (this.searches == null) {
      this.searches = new ArrayList<com.evernote.edam.type.SavedSearch>();
    }
    this.searches.add(elem);
  }

  public List<com.evernote.edam.type.SavedSearch> getSearches() {
    return this.searches;
  }

  public void setSearches(List<com.evernote.edam.type.SavedSearch> searches) {
    this.searches = searches;
  }

  public void unsetSearches() {
    this.searches = null;
  }

  /** Returns true if field searches is set (has been asigned a value) and false otherwise */
  public boolean isSetSearches() {
    return this.searches != null;
  }

  public void setSearchesIsSet(boolean value) {
    if (!value) {
      this.searches = null;
    }
  }

  public int getResourcesSize() {
    return (this.resources == null) ? 0 : this.resources.size();
  }

  public java.util.Iterator<com.evernote.edam.type.Resource> getResourcesIterator() {
    return (this.resources == null) ? null : this.resources.iterator();
  }

  public void addToResources(com.evernote.edam.type.Resource elem) {
    if (this.resources == null) {
      this.resources = new ArrayList<com.evernote.edam.type.Resource>();
    }
    this.resources.add(elem);
  }

  public List<com.evernote.edam.type.Resource> getResources() {
    return this.resources;
  }

  public void setResources(List<com.evernote.edam.type.Resource> resources) {
    this.resources = resources;
  }

  public void unsetResources() {
    this.resources = null;
  }

  /** Returns true if field resources is set (has been asigned a value) and false otherwise */
  public boolean isSetResources() {
    return this.resources != null;
  }

  public void setResourcesIsSet(boolean value) {
    if (!value) {
      this.resources = null;
    }
  }

  public int getExpungedNotesSize() {
    return (this.expungedNotes == null) ? 0 : this.expungedNotes.size();
  }

  public java.util.Iterator<String> getExpungedNotesIterator() {
    return (this.expungedNotes == null) ? null : this.expungedNotes.iterator();
  }

  public void addToExpungedNotes(String elem) {
    if (this.expungedNotes == null) {
      this.expungedNotes = new ArrayList<String>();
    }
    this.expungedNotes.add(elem);
  }

  public List<String> getExpungedNotes() {
    return this.expungedNotes;
  }

  public void setExpungedNotes(List<String> expungedNotes) {
    this.expungedNotes = expungedNotes;
  }

  public void unsetExpungedNotes() {
    this.expungedNotes = null;
  }

  /** Returns true if field expungedNotes is set (has been asigned a value) and false otherwise */
  public boolean isSetExpungedNotes() {
    return this.expungedNotes != null;
  }

  public void setExpungedNotesIsSet(boolean value) {
    if (!value) {
      this.expungedNotes = null;
    }
  }

  public int getExpungedNotebooksSize() {
    return (this.expungedNotebooks == null) ? 0 : this.expungedNotebooks.size();
  }

  public java.util.Iterator<String> getExpungedNotebooksIterator() {
    return (this.expungedNotebooks == null) ? null : this.expungedNotebooks.iterator();
  }

  public void addToExpungedNotebooks(String elem) {
    if (this.expungedNotebooks == null) {
      this.expungedNotebooks = new ArrayList<String>();
    }
    this.expungedNotebooks.add(elem);
  }

  public List<String> getExpungedNotebooks() {
    return this.expungedNotebooks;
  }

  public void setExpungedNotebooks(List<String> expungedNotebooks) {
    this.expungedNotebooks = expungedNotebooks;
  }

  public void unsetExpungedNotebooks() {
    this.expungedNotebooks = null;
  }

  /** Returns true if field expungedNotebooks is set (has been asigned a value) and false otherwise */
  public boolean isSetExpungedNotebooks() {
    return this.expungedNotebooks != null;
  }

  public void setExpungedNotebooksIsSet(boolean value) {
    if (!value) {
      this.expungedNotebooks = null;
    }
  }

  public int getExpungedTagsSize() {
    return (this.expungedTags == null) ? 0 : this.expungedTags.size();
  }

  public java.util.Iterator<String> getExpungedTagsIterator() {
    return (this.expungedTags == null) ? null : this.expungedTags.iterator();
  }

  public void addToExpungedTags(String elem) {
    if (this.expungedTags == null) {
      this.expungedTags = new ArrayList<String>();
    }
    this.expungedTags.add(elem);
  }

  public List<String> getExpungedTags() {
    return this.expungedTags;
  }

  public void setExpungedTags(List<String> expungedTags) {
    this.expungedTags = expungedTags;
  }

  public void unsetExpungedTags() {
    this.expungedTags = null;
  }

  /** Returns true if field expungedTags is set (has been asigned a value) and false otherwise */
  public boolean isSetExpungedTags() {
    return this.expungedTags != null;
  }

  public void setExpungedTagsIsSet(boolean value) {
    if (!value) {
      this.expungedTags = null;
    }
  }

  public int getExpungedSearchesSize() {
    return (this.expungedSearches == null) ? 0 : this.expungedSearches.size();
  }

  public java.util.Iterator<String> getExpungedSearchesIterator() {
    return (this.expungedSearches == null) ? null : this.expungedSearches.iterator();
  }

  public void addToExpungedSearches(String elem) {
    if (this.expungedSearches == null) {
      this.expungedSearches = new ArrayList<String>();
    }
    this.expungedSearches.add(elem);
  }

  public List<String> getExpungedSearches() {
    return this.expungedSearches;
  }

  public void setExpungedSearches(List<String> expungedSearches) {
    this.expungedSearches = expungedSearches;
  }

  public void unsetExpungedSearches() {
    this.expungedSearches = null;
  }

  /** Returns true if field expungedSearches is set (has been asigned a value) and false otherwise */
  public boolean isSetExpungedSearches() {
    return this.expungedSearches != null;
  }

  public void setExpungedSearchesIsSet(boolean value) {
    if (!value) {
      this.expungedSearches = null;
    }
  }

  public void setFieldValue(_Fields field, Object value) {
    switch (field) {
    case CURRENT_TIME:
      if (value == null) {
        unsetCurrentTime();
      } else {
        setCurrentTime((Long)value);
      }
      break;

    case CHUNK_HIGH_USN:
      if (value == null) {
        unsetChunkHighUSN();
      } else {
        setChunkHighUSN((Integer)value);
      }
      break;

    case UPDATE_COUNT:
      if (value == null) {
        unsetUpdateCount();
      } else {
        setUpdateCount((Integer)value);
      }
      break;

    case NOTES:
      if (value == null) {
        unsetNotes();
      } else {
        setNotes((List<com.evernote.edam.type.Note>)value);
      }
      break;

    case NOTEBOOKS:
      if (value == null) {
        unsetNotebooks();
      } else {
        setNotebooks((List<com.evernote.edam.type.Notebook>)value);
      }
      break;

    case TAGS:
      if (value == null) {
        unsetTags();
      } else {
        setTags((List<com.evernote.edam.type.Tag>)value);
      }
      break;

    case SEARCHES:
      if (value == null) {
        unsetSearches();
      } else {
        setSearches((List<com.evernote.edam.type.SavedSearch>)value);
      }
      break;

    case RESOURCES:
      if (value == null) {
        unsetResources();
      } else {
        setResources((List<com.evernote.edam.type.Resource>)value);
      }
      break;

    case EXPUNGED_NOTES:
      if (value == null) {
        unsetExpungedNotes();
      } else {
        setExpungedNotes((List<String>)value);
      }
      break;

    case EXPUNGED_NOTEBOOKS:
      if (value == null) {
        unsetExpungedNotebooks();
      } else {
        setExpungedNotebooks((List<String>)value);
      }
      break;

    case EXPUNGED_TAGS:
      if (value == null) {
        unsetExpungedTags();
      } else {
        setExpungedTags((List<String>)value);
      }
      break;

    case EXPUNGED_SEARCHES:
      if (value == null) {
        unsetExpungedSearches();
      } else {
        setExpungedSearches((List<String>)value);
      }
      break;

    }
  }

  public void setFieldValue(int fieldID, Object value) {
    setFieldValue(_Fields.findByThriftIdOrThrow(fieldID), value);
  }

  public Object getFieldValue(_Fields field) {
    switch (field) {
    case CURRENT_TIME:
      return new Long(getCurrentTime());

    case CHUNK_HIGH_USN:
      return new Integer(getChunkHighUSN());

    case UPDATE_COUNT:
      return new Integer(getUpdateCount());

    case NOTES:
      return getNotes();

    case NOTEBOOKS:
      return getNotebooks();

    case TAGS:
      return getTags();

    case SEARCHES:
      return getSearches();

    case RESOURCES:
      return getResources();

    case EXPUNGED_NOTES:
      return getExpungedNotes();

    case EXPUNGED_NOTEBOOKS:
      return getExpungedNotebooks();

    case EXPUNGED_TAGS:
      return getExpungedTags();

    case EXPUNGED_SEARCHES:
      return getExpungedSearches();

    }
    throw new IllegalStateException();
  }

  public Object getFieldValue(int fieldId) {
    return getFieldValue(_Fields.findByThriftIdOrThrow(fieldId));
  }

  /** Returns true if field corresponding to fieldID is set (has been asigned a value) and false otherwise */
  public boolean isSet(_Fields field) {
    switch (field) {
    case CURRENT_TIME:
      return isSetCurrentTime();
    case CHUNK_HIGH_USN:
      return isSetChunkHighUSN();
    case UPDATE_COUNT:
      return isSetUpdateCount();
    case NOTES:
      return isSetNotes();
    case NOTEBOOKS:
      return isSetNotebooks();
    case TAGS:
      return isSetTags();
    case SEARCHES:
      return isSetSearches();
    case RESOURCES:
      return isSetResources();
    case EXPUNGED_NOTES:
      return isSetExpungedNotes();
    case EXPUNGED_NOTEBOOKS:
      return isSetExpungedNotebooks();
    case EXPUNGED_TAGS:
      return isSetExpungedTags();
    case EXPUNGED_SEARCHES:
      return isSetExpungedSearches();
    }
    throw new IllegalStateException();
  }

  public boolean isSet(int fieldID) {
    return isSet(_Fields.findByThriftIdOrThrow(fieldID));
  }

  public boolean equals(Object that) {
    if (that == null)
      return false;
    if (that instanceof SyncChunk)
      return this.equals((SyncChunk)that);
    return false;
  }

  public boolean equals(SyncChunk that) {
    if (that == null)
      return false;

    boolean this_present_currentTime = true;
    boolean that_present_currentTime = true;
    if (this_present_currentTime || that_present_currentTime) {
      if (!(this_present_currentTime && that_present_currentTime))
        return false;
      if (this.currentTime != that.currentTime)
        return false;
    }

    boolean this_present_chunkHighUSN = true && this.isSetChunkHighUSN();
    boolean that_present_chunkHighUSN = true && that.isSetChunkHighUSN();
    if (this_present_chunkHighUSN || that_present_chunkHighUSN) {
      if (!(this_present_chunkHighUSN && that_present_chunkHighUSN))
        return false;
      if (this.chunkHighUSN != that.chunkHighUSN)
        return false;
    }

    boolean this_present_updateCount = true;
    boolean that_present_updateCount = true;
    if (this_present_updateCount || that_present_updateCount) {
      if (!(this_present_updateCount && that_present_updateCount))
        return false;
      if (this.updateCount != that.updateCount)
        return false;
    }

    boolean this_present_notes = true && this.isSetNotes();
    boolean that_present_notes = true && that.isSetNotes();
    if (this_present_notes || that_present_notes) {
      if (!(this_present_notes && that_present_notes))
        return false;
      if (!this.notes.equals(that.notes))
        return false;
    }

    boolean this_present_notebooks = true && this.isSetNotebooks();
    boolean that_present_notebooks = true && that.isSetNotebooks();
    if (this_present_notebooks || that_present_notebooks) {
      if (!(this_present_notebooks && that_present_notebooks))
        return false;
      if (!this.notebooks.equals(that.notebooks))
        return false;
    }

    boolean this_present_tags = true && this.isSetTags();
    boolean that_present_tags = true && that.isSetTags();
    if (this_present_tags || that_present_tags) {
      if (!(this_present_tags && that_present_tags))
        return false;
      if (!this.tags.equals(that.tags))
        return false;
    }

    boolean this_present_searches = true && this.isSetSearches();
    boolean that_present_searches = true && that.isSetSearches();
    if (this_present_searches || that_present_searches) {
      if (!(this_present_searches && that_present_searches))
        return false;
      if (!this.searches.equals(that.searches))
        return false;
    }

    boolean this_present_resources = true && this.isSetResources();
    boolean that_present_resources = true && that.isSetResources();
    if (this_present_resources || that_present_resources) {
      if (!(this_present_resources && that_present_resources))
        return false;
      if (!this.resources.equals(that.resources))
        return false;
    }

    boolean this_present_expungedNotes = true && this.isSetExpungedNotes();
    boolean that_present_expungedNotes = true && that.isSetExpungedNotes();
    if (this_present_expungedNotes || that_present_expungedNotes) {
      if (!(this_present_expungedNotes && that_present_expungedNotes))
        return false;
      if (!this.expungedNotes.equals(that.expungedNotes))
        return false;
    }

    boolean this_present_expungedNotebooks = true && this.isSetExpungedNotebooks();
    boolean that_present_expungedNotebooks = true && that.isSetExpungedNotebooks();
    if (this_present_expungedNotebooks || that_present_expungedNotebooks) {
      if (!(this_present_expungedNotebooks && that_present_expungedNotebooks))
        return false;
      if (!this.expungedNotebooks.equals(that.expungedNotebooks))
        return false;
    }

    boolean this_present_expungedTags = true && this.isSetExpungedTags();
    boolean that_present_expungedTags = true && that.isSetExpungedTags();
    if (this_present_expungedTags || that_present_expungedTags) {
      if (!(this_present_expungedTags && that_present_expungedTags))
        return false;
      if (!this.expungedTags.equals(that.expungedTags))
        return false;
    }

    boolean this_present_expungedSearches = true && this.isSetExpungedSearches();
    boolean that_present_expungedSearches = true && that.isSetExpungedSearches();
    if (this_present_expungedSearches || that_present_expungedSearches) {
      if (!(this_present_expungedSearches && that_present_expungedSearches))
        return false;
      if (!this.expungedSearches.equals(that.expungedSearches))
        return false;
    }

    return true;
  }

  public int hashCode() {
    return 0;
  }

  public int compareTo(SyncChunk other) {
    if (!getClass().equals(other.getClass())) {
      return getClass().getName().compareTo(other.getClass().getName());
    }

    int lastComparison = 0;
    SyncChunk typedOther = (SyncChunk)other;

    lastComparison = Boolean.valueOf(isSetCurrentTime()).compareTo(isSetCurrentTime());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(currentTime, typedOther.currentTime);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetChunkHighUSN()).compareTo(isSetChunkHighUSN());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(chunkHighUSN, typedOther.chunkHighUSN);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetUpdateCount()).compareTo(isSetUpdateCount());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(updateCount, typedOther.updateCount);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetNotes()).compareTo(isSetNotes());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(notes, typedOther.notes);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetNotebooks()).compareTo(isSetNotebooks());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(notebooks, typedOther.notebooks);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetTags()).compareTo(isSetTags());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(tags, typedOther.tags);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetSearches()).compareTo(isSetSearches());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(searches, typedOther.searches);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetResources()).compareTo(isSetResources());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(resources, typedOther.resources);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetExpungedNotes()).compareTo(isSetExpungedNotes());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(expungedNotes, typedOther.expungedNotes);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetExpungedNotebooks()).compareTo(isSetExpungedNotebooks());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(expungedNotebooks, typedOther.expungedNotebooks);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetExpungedTags()).compareTo(isSetExpungedTags());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(expungedTags, typedOther.expungedTags);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetExpungedSearches()).compareTo(isSetExpungedSearches());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(expungedSearches, typedOther.expungedSearches);
    if (lastComparison != 0) {
      return lastComparison;
    }
    return 0;
  }

  public void read(TProtocol iprot) throws TException {
    TField field;
    iprot.readStructBegin();
    while (true)
    {
      field = iprot.readFieldBegin();
      if (field.type == TType.STOP) { 
        break;
      }
      _Fields fieldId = _Fields.findByThriftId(field.id);
      if (fieldId == null) {
        TProtocolUtil.skip(iprot, field.type);
      } else {
        switch (fieldId) {
          case CURRENT_TIME:
            if (field.type == TType.I64) {
              this.currentTime = iprot.readI64();
              setCurrentTimeIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case CHUNK_HIGH_USN:
            if (field.type == TType.I32) {
              this.chunkHighUSN = iprot.readI32();
              setChunkHighUSNIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case UPDATE_COUNT:
            if (field.type == TType.I32) {
              this.updateCount = iprot.readI32();
              setUpdateCountIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case NOTES:
            if (field.type == TType.LIST) {
              {
                TList _list0 = iprot.readListBegin();
                this.notes = new ArrayList<com.evernote.edam.type.Note>(_list0.size);
                for (int _i1 = 0; _i1 < _list0.size; ++_i1)
                {
                  com.evernote.edam.type.Note _elem2;
                  _elem2 = new com.evernote.edam.type.Note();
                  _elem2.read(iprot);
                  this.notes.add(_elem2);
                }
                iprot.readListEnd();
              }
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case NOTEBOOKS:
            if (field.type == TType.LIST) {
              {
                TList _list3 = iprot.readListBegin();
                this.notebooks = new ArrayList<com.evernote.edam.type.Notebook>(_list3.size);
                for (int _i4 = 0; _i4 < _list3.size; ++_i4)
                {
                  com.evernote.edam.type.Notebook _elem5;
                  _elem5 = new com.evernote.edam.type.Notebook();
                  _elem5.read(iprot);
                  this.notebooks.add(_elem5);
                }
                iprot.readListEnd();
              }
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case TAGS:
            if (field.type == TType.LIST) {
              {
                TList _list6 = iprot.readListBegin();
                this.tags = new ArrayList<com.evernote.edam.type.Tag>(_list6.size);
                for (int _i7 = 0; _i7 < _list6.size; ++_i7)
                {
                  com.evernote.edam.type.Tag _elem8;
                  _elem8 = new com.evernote.edam.type.Tag();
                  _elem8.read(iprot);
                  this.tags.add(_elem8);
                }
                iprot.readListEnd();
              }
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case SEARCHES:
            if (field.type == TType.LIST) {
              {
                TList _list9 = iprot.readListBegin();
                this.searches = new ArrayList<com.evernote.edam.type.SavedSearch>(_list9.size);
                for (int _i10 = 0; _i10 < _list9.size; ++_i10)
                {
                  com.evernote.edam.type.SavedSearch _elem11;
                  _elem11 = new com.evernote.edam.type.SavedSearch();
                  _elem11.read(iprot);
                  this.searches.add(_elem11);
                }
                iprot.readListEnd();
              }
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case RESOURCES:
            if (field.type == TType.LIST) {
              {
                TList _list12 = iprot.readListBegin();
                this.resources = new ArrayList<com.evernote.edam.type.Resource>(_list12.size);
                for (int _i13 = 0; _i13 < _list12.size; ++_i13)
                {
                  com.evernote.edam.type.Resource _elem14;
                  _elem14 = new com.evernote.edam.type.Resource();
                  _elem14.read(iprot);
                  this.resources.add(_elem14);
                }
                iprot.readListEnd();
              }
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case EXPUNGED_NOTES:
            if (field.type == TType.LIST) {
              {
                TList _list15 = iprot.readListBegin();
                this.expungedNotes = new ArrayList<String>(_list15.size);
                for (int _i16 = 0; _i16 < _list15.size; ++_i16)
                {
                  String _elem17;
                  _elem17 = iprot.readString();
                  this.expungedNotes.add(_elem17);
                }
                iprot.readListEnd();
              }
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case EXPUNGED_NOTEBOOKS:
            if (field.type == TType.LIST) {
              {
                TList _list18 = iprot.readListBegin();
                this.expungedNotebooks = new ArrayList<String>(_list18.size);
                for (int _i19 = 0; _i19 < _list18.size; ++_i19)
                {
                  String _elem20;
                  _elem20 = iprot.readString();
                  this.expungedNotebooks.add(_elem20);
                }
                iprot.readListEnd();
              }
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case EXPUNGED_TAGS:
            if (field.type == TType.LIST) {
              {
                TList _list21 = iprot.readListBegin();
                this.expungedTags = new ArrayList<String>(_list21.size);
                for (int _i22 = 0; _i22 < _list21.size; ++_i22)
                {
                  String _elem23;
                  _elem23 = iprot.readString();
                  this.expungedTags.add(_elem23);
                }
                iprot.readListEnd();
              }
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case EXPUNGED_SEARCHES:
            if (field.type == TType.LIST) {
              {
                TList _list24 = iprot.readListBegin();
                this.expungedSearches = new ArrayList<String>(_list24.size);
                for (int _i25 = 0; _i25 < _list24.size; ++_i25)
                {
                  String _elem26;
                  _elem26 = iprot.readString();
                  this.expungedSearches.add(_elem26);
                }
                iprot.readListEnd();
              }
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
        }
        iprot.readFieldEnd();
      }
    }
    iprot.readStructEnd();
    validate();
  }

  public void write(TProtocol oprot) throws TException {
    validate();

    oprot.writeStructBegin(STRUCT_DESC);
    oprot.writeFieldBegin(CURRENT_TIME_FIELD_DESC);
    oprot.writeI64(this.currentTime);
    oprot.writeFieldEnd();
    if (isSetChunkHighUSN()) {
      oprot.writeFieldBegin(CHUNK_HIGH_USN_FIELD_DESC);
      oprot.writeI32(this.chunkHighUSN);
      oprot.writeFieldEnd();
    }
    oprot.writeFieldBegin(UPDATE_COUNT_FIELD_DESC);
    oprot.writeI32(this.updateCount);
    oprot.writeFieldEnd();
    if (this.notes != null) {
      if (isSetNotes()) {
        oprot.writeFieldBegin(NOTES_FIELD_DESC);
        {
          oprot.writeListBegin(new TList(TType.STRUCT, this.notes.size()));
          for (com.evernote.edam.type.Note _iter27 : this.notes)
          {
            _iter27.write(oprot);
          }
          oprot.writeListEnd();
        }
        oprot.writeFieldEnd();
      }
    }
    if (this.notebooks != null) {
      if (isSetNotebooks()) {
        oprot.writeFieldBegin(NOTEBOOKS_FIELD_DESC);
        {
          oprot.writeListBegin(new TList(TType.STRUCT, this.notebooks.size()));
          for (com.evernote.edam.type.Notebook _iter28 : this.notebooks)
          {
            _iter28.write(oprot);
          }
          oprot.writeListEnd();
        }
        oprot.writeFieldEnd();
      }
    }
    if (this.tags != null) {
      if (isSetTags()) {
        oprot.writeFieldBegin(TAGS_FIELD_DESC);
        {
          oprot.writeListBegin(new TList(TType.STRUCT, this.tags.size()));
          for (com.evernote.edam.type.Tag _iter29 : this.tags)
          {
            _iter29.write(oprot);
          }
          oprot.writeListEnd();
        }
        oprot.writeFieldEnd();
      }
    }
    if (this.searches != null) {
      if (isSetSearches()) {
        oprot.writeFieldBegin(SEARCHES_FIELD_DESC);
        {
          oprot.writeListBegin(new TList(TType.STRUCT, this.searches.size()));
          for (com.evernote.edam.type.SavedSearch _iter30 : this.searches)
          {
            _iter30.write(oprot);
          }
          oprot.writeListEnd();
        }
        oprot.writeFieldEnd();
      }
    }
    if (this.resources != null) {
      if (isSetResources()) {
        oprot.writeFieldBegin(RESOURCES_FIELD_DESC);
        {
          oprot.writeListBegin(new TList(TType.STRUCT, this.resources.size()));
          for (com.evernote.edam.type.Resource _iter31 : this.resources)
          {
            _iter31.write(oprot);
          }
          oprot.writeListEnd();
        }
        oprot.writeFieldEnd();
      }
    }
    if (this.expungedNotes != null) {
      if (isSetExpungedNotes()) {
        oprot.writeFieldBegin(EXPUNGED_NOTES_FIELD_DESC);
        {
          oprot.writeListBegin(new TList(TType.STRING, this.expungedNotes.size()));
          for (String _iter32 : this.expungedNotes)
          {
            oprot.writeString(_iter32);
          }
          oprot.writeListEnd();
        }
        oprot.writeFieldEnd();
      }
    }
    if (this.expungedNotebooks != null) {
      if (isSetExpungedNotebooks()) {
        oprot.writeFieldBegin(EXPUNGED_NOTEBOOKS_FIELD_DESC);
        {
          oprot.writeListBegin(new TList(TType.STRING, this.expungedNotebooks.size()));
          for (String _iter33 : this.expungedNotebooks)
          {
            oprot.writeString(_iter33);
          }
          oprot.writeListEnd();
        }
        oprot.writeFieldEnd();
      }
    }
    if (this.expungedTags != null) {
      if (isSetExpungedTags()) {
        oprot.writeFieldBegin(EXPUNGED_TAGS_FIELD_DESC);
        {
          oprot.writeListBegin(new TList(TType.STRING, this.expungedTags.size()));
          for (String _iter34 : this.expungedTags)
          {
            oprot.writeString(_iter34);
          }
          oprot.writeListEnd();
        }
        oprot.writeFieldEnd();
      }
    }
    if (this.expungedSearches != null) {
      if (isSetExpungedSearches()) {
        oprot.writeFieldBegin(EXPUNGED_SEARCHES_FIELD_DESC);
        {
          oprot.writeListBegin(new TList(TType.STRING, this.expungedSearches.size()));
          for (String _iter35 : this.expungedSearches)
          {
            oprot.writeString(_iter35);
          }
          oprot.writeListEnd();
        }
        oprot.writeFieldEnd();
      }
    }
    oprot.writeFieldStop();
    oprot.writeStructEnd();
  }

  public String toString() {
    StringBuilder sb = new StringBuilder("SyncChunk(");
    boolean first = true;

    sb.append("currentTime:");
    sb.append(this.currentTime);
    first = false;
    if (isSetChunkHighUSN()) {
      if (!first) sb.append(", ");
      sb.append("chunkHighUSN:");
      sb.append(this.chunkHighUSN);
      first = false;
    }
    if (!first) sb.append(", ");
    sb.append("updateCount:");
    sb.append(this.updateCount);
    first = false;
    if (isSetNotes()) {
      if (!first) sb.append(", ");
      sb.append("notes:");
      if (this.notes == null) {
        sb.append("null");
      } else {
        sb.append(this.notes);
      }
      first = false;
    }
    if (isSetNotebooks()) {
      if (!first) sb.append(", ");
      sb.append("notebooks:");
      if (this.notebooks == null) {
        sb.append("null");
      } else {
        sb.append(this.notebooks);
      }
      first = false;
    }
    if (isSetTags()) {
      if (!first) sb.append(", ");
      sb.append("tags:");
      if (this.tags == null) {
        sb.append("null");
      } else {
        sb.append(this.tags);
      }
      first = false;
    }
    if (isSetSearches()) {
      if (!first) sb.append(", ");
      sb.append("searches:");
      if (this.searches == null) {
        sb.append("null");
      } else {
        sb.append(this.searches);
      }
      first = false;
    }
    if (isSetResources()) {
      if (!first) sb.append(", ");
      sb.append("resources:");
      if (this.resources == null) {
        sb.append("null");
      } else {
        sb.append(this.resources);
      }
      first = false;
    }
    if (isSetExpungedNotes()) {
      if (!first) sb.append(", ");
      sb.append("expungedNotes:");
      if (this.expungedNotes == null) {
        sb.append("null");
      } else {
        sb.append(this.expungedNotes);
      }
      first = false;
    }
    if (isSetExpungedNotebooks()) {
      if (!first) sb.append(", ");
      sb.append("expungedNotebooks:");
      if (this.expungedNotebooks == null) {
        sb.append("null");
      } else {
        sb.append(this.expungedNotebooks);
      }
      first = false;
    }
    if (isSetExpungedTags()) {
      if (!first) sb.append(", ");
      sb.append("expungedTags:");
      if (this.expungedTags == null) {
        sb.append("null");
      } else {
        sb.append(this.expungedTags);
      }
      first = false;
    }
    if (isSetExpungedSearches()) {
      if (!first) sb.append(", ");
      sb.append("expungedSearches:");
      if (this.expungedSearches == null) {
        sb.append("null");
      } else {
        sb.append(this.expungedSearches);
      }
      first = false;
    }
    sb.append(")");
    return sb.toString();
  }

  public void validate() throws TException {
    // check for required fields
    if (!isSetCurrentTime()) {
      throw new TProtocolException("Required field 'currentTime' is unset! Struct:" + toString());
    }

    if (!isSetUpdateCount()) {
      throw new TProtocolException("Required field 'updateCount' is unset! Struct:" + toString());
    }

  }

}

