/*
 * Decompiled with CFR 0.152.
 */
package jp.uclab.sticky;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import jp.uclab.sticky.DragWindowListener;

class ConfirmationDialog
extends JPanel {
    private static final long serialVersionUID = -9129249826203027996L;
    String iniFile = "Sticky.ini";
    JDialog dialog;
    JLabel messageLabel;
    JButton okButton;
    JLabel titleLabel;
    Color frameColor = Color.ORANGE;
    Color bodyColor;
    Color borderColor = new Color(100, 100, 100);
    Color titleFontColor;
    Color bodyFontColor;
    int titleFontSize;
    int bodyFontSize;
    Font titleFont;
    Font bodyFont;
    String title;
    String message;
    JFrame parent;
    private static final int W = 4;
    private JLabel left;
    private JLabel right;
    private JLabel top;
    private JLabel bottom;
    private JLabel topleft;
    private JLabel topright;
    private JLabel bottomleft;
    private JLabel bottomright;
    private JPanel resizePanel = new JPanel(new BorderLayout()){
        private static final long serialVersionUID = 7640578183448472309L;

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g.create();
            int w = this.getWidth();
            int h = this.getHeight();
            g2.setPaint(ConfirmationDialog.this.frameColor);
            g2.fillRect(0, 0, w, h);
            g2.setPaint(ConfirmationDialog.this.borderColor);
            g2.drawRect(0, 0, w - 1, h - 1);
            g2.drawLine(0, 2, 2, 0);
            g2.drawLine(w - 3, 0, w - 1, 2);
            g2.clearRect(0, 0, 2, 1);
            g2.clearRect(0, 0, 1, 2);
            g2.clearRect(w - 2, 0, 2, 1);
            g2.clearRect(w - 1, 0, 1, 2);
            g2.dispose();
        }
    };
    private JPanel contentPanel = new JPanel(new BorderLayout());

    public ConfirmationDialog(String title, String message, JFrame parent) {
        super(new BorderLayout());
        this.title = title;
        this.message = message;
        this.parent = parent;
        this.initProperties();
        this.messageLabel = new JLabel(message);
        this.messageLabel.setFont(this.bodyFont);
        this.messageLabel.setOpaque(true);
        this.messageLabel.setBackground(this.bodyColor);
        this.messageLabel.setForeground(this.bodyFontColor);
        this.titleLabel = new JLabel(title);
        this.titleLabel.setFont(this.titleFont);
        this.titleLabel.setOpaque(true);
        this.titleLabel.setBackground(this.frameColor);
        this.titleLabel.setForeground(this.titleFontColor);
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfirmationDialog.this.dialog.getToolkit().getSystemEventQueue().postEvent(new WindowEvent(ConfirmationDialog.this.dialog, 201));
                ConfirmationDialog.this.dialog.dispose();
            }
        });
        this.add((Component)this.messageLabel, "Center");
        JPanel aPanel = new JPanel();
        aPanel.setLayout(new BorderLayout());
        aPanel.add(this.okButton);
        this.add((Component)aPanel, "South");
    }

    public void initProperties() {
        try {
            FileInputStream in = new FileInputStream(new File(this.iniFile));
            Properties prop = new Properties();
            prop.load(in);
            this.frameColor = this.getColor(prop.getProperty("FRAME_COLOR", "#FFD700"));
            this.bodyColor = this.getColor(prop.getProperty("BODY_COLOR", "#FFFFE0"));
            this.titleFontColor = this.getColor(prop.getProperty("TITLE_FONT_COLOR", "#040404"));
            this.bodyFontColor = this.getColor(prop.getProperty("BODY_FONT_COLOR", "#040404"));
            this.titleFontSize = Integer.parseInt(prop.getProperty("TITLE_FONT_SIZE", "12"));
            this.bodyFontSize = Integer.parseInt(prop.getProperty("BODY_FONT_SIZE", "12"));
            this.titleFont = new Font(prop.getProperty("TITLE_FONT", "\u30e1\u30a4\u30ea\u30aa"), 0, this.titleFontSize);
            this.bodyFont = new Font(prop.getProperty("BODY_FONT", "\u30e1\u30a4\u30ea\u30aa"), 0, this.bodyFontSize);
            ((InputStream)in).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JDialog makeFrame() {
        this.dialog = new JDialog(this.parent, true){
            private static final long serialVersionUID = -6170408698660528217L;

            @Override
            public Container getContentPane() {
                return ConfirmationDialog.this.contentPanel;
            }
        };
        ImageIcon icon = new ImageIcon("icon.png");
        this.dialog.setIconImage(icon.getImage());
        this.dialog.setUndecorated(true);
        this.dialog.setBackground(new Color(255, 255, 255, 0));
        JPanel title = new JPanel(new BorderLayout());
        DragWindowListener dwl = new DragWindowListener();
        title.addMouseListener(dwl);
        title.addMouseMotionListener(dwl);
        title.setOpaque(false);
        title.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        title.add(this.titleLabel);
        ResizeWindowListener rwl = new ResizeWindowListener(this.dialog);
        this.left = new JLabel();
        this.right = new JLabel();
        this.top = new JLabel();
        this.bottom = new JLabel();
        this.topleft = new JLabel();
        this.topright = new JLabel();
        this.bottomleft = new JLabel();
        this.bottomright = new JLabel();
        for (JLabel l : Arrays.asList(this.left, this.right, this.top, this.bottom, this.topleft, this.topright, this.bottomleft, this.bottomright)) {
            l.addMouseListener(rwl);
            l.addMouseMotionListener(rwl);
        }
        Dimension d = new Dimension(4, 0);
        this.left.setPreferredSize(d);
        this.left.setMinimumSize(d);
        this.right.setPreferredSize(d);
        this.right.setMinimumSize(d);
        d = new Dimension(0, 4);
        this.top.setPreferredSize(d);
        this.top.setMinimumSize(d);
        this.bottom.setPreferredSize(d);
        this.bottom.setMinimumSize(d);
        d = new Dimension(4, 4);
        this.topleft.setPreferredSize(d);
        this.topleft.setMinimumSize(d);
        this.topright.setPreferredSize(d);
        this.topright.setMinimumSize(d);
        this.bottomleft.setPreferredSize(d);
        this.bottomleft.setMinimumSize(d);
        this.bottomright.setPreferredSize(d);
        this.bottomright.setMinimumSize(d);
        this.left.setCursor(Cursor.getPredefinedCursor(10));
        this.right.setCursor(Cursor.getPredefinedCursor(11));
        this.top.setCursor(Cursor.getPredefinedCursor(8));
        this.bottom.setCursor(Cursor.getPredefinedCursor(9));
        this.topleft.setCursor(Cursor.getPredefinedCursor(6));
        this.topright.setCursor(Cursor.getPredefinedCursor(7));
        this.bottomleft.setCursor(Cursor.getPredefinedCursor(4));
        this.bottomright.setCursor(Cursor.getPredefinedCursor(5));
        JPanel titlePanel = new JPanel(new BorderLayout(0, 0));
        titlePanel.add((Component)this.top, "North");
        titlePanel.add((Component)title, "Center");
        JPanel northPanel = new JPanel(new BorderLayout(0, 0));
        northPanel.add((Component)this.topleft, "West");
        northPanel.add((Component)titlePanel, "Center");
        northPanel.add((Component)this.topright, "East");
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add((Component)this.bottomleft, "West");
        southPanel.add((Component)this.bottom, "Center");
        southPanel.add((Component)this.bottomright, "East");
        this.resizePanel.add((Component)this.left, "West");
        this.resizePanel.add((Component)this.right, "East");
        this.resizePanel.add((Component)northPanel, "North");
        this.resizePanel.add((Component)southPanel, "South");
        this.resizePanel.add((Component)this.contentPanel, "Center");
        titlePanel.setOpaque(false);
        northPanel.setOpaque(false);
        southPanel.setOpaque(false);
        this.contentPanel.setOpaque(false);
        this.resizePanel.setOpaque(false);
        this.dialog.setContentPane(this.resizePanel);
        return this.dialog;
    }

    public static ConfirmationDialog createConfirmationDialog(String title, String message, JFrame parent) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        ConfirmationDialog uf = new ConfirmationDialog(title, message, parent);
        JDialog dialog = uf.makeFrame();
        dialog.getContentPane().add(uf);
        dialog.setMinimumSize(new Dimension(10, 10));
        dialog.pack();
        dialog.setVisible(true);
        return uf;
    }

    public Color getColor(String color) {
        if (color.startsWith("#")) {
            color = color.substring(1);
        }
        int c = Integer.parseInt(color, 16);
        return new Color((c & 0xFF0000) >> 16, (c & 0xFF00) >> 8, c & 0xFF);
    }

    public static void main(String[] args) {
        ConfirmationDialog.createConfirmationDialog("Evernote Login Error", "Please confirm your account.", null);
    }

    class ResizeWindowListener
    extends MouseAdapter {
        private Rectangle startSide = null;
        private final JDialog dialog;

        public ResizeWindowListener(JDialog dialog) {
            this.dialog = dialog;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.startSide = this.dialog.getBounds();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.startSide == null) {
                return;
            }
            Component c = e.getComponent();
            if (c == ConfirmationDialog.this.topleft) {
                this.startSide.y += e.getY();
                this.startSide.height -= e.getY();
                this.startSide.x += e.getX();
                this.startSide.width -= e.getX();
            } else if (c == ConfirmationDialog.this.top) {
                this.startSide.y += e.getY();
                this.startSide.height -= e.getY();
            } else if (c == ConfirmationDialog.this.topright) {
                this.startSide.y += e.getY();
                this.startSide.height -= e.getY();
                this.startSide.width += e.getX();
            } else if (c == ConfirmationDialog.this.left) {
                this.startSide.x += e.getX();
                this.startSide.width -= e.getX();
            } else if (c == ConfirmationDialog.this.right) {
                this.startSide.width += e.getX();
            } else if (c == ConfirmationDialog.this.bottomleft) {
                this.startSide.height += e.getY();
                this.startSide.x += e.getX();
                this.startSide.width -= e.getX();
            } else if (c == ConfirmationDialog.this.bottom) {
                this.startSide.height += e.getY();
            } else if (c == ConfirmationDialog.this.bottomright) {
                this.startSide.height += e.getY();
                this.startSide.width += e.getX();
            }
            this.dialog.setBounds(this.startSide);
        }
    }

    public static enum Side {
        NW_SIDE,
        N_SIDE,
        NE_SIDE,
        L_SIDE,
        R_SIDE,
        SW_SIDE,
        S_SIDE,
        SE_SIDE;

    }
}

