/*
 * Decompiled with CFR 0.152.
 */
package jp.uclab.sticky;

import com.evernote.edam.notestore.NoteFilter;
import com.evernote.edam.notestore.NoteList;
import com.evernote.edam.type.Note;
import com.evernote.edam.type.NoteSortOrder;
import com.evernote.edam.type.Notebook;
import java.util.List;
import jp.uclab.sticky.EVNote;
import jp.uclab.sticky.StickyManager;

public class EvernoteThread
extends Thread {
    StickyManager manager = null;

    public EvernoteThread(StickyManager manager) {
        this.manager = manager;
    }

    @Override
    public void run() {
        try {
            System.out.println("\u691c\u7d22\u958b\u59cb");
            this.searchEvernote();
            System.out.println("\u691c\u7d22\u7d42\u4e86");
            this.manager.updateSticky();
            System.out.println("\u540c\u671f\u5b8c\u4e86");
        }
        catch (Exception e) {
            System.err.println("\u691c\u7d22\u5931\u6557");
            this.manager.searchFailed();
        }
    }

    public void searchEvernote() throws Exception {
        this.manager.evnoteList.clear();
        for (Notebook notebook : this.manager.notebooks) {
            NoteFilter filter = new NoteFilter();
            filter.setOrder(NoteSortOrder.CREATED.getValue());
            filter.setAscending(false);
            filter.setNotebookGuid(notebook.getGuid());
            filter.setWords("tag:" + this.manager.TAG);
            NoteList noteList = this.manager.noteStore.findNotes(this.manager.authToken, filter, 0, this.manager.LIST_MAX);
            List<Note> notes = noteList.getNotes();
            for (Note note : notes) {
                String content = this.manager.noteStore.getNoteContent(this.manager.authToken, note.getGuid());
                List<String> tags = this.manager.noteStore.getNoteTagNames(this.manager.authToken, note.getGuid());
                if (tags != null) {
                    tags.remove(this.manager.TAG);
                }
                String fullContent = content = this.manager.evn2html(content);
                EVNote evn = new EVNote(note.getTitle(), tags, content, note, fullContent);
                this.manager.evnoteList.add(evn);
            }
        }
    }
}

