#pragma once

#include "IOBase.h"
#include "CursorInfo.h"
#include "ScrollInfo.h"
#include "Formatter.h"
#include "Undo.h"
#include "InputManager.h"
#include "SearchInfo.h"
#include <list>

class IDocumentEventListener;

/*
	Document
	f[^Ɋւ̂łł߂NX
	̃NXɃANZXΑT͎̂̂ɓ

	_݌v̓T^
*/
class Document
{
public:
	Document();

	//Cxgʒmp
	void AddListener(IDocumentEventListener* object);
	void NotifyReconstruct();
	void NotifyRefresh();

	//t@CIy[V
	void New();
	bool Open( const std::string& filepath );
	bool Save( const std::string& filepath );

	//obt@Iy[V(Undo@\Kp)
	bool DoAction(ActionList list);
	bool Undo();
	bool Redo();
	bool CanUndo() const;
	bool CanRedo() const;

	//Agr[g
	ulong Size() const;
	bool IsModified() const;
	std::string GetFilePath() const;

	//}E㏑
	bool IsInsertMode() const;
	void SetInsertMode(bool insert);

	//J[\
	Cursor_ptr GetCursor() const;

	//XN[
	Scroll_ptr GetScroll() const;

	//f[^
	Formatter_ptr GetFormat() const;

	//L[͏
	InputManager_ptr GetInputInfo() const;

	//
	Search_ptr GetSearchInfo() const;

	//f[^ANZX
	ulong Read( ulong offset, ulong size, uchar *buffer );
	buffer_iterator Begin() const;
	buffer_iterator At(ulong offset) const;
	buffer_iterator End() const;
	
private:
	//Cxgʒmp
	std::list<IDocumentEventListener*> listenerlist_;

	//t@CIO
	Buffer_ptr buffer_;				//obt@OpNXCX^X
	Reader_ptr reader_;				//f[^ǂݍݗpNXCX^X
	Writer_ptr writer_;				//f[^ݗpNXCX^X

	//Agr[g
	bool file_loaded_;				//t@Cw肳Ă邩
	std::string filepath_;			//w肳ꂽt@C
	bool modified_;					//t@CҏWꂽ
	bool insertmode_;				//}㏑

	//J[\
	Cursor_ptr cursor_;				//J[\f[^ƑpCX^X

	//XN[
	Scroll_ptr scroll_;				//XN[Ɋւf[^

	//f[^
	Formatter_ptr formatter_;	//f[^CX^X
	FormatType formattype_;		//f[^

	//AhDXg
	UndoManager undo_;

	//̓obt@
	InputManager_ptr inputmanager_;

	//
	Search_ptr search_;

	void Reset();
	void RaiseEvent();
	void InitFormatter();
};

typedef boost::shared_ptr<Document> Document_ptr;

class IDocumentAccessor
{
public:
	virtual ~IDocumentAccessor();
	virtual void SetDocument(Document_ptr doc);
	virtual Document_ptr GetDocument() const;

protected:
	Document_ptr doc_;
};

class IDocumentEventListener
{
public:
	typedef enum {
		Reconstruction,	//č\zKvȒx̍XV
		Refresh,		//ĕ`ōςޒx̍XV
	} EventType;
	virtual void OnUpdate(EventType type);
};

bool CheckInDataRange( Document_ptr document);
bool CheckInDataRange( Document_ptr document, Cursor_ptr cursor );
bool CheckInEditRange( Document_ptr document);
bool CheckInEditRange( Document_ptr document, Cursor_ptr cursor );
void AdjustRange( Document_ptr document );
