#pragma once

#include "Action.h"

class Document;
class CursorInfo;



/*
	InsertAction
	w̃f[^wʒuɑ}邽߂̃ANV

	Redo : }
	Undo : 폜
*/
class InsertAction : public IAction
{
public:
	InsertAction(Document *document, MemoryBlock memory, ulong offset);

	bool UndoAction(IBuffer* buffer);
	bool RedoAction(IBuffer* buffer);

private:
	class Impl;
	boost::shared_ptr<Impl> pimpl_;
};

/*
	RemoveAction
	w͈͂̃f[^폜邽߂̃ANV

	Redo : 폜
	Undo : }
*/
class RemoveAction : public IAction
{
public:
	RemoveAction(Document *document);

	bool UndoAction(IBuffer* buffer);
	bool RedoAction(IBuffer* buffer);

private:
	class Impl;
	boost::shared_ptr<Impl> pimpl_;
};

/*
	OverStrikeAction
	w͈͂̃f[^㏑邽߂̃ANV

	Redo : ㏑
	Undo : ㏑
*/
class OverStrikeAction : public IAction
{
public:
	OverStrikeAction(Document *document, MemoryBlock memory, ulong offset);

	bool UndoAction(IBuffer* buffer);
	bool RedoAction(IBuffer* buffer);

private:
	class Impl;
	boost::shared_ptr<Impl> pimpl_;
};

/*
	CursorAction
	J[\ύX邽߂̃ANV

	Redo : J[\Ԑݒ
	Undo : J[\Ԑݒ
*/
class CursorAction : public IAction
{
public:
	CursorAction(Document* document, const CursorInfo& newposition);

	bool UndoAction(IBuffer* buffer);
	bool RedoAction(IBuffer* buffer);

private:
	class Impl;
	boost::shared_ptr<Impl> pimpl_;
};
