#pragma once

#include "CommandHandler.h"
#include "UIUpdater.h"
#include "resource.h"

/*
	EditCommandHandler
	ɁuҏWvj[̃R}h邽߂̃NX
*/
class EditCommandHandler
	: public CommandHandlerBase,
	  public CUIUpdater<EditCommandHandler>
{
public:
	BEGIN_MSG_MAP(EditCommandHandler)
		COMMAND_ID_HANDLER(ID_EDIT_UNDO,OnEditUndo)
		COMMAND_ID_HANDLER(ID_EDIT_REDO,OnEditRedo)
		COMMAND_ID_HANDLER(ID_EDIT_CUT,OnEditCut)
		COMMAND_ID_HANDLER(ID_EDIT_COPY,OnEditCopy)
		COMMAND_ID_HANDLER(ID_EDIT_PASTE,OnEditPaste)
		COMMAND_ID_HANDLER(ID_EDIT_CLEAR,OnEditClear)

		CHAIN_MSG_MAP(CUIUpdater<EditCommandHandler>)
	END_MSG_MAP()

	BEGIN_ORIGINAL_UPDATE_UI_MAP()
		UI_UPDATE_ITEM(ID_EDIT_UNDO,OnUIUpdateEditUndo)
		UI_UPDATE_ITEM(ID_EDIT_REDO,OnUIUpdateEditRedo)
		UI_UPDATE_ITEM(ID_EDIT_CUT,OnUIUpdateEditCut)
		UI_UPDATE_ITEM(ID_EDIT_COPY,OnUIUpdateEditCopy)
		UI_UPDATE_ITEM(ID_EDIT_PASTE,OnUIUpdateEditPaste)
		UI_UPDATE_ITEM(ID_EDIT_CLEAR,OnUIUpdateEditClear)
	END_ORIGINAL_UPDATE_UI_MAP()

private:
	LRESULT OnEditUndo(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);
	LRESULT OnEditRedo(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);
	LRESULT OnEditCut(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);
	LRESULT OnEditCopy(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);
	LRESULT OnEditPaste(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);
	LRESULT OnEditClear(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);

	void OnUIUpdateEditUndo( CUIItem& item );
	void OnUIUpdateEditRedo( CUIItem& item );
	void OnUIUpdateEditCut( CUIItem& item );
	void OnUIUpdateEditCopy( CUIItem& item );
	void OnUIUpdateEditPaste( CUIItem& item );
	void OnUIUpdateEditClear( CUIItem& item );

	void Remove();
	void Copy();
};