#include "stdafx.h"
#include "IOBase.h"


//interface of FileReaderImpl
class FileReader::Impl
{
public:
	Impl( const std::string& filepath );
	IReader::Result Read( ulong offset, ulong size, uchar *buffer, ulong& readsize );
	ulong Size() const;

private:
	std::string filepath_;
};

FileReader::Impl::Impl( const std::string& filepath )
	: filepath_(filepath)
{
}

IReader::Result FileReader::Impl::Read( ulong offset, ulong size, uchar *buffer, ulong& readsize )
{
	//t@CJēǂݍŕ

	FILE *file;

	file = fopen(filepath_.c_str(),"rb");
	if(!file)
		return error;

	FileHandler filehandle(file);	

	if(fseek(file,offset,SEEK_SET)!=0)
		return error;
	
	readsize = fread(buffer,1,size,file);
	if(readsize!=size){
		if(feof(file)){
			return eof;
		}else{
			return error;
		}
	}

	return success;
}

ulong FileReader::Impl::Size() const
{
	//t@C̖܂ŃV[NăTCY擾

	FILE *file;

	file = fopen(filepath_.c_str(),"rb");
	if(!file)
		return 0;
	
	FileHandler filehandle(file);

	long curpos = ftell(file);
	if(fseek(file,0,SEEK_END)!=0)
		return 0;
	
	long size = ftell(file);
	if(fseek(file,curpos,SEEK_SET)!=0)
		return 0;

	return size;
}

//implementation of FileReader
FileReader::FileReader( const std::string& filepath )
{
	pimpl_ = boost::shared_ptr<Impl>(new Impl(filepath));
}

IReader::Result FileReader::Read( ulong offset, ulong size, uchar *buffer, ulong& readsize )
{
	return pimpl_->Read(offset,size,buffer,readsize); 
}

ulong FileReader::Size() const
{
	return pimpl_->Size();
}
