#include "stdafx.h"
#include "IOBase.h"

class FileWriter::Impl
{
public:
	Impl( const std::string& filepath );
	bool Write( ulong offset, ulong size, uchar *buffer );

private:
	std::string filepath_;
};

FileWriter::Impl::Impl( const std::string& filepath )
	: filepath_(filepath)
{
}

bool FileWriter::Impl::Write( ulong offset, ulong size, uchar *buffer )
{
	FILE *file;

	file = fopen(filepath_.c_str(),"wb");
	if(!file)
		return false;

	FileHandler filehandle(file);

	if(fseek(file,offset,SEEK_SET)!=0)
		return false;

	if(fwrite(buffer,1,size,file)!=size)
		return false;

	return true;
}

//Implemetation of FileWriter
FileWriter::FileWriter( const std::string& filepath )
{
	pimpl_ = boost::shared_ptr<Impl>(new Impl(filepath));
}

bool FileWriter::Write( ulong offset, ulong size, uchar *buffer )
{
	return pimpl_->Write(offset,size,buffer);
}
