#pragma once

#include <string>

namespace Format
{
	/*
		Format::DataType
		f[^̕\`̎ނ\񋓌^
	*/
	typedef enum
	{
		None,		//s
		Binary,		//2i
		Octal,		//8i
		Decimal,	//10i
		Hex,		//16i
	} DataType;
}

struct ItemFormat
{
	ulong offset;		//ڂ̍sł̊Jnʒu
	ulong size;			//ڂ̃TCY(Xy[X܂)
	ulong bodyoffset;	//Xy[Xg̊Jnʒu(offset̂ɃItZbg)
	ulong bodysize;		//Xy[Xg̃TCY
	ulong index;		//ʂԍ(oCg16i\ƕ\͓ԍ)

	ulong bytecount;		//oCg
	bool editable;			//̍ڂɑ΂ăL[ɂ͂s邩
	Format::DataType type;	//f[^̌`

	ItemFormat()
	{
	}
	ItemFormat(ulong offset_, ulong size_, ulong bodyoffset_, ulong bodysize_, 
			   ulong index_, ulong bytecount_, bool editable_ = false, Format::DataType type_ = Format::None)
		: offset(offset_), size(size_), bodyoffset(bodyoffset_), bodysize(bodysize_), 
		  index(index_), bytecount(bytecount_), editable(editable_), type(type_)
	{
	}
};

struct LineFormat
{
	std::string text;
	std::vector<ItemFormat> items;
};
typedef boost::shared_ptr<LineFormat> LineFormat_ptr;

/*
	IFormatter
	f[^ǂ̂悤ɕ\邩Ƃuv񋟂C^[tFCX

	f[^2i16iŕ\A
	2oCgPʂ4oCgPʂŕ\AƂĕ\A
	lXȕ\|[tBYŐ؂ւ悤
	C^[tFCX񋟂

	͌\

	Ō1ڕAf[^̑}pJ[\\邽߂̃_~[f[^
	pӂKv
		
*/
class IFormatter
{
public:
	virtual ~IFormatter();

	virtual ulong GetRowCount() const = 0;						//f[^̑sԂ	
	virtual ulong GetColumnCount(ulong lineindex) const = 0;	//w̍šԂ
	virtual ulong GetItemCount(ulong lineindex) const = 0;		//w̍s̃f[^Ԃ
	virtual ulong GetMaxColumnCount() const = 0;				//Ŝł̍ő包Ԃ
	virtual LineFormat_ptr GetLine(ulong lineindex) = 0;		//ws̃f[^Ԃ
	virtual LineFormat_ptr GetHeader(ulong lineindex) = 0;		//ws̖}ᕶԂ
	virtual ulong LineIndex2Offset(ulong lineindex) const = 0;	//ws̐擪AhXԂ
	virtual ulong Offset2LineIndex(ulong offset) const = 0;		//w肵AhX̂sԂ
};
typedef boost::shared_ptr<IFormatter> Formatter_ptr;

class Document;

/*
	SimpleFormatter
	tH[}b^̃Tv

	16ił1oCgPʕ\ƁAEɕ\tH[}b^

	O̊ɂ̓Vvł͂Ȃ
*/
class SimpleFormatter : public IFormatter
{
public:
	SimpleFormatter(Document& document);

	ulong GetRowCount() const;
	ulong GetColumnCount(ulong lineindex) const;
	ulong GetItemCount(ulong lineindex) const;
	ulong GetMaxColumnCount() const;
	LineFormat_ptr GetLine(ulong lineindex);
	LineFormat_ptr GetHeader(ulong lineindex);
	ulong LineIndex2Offset(ulong lineindex) const;
	ulong Offset2LineIndex(ulong offset) const;

private:
	class Impl;
	boost::shared_ptr<Impl> pimpl_;
};

typedef enum 
{
	Format_Simple = 0,
} FormatType;
