#include "stdafx.h"
#include "JumpDialog.h"
#include "Utility.h"
#include "resource.h"

const int JumpDialog::IDD = IDD_DIALOG_JUMP;

void JumpDialog::SetAddress(ulong address)
{
	address_ = address;
}

ulong JumpDialog::GetAddress() const
{
	return address_;
}

BOOL JumpDialog::DoDataExchange(BOOL bSaveAndValidate, UINT nCtlID)
{
	nCtlID;

	char buffer[100];

	if(bSaveAndValidate){
		if(!DDX_Text(IDC_TEXT_ADDRESS, buffer, sizeof(buffer), bSaveAndValidate))
			return FALSE;
		std::string str = buffer;
		boost::optional<ulong> address = convert_from_hexstring(str);
		if(address){
			address_ = *address;
			return TRUE;
		}else{
			return FALSE;
		}
	}else{
		std::string str = convert_to_hexstring(address_);
		strncpy(buffer,str.c_str(),sizeof(buffer)-1); buffer[100-1] = '\0';
		return DDX_Text(IDC_TEXT_ADDRESS, buffer, sizeof(buffer), bSaveAndValidate);
	}
}

LRESULT JumpDialog::OnInitDialog(HWND hWnd, LPARAM lParam)
{
	hWnd;
	lParam;

	CenterWindow();

	DoDataExchange(FALSE);
	CEdit editbox(GetDlgItem(IDC_TEXT_ADDRESS));
	editbox.SetSelAll();

	return 0;
}
	
LRESULT JumpDialog::OnOK(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
{
	wNotifyCode;
	wID;
	hWndCtl;
	bHandled;

	if(DoDataExchange(TRUE)){
		EndDialog(IDOK);
	}
	return 0;
}

LRESULT JumpDialog::OnCancel(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
{
	wNotifyCode;
	wID;
	hWndCtl;
	bHandled;

	EndDialog(IDCANCEL);
	return 0;
}