#include "stdafx.h"
#include "ScrollView.h"

//VScrollBar Functions
int CScrollView::GetVScrollPos() const
{
	return ::GetScrollPos(m_hWnd, SB_VERT);
}
int CScrollView::SetVScrollPos(int nPos, BOOL bRedraw)
{
	return ::SetScrollPos(m_hWnd, SB_VERT, nPos, bRedraw);
}
void CScrollView::GetVScrollRange(LPINT lpMinPos, LPINT lpMaxPos) const
{
	::GetScrollRange(m_hWnd, SB_VERT, lpMinPos, lpMaxPos);
}
void CScrollView::SetVScrollRange(int nMinPos, int nMaxPos, BOOL bRedraw)
{
	::SetScrollRange(m_hWnd, SB_VERT, nMinPos, nMaxPos, bRedraw);
}
BOOL CScrollView::GetVScrollInfo(LPSCROLLINFO lpScrollInfo) const
{
	return ::GetScrollInfo(m_hWnd, SB_VERT, lpScrollInfo);
}
int CScrollView::SetVScrollInfo(LPSCROLLINFO lpScrollInfo, BOOL bRedraw)
{
	return ::SetScrollInfo(m_hWnd, SB_VERT, lpScrollInfo, bRedraw);
}

//HScrollBar Functions
int CScrollView::GetHScrollPos() const
{
	return ::GetScrollPos(m_hWnd, SB_HORZ);
}
int CScrollView::SetHScrollPos(int nPos, BOOL bRedraw)
{
	return ::SetScrollPos(m_hWnd, SB_HORZ, nPos, bRedraw);
}
void CScrollView::GetHScrollRange(LPINT lpMinPos, LPINT lpMaxPos) const
{
	::GetScrollRange(m_hWnd, SB_HORZ, lpMinPos, lpMaxPos);
}
void CScrollView::SetHScrollRange(int nMinPos, int nMaxPos, BOOL bRedraw)
{
	::SetScrollRange(m_hWnd, SB_HORZ, nMinPos, nMaxPos, bRedraw);
}
BOOL CScrollView::GetHScrollInfo(LPSCROLLINFO lpScrollInfo) const
{
	return ::GetScrollInfo(m_hWnd, SB_HORZ, lpScrollInfo);
}
int CScrollView::SetHScrollInfo(LPSCROLLINFO lpScrollInfo, BOOL bRedraw)
{
	return ::SetScrollInfo(m_hWnd, SB_HORZ, lpScrollInfo, bRedraw);
}
