#pragma once

#include <atlddx.h>
#include <atlcrack.h>
#include "Data.h"
#include "resource.h"

class SearchDialog
	: public CDialogImpl<SearchDialog>,
	  public CWinDataExchange<SearchDialog>
{
public:
	static const int IDD;

	SearchDialog();

	bool IsDirectionForward() const;
	MemoryBlock GetData() const;

	BOOL DoDataExchange(BOOL bSaveAndValidate = FALSE, UINT nCtlID = (UINT)-1);

	BEGIN_MSG_MAP_EX(SearchDialog)
		COMMAND_ID_HANDLER(IDC_BUTTON_BACK,OnBackwardSearch)
		COMMAND_ID_HANDLER(IDC_BUTTON_NEXT,OnForwardSearch)
		COMMAND_ID_HANDLER(IDCANCEL,OnCancel)
		MSG_WM_INITDIALOG(OnInitDialog)
	END_MSG_MAP()

private:
	int method_;
	bool forward_;
	MemoryBlock memory_;

	LRESULT OnInitDialog(HWND hWnd, LPARAM lParam);
	LRESULT OnBackwardSearch(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
	LRESULT OnForwardSearch(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
	LRESULT OnCancel(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);

	bool InterpretHex(const std::string& str, MemoryBlock& memory);
	bool InterpretString(const std::string& str, MemoryBlock& memory);
};

