#include "stdafx.h"
#include "ViewCommandHandler.h"
#include "JumpDialog.h"
#include "SearchDialog.h"
#include "MessageDialog.h"

LRESULT ViewCommandHandler::OnCursorUp(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	if(doc_->GetCursor()->IsEnable()){
		if(IsShiftPressed()){
			//I͈͂1s
			MoveRange(0,-1);
		}else{
			//J[\1s
			MoveCursor(0,-1);
		}
		AdjustScroll();
	}else{
		//sփXN[
		ForceScroll(-1);
	}
	doc_->NotifyRefresh();
	return 0;
}

LRESULT ViewCommandHandler::OnCursorDown(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	if(doc_->GetCursor()->IsEnable()){
		if(IsShiftPressed()){
			//I͈͂1s
			MoveRange(0,1);
		}else{
			//J[\1s
			MoveCursor(0,1);
		}
		AdjustScroll();
	}else{
		//sփXN[
		ForceScroll(1);
	}
	doc_->NotifyRefresh();
	return 0;
}

LRESULT ViewCommandHandler::OnCursorLeft(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	if(!doc_->GetCursor()->IsEnable()) return 0;

	if(IsShiftPressed()){
		//I͈͂1
		MoveRange(-1,0);
	}else{
		//J[\1
		MoveCursor(-1,0);
	}
	AdjustScroll();
	doc_->NotifyRefresh();
	return 0;
}

LRESULT ViewCommandHandler::OnCursorRight(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	if(!doc_->GetCursor()->IsEnable()) return 0;

	if(IsShiftPressed()){
		//I͈͂1E
		MoveRange(1,0);
	}else{
		//J[\1E
		MoveCursor(1,0);
	}
	AdjustScroll();
	doc_->NotifyRefresh();
	return 0;
}

LRESULT ViewCommandHandler::OnCursorPageUp(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	int dy = -static_cast<int>(doc_->GetScroll()->GetRowCount());

	if(doc_->GetCursor()->IsEnable()){
		if(IsShiftPressed()){
			//Vtg͑I͈͂1ʕ
			MoveRange(0,dy);
		}
	}
	//1ʕփXN[
	ForceScroll(dy);
	doc_->NotifyRefresh();
	return 0;
}

LRESULT ViewCommandHandler::OnCursorPageDown(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	int dy = static_cast<int>(doc_->GetScroll()->GetRowCount());

	if(doc_->GetCursor()->IsEnable()){
		if(IsShiftPressed()){
			//Vtg͑I͈͂1ʕ
			MoveRange(0,dy);
		}
	}
	//1ʕփXN[
	ForceScroll(dy);
	doc_->NotifyRefresh();
	return 0;
}

void ViewCommandHandler::SetHead()
{
	//t@C擪
	Cursor_ptr cursor = doc_->GetCursor();

	if(IsShiftPressed()){
		if(cursor->IsEnableAnchor()){
			//ݔ͈͑IĂꍇ͂̊_t@C擪܂őI
			SetCursorRange(0,cursor->GetAnchor());
		}else{
			if(CheckInDataRange(doc_)){
				//͈͑IĂȂꍇ̓J[\ʒut@C擪܂őI
				SetCursorRange(0,cursor->GetPosition());
			}else{
				return ;
			}
		}
	}else{
		//J[\擪
		SetCursorPosition(0);
	}

	//XN[擪
	doc_->GetScroll()->SetRowIndex(0);
	doc_->GetScroll()->SetColumnIndex(0);
}

void ViewCommandHandler::SetTail()
{
	//t@C
	Cursor_ptr cursor = doc_->GetCursor();
	ulong endpoint = doc_->Size()-1;

	if(IsShiftPressed()){
		if(cursor->IsEnableAnchor()){
			//ݔ͈͑IĂꍇ͂̊_t@C܂őI
			SetCursorRange(endpoint,cursor->GetAnchor());
		}else{
			if(CheckInDataRange(doc_)){
				//͈͑IĂȂꍇ̓J[\ʒut@C܂őI
				SetCursorRange(cursor->GetPosition(),endpoint);
			}else{
				return;
			}
		}
	}else{
		//J[\𖖔
		SetCursorPosition(endpoint);
	}

	//XN[𖖔
	Formatter_ptr format = doc_->GetFormat();
	doc_->GetScroll()->SetRowIndex(format->GetRowCount());
	doc_->GetScroll()->SetColumnIndex(format->GetMaxColumnCount());
}

void ViewCommandHandler::SetHome()
{
	//s擪
	if(!CheckInEditRange(doc_)) return;

	Formatter_ptr formatter = doc_->GetFormat();
	Cursor_ptr cursor = doc_->GetCursor();

	ulong sourcepoint = cursor->GetPosition();
	int rowindex = static_cast<int>(formatter->Offset2LineIndex(sourcepoint));
	ulong newpoint = formatter->LineIndex2Offset(rowindex);

	if(IsShiftPressed()){
		//݂̃J[\ʒus܂őI
		if(sourcepoint>=doc_->Size()) sourcepoint=doc_->Size()-1;
		SetCursorRange(newpoint,sourcepoint);
	}else{
		//J[\ʒus
		SetCursorPosition(newpoint);
	}
}

void ViewCommandHandler::SetEnd()
{
	//s
	if(!CheckInDataRange(doc_)) return;

	Formatter_ptr formatter = doc_->GetFormat();
	Cursor_ptr cursor = doc_->GetCursor();

	ulong sourcepoint = cursor->GetPosition();
	int rowindex = static_cast<int>(formatter->Offset2LineIndex(sourcepoint));
	ulong newpoint = formatter->LineIndex2Offset(rowindex+1)-1;
	if(newpoint>=doc_->Size()) newpoint=doc_->Size()-1;

	if(IsShiftPressed()){
		//݂̃J[\ʒus܂őI
		SetCursorRange(newpoint,sourcepoint);
	}else{
		//J[\ʒus
		SetCursorPosition(newpoint);
	}
}

LRESULT ViewCommandHandler::OnCursorHead(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	if(!doc_->GetCursor()->IsEnable()) return 0;

	if(IsCtrlPressed()){
		SetHead();
	}else{
		SetHome();
	}
	doc_->NotifyRefresh();

	return 0;
}

LRESULT ViewCommandHandler::OnCursorTail(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	if(!doc_->GetCursor()->IsEnable()) return 0;

	if(IsCtrlPressed()){
		SetTail();
	}else{
		SetEnd();
	}
	doc_->NotifyRefresh();

	return 0;
}

void ViewCommandHandler::MoveCursor(int dx, int dy)
{
	//w̕ωʕJ[\ړ
	if(dx && dy) return;

	ulong srcpoint = doc_->GetCursor()->GetPosition();
	ulong dstpoint = CalcDestinationPoint(srcpoint,dx,dy);
	SetCursorPosition(dstpoint);
}

void ViewCommandHandler::MoveRange(int dx, int dy)
{
	//w̕ωʕI͈͂gk
	Cursor_ptr cursor = doc_->GetCursor();

	ulong size = doc_->Size();
	ulong srcpoint = cursor->GetPosition();
	ulong dstpoint = CalcDestinationPoint(srcpoint,dx,dy);
	if(srcpoint>=size) srcpoint = size-1;
	if(dstpoint>=size) dstpoint = size-1;
	
	if(cursor->IsEnableAnchor()){
		SetCursorRange(dstpoint,cursor->GetAnchor());
	}else{
		SetCursorRange(dstpoint,srcpoint);
	}
}

void ViewCommandHandler::ForceScroll(int dy)
{
	//wʕXN[
	int rowindex = static_cast<int>(doc_->GetScroll()->GetRowIndex());

	rowindex += dy;
	if(rowindex<0){
		rowindex = 0;
	}
	
	doc_->GetScroll()->SetRowIndex(rowindex);
}

void ViewCommandHandler::AdjustScroll()
{
	//J[\ʒu\悤ɃXN[
	int scrollrowindex = static_cast<int>(doc_->GetScroll()->GetRowIndex());
	int scrollrowcount = static_cast<int>(doc_->GetScroll()->GetRowCount());

	ulong sourcepoint = doc_->GetCursor()->GetPosition();
	int cursorrowindex = static_cast<int>(doc_->GetFormat()->Offset2LineIndex(sourcepoint));

	if(cursorrowindex<scrollrowindex){
		scrollrowindex = cursorrowindex;
	}else if(cursorrowindex>=scrollrowindex+scrollrowcount){
		scrollrowindex = cursorrowindex-scrollrowcount+1;
	}

	doc_->GetScroll()->SetRowIndex(scrollrowindex);
}

ulong ViewCommandHandler::CalcDestinationPoint(int sourcepoint, int dx, int dy) const
{
	//wʒuw̕ωʈړꏊZo(sΉ)
	//𒼂ɏ̂Œ

	if(dx && dy) return sourcepoint; //ɓ̋֎~(߂ǂ)

	Formatter_ptr formatter = doc_->GetFormat();

	int rowindex = static_cast<int>(formatter->Offset2LineIndex(sourcepoint));
	int columnindex = static_cast<int>(sourcepoint-formatter->LineIndex2Offset(rowindex));

	int rowcount = static_cast<int>(formatter->GetRowCount());

	if(dy){
		//㉺
		rowindex += dy;
		if(rowindex<0){
			rowindex = 0;
		}else if(rowindex>=rowcount){
			rowindex = rowcount-1;
		}
		int columncount = static_cast<int>(formatter->GetItemCount(rowindex));
		if(columnindex>=columncount){
			columnindex = columncount-1;
		}
	}else if(dx){
		if(dx<0){
			//
			while(dx){
				columnindex--;
				if(columnindex<0){
					//̍s̉E[
					rowindex--;
					if(rowindex<0){
						rowindex = 0;
						columnindex = 0;
						break;
					}
					columnindex = static_cast<int>(formatter->GetItemCount(rowindex))-1;
				}
				dx++;
			}
		}else if(dx>0){
			//E
			int columncount = static_cast<int>(formatter->GetItemCount(rowindex));
			while(dx){
				columnindex++;
				if(columnindex>=columncount){
					//̍s̍[
					rowindex++;
					
					if(rowindex>=rowcount){
						rowindex = rowcount-1;
						columncount = static_cast<int>(formatter->GetItemCount(rowindex));
						columnindex = columncount-1;
						break;
					}
					columncount = static_cast<int>(formatter->GetItemCount(rowindex));
					columnindex = 0;
				}
				dx--;
			}
		}
	}

	ulong destinationpoint = static_cast<ulong>(formatter->LineIndex2Offset(rowindex)+columnindex);
	return destinationpoint;
}

bool ViewCommandHandler::IsShiftPressed() const
{
	return (::GetAsyncKeyState(VK_SHIFT)&0x80000000)?true:false;
}

bool ViewCommandHandler::IsCtrlPressed() const
{
	return (::GetAsyncKeyState(VK_CONTROL)&0x80000000)?true:false;
}

LRESULT ViewCommandHandler::OnSelectAll(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	Cursor_ptr cursor = doc_->GetCursor();
	SetCursorRange(doc_->Size()-1,0);
	doc_->NotifyRefresh();

	return 0;
}

LRESULT ViewCommandHandler::OnSelectRelease(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	Cursor_ptr cursor = doc_->GetCursor();
	cursor->EnableAnchor(false);
	doc_->NotifyRefresh();

	return 0;
}

LRESULT ViewCommandHandler::OnJump(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	JumpDialog dlg;

	Cursor_ptr cursor = doc_->GetCursor();
	
	dlg.SetAddress(cursor->GetPosition());
	if(dlg.DoModal()==IDOK){
		SetCursorPosition(dlg.GetAddress());
		AdjustScroll();
		doc_->NotifyRefresh();
	}
	return 0;
}

void ViewCommandHandler::OnUIUpdateFileRead( CUIItem& item )
{
	item.SetEnable(doc_->Size()?true:false);
}

LRESULT ViewCommandHandler::OnSearch(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& bHandled)
{
	SearchDialog dlg;

	if(dlg.DoModal()==IDOK){
		doc_->GetSearchInfo()->SetSearchData(dlg.GetData());
		if(dlg.IsDirectionForward()){
			//
			return OnSearchForward(0,0,0,bHandled);
		}else{
			//O
			return OnSearchBackward(0,0,0,bHandled);
		}
	}
	return 0;
}

LRESULT ViewCommandHandler::OnSearchForward(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	MemoryBlock memory = doc_->GetSearchInfo()->GetSearchData();
	if(!memory.size) return 0;

	ulong curpos = doc_->GetCursor()->IsEnable()?doc_->GetCursor()->GetStart():0;

	//f[^񋓂邽߂̃Ce[^擾
	buffer_iterator begin = doc_->Begin();
	buffer_iterator end = doc_->End();
	buffer_iterator current = doc_->At(curpos);
	//f[^񋓂邽߂̃Ce[^(̃|C^)擾
	uchar *begindata = memory.data.get();
	uchar *enddata = begindata+memory.size;

	//
	buffer_iterator newcurrent = std::search(current+1,end,begindata,enddata);
	if(newcurrent==end){
		//Ȃ̂ōŏ猻ݒn1O܂
		buffer_iterator loopend = current+memory.size-1;
		if(loopend>end) loopend = end;
		end = loopend;
		newcurrent = std::search(begin,end,begindata,enddata);
	}
	
	if(newcurrent!=end){
		//ꍇ
		buffer_iterator::difference_type offset = newcurrent-begin;
		SetCursorRange(offset,offset+memory.size-1);
		AdjustScroll();
		doc_->NotifyRefresh();
	}else{
		//Ȃꍇ
		InformationMessage_Search(GetWindow());
		return 0;
	}

	return 0;
}

LRESULT ViewCommandHandler::OnSearchBackward(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	MemoryBlock memory = doc_->GetSearchInfo()->GetSearchData();
	if(!memory.size) return 0;

	ulong curpos = doc_->GetCursor()->IsEnable()?doc_->GetCursor()->GetEnd():doc_->Size()-1;

	typedef boost::reverse_iterator<uchar*> reverse_data_iterator;

	//f[^tɗ񋓂邽߂̋tCe[^擾
	reverse_buffer_iterator begin(doc_->End());
	reverse_buffer_iterator end(doc_->Begin());
	reverse_buffer_iterator current(doc_->At(curpos));
	//f[^tɗ񋓂邽߂̋tCe[^擾
	reverse_data_iterator begindata(memory.data.get()+memory.size);
	reverse_data_iterator enddata(memory.data.get());

	//O
	reverse_buffer_iterator newcurrent = std::search(current+1,end,begindata,enddata);
	if(newcurrent==end){
		//Ȃ̂ōŏ猻ݒn1O܂
		reverse_buffer_iterator loopend = current+memory.size-1;
		if(loopend>end) loopend = end;
		end = loopend;
		newcurrent = std::search(begin,end,begindata,enddata);
	}
	
	if(newcurrent!=end){
		//ꍇ
		reverse_buffer_iterator::difference_type offset = newcurrent-begin;
		offset = (doc_->Size()-1)-offset-1;
		SetCursorRange(offset,offset+memory.size-1);
		AdjustScroll();
		doc_->NotifyRefresh();
	}else{
		//Ȃꍇ
		InformationMessage_Search(GetWindow());
		return 0;
	}

	return 0;
}

void ViewCommandHandler::OnUIUpdateSearchForward( CUIItem& item )
{
	item.SetEnable(doc_->GetSearchInfo()->IsAvailable());
}

void ViewCommandHandler::OnUIUpdateSearchBackward( CUIItem& item )
{
	item.SetEnable(doc_->GetSearchInfo()->IsAvailable());
}

void ViewCommandHandler::SetCursorPosition(ulong position)
{
	Cursor_ptr cursor = doc_->GetCursor();
	cursor->SetPosition(position);
	cursor->EnableAnchor(false);
	cursor->Enable(true);
}

void ViewCommandHandler::SetCursorRange(ulong position, ulong anchor)
{
	Cursor_ptr cursor = doc_->GetCursor();
	cursor->SetPosition(position);
	cursor->SetAnchor(anchor);
	cursor->EnableAnchor(true);
	cursor->Enable(true);
}

