#pragma once

#include "CommandHandler.h"
#include "UIUpdater.h"
#include "resource.h"

/*
	ViewCommandHandler
	Ɂu\vj[̃R}h邽߂̃NX
*/
class ViewCommandHandler
	: public CommandHandlerBase,
	  public CUIUpdater<ViewCommandHandler>
{
public:
	BEGIN_MSG_MAP(ViewCommandHandler)
		COMMAND_ID_HANDLER(ID_VIEW_MOVE_UP,OnCursorUp)
		COMMAND_ID_HANDLER(ID_VIEW_MOVE_DOWN,OnCursorDown)
		COMMAND_ID_HANDLER(ID_VIEW_MOVE_LEFT,OnCursorLeft)
		COMMAND_ID_HANDLER(ID_VIEW_MOVE_RIGHT,OnCursorRight)
		COMMAND_ID_HANDLER(ID_VIEW_MOVE_PAGEUP,OnCursorPageUp)
		COMMAND_ID_HANDLER(ID_VIEW_MOVE_PAGEDOWN,OnCursorPageDown)
		COMMAND_ID_HANDLER(ID_VIEW_MOVE_HEAD,OnCursorHead)
		COMMAND_ID_HANDLER(ID_VIEW_MOVE_TAIL,OnCursorTail)
		COMMAND_ID_HANDLER(ID_VIEW_SELECT_ALL,OnSelectAll)
		COMMAND_ID_HANDLER(ID_VIEW_SELECT_RELEASE,OnSelectRelease)
		COMMAND_ID_HANDLER(ID_VIEW_JUMP,OnJump)
		COMMAND_ID_HANDLER(ID_VIEW_SEARCH,OnSearch)
		COMMAND_ID_HANDLER(ID_VIEW_SEARCH_FORWARD,OnSearchForward)
		COMMAND_ID_HANDLER(ID_VIEW_SEARCH_BACKWARD,OnSearchBackward)

		CHAIN_MSG_MAP(CUIUpdater<ViewCommandHandler>)
	END_MSG_MAP()

	BEGIN_ORIGINAL_UPDATE_UI_MAP()
		UI_UPDATE_ITEM(ID_VIEW_SELECT_ALL,OnUIUpdateFileRead)
		UI_UPDATE_ITEM(ID_VIEW_JUMP,OnUIUpdateFileRead)
		UI_UPDATE_ITEM(ID_VIEW_SEARCH,OnUIUpdateFileRead)
		UI_UPDATE_ITEM(ID_VIEW_SEARCH_FORWARD,OnUIUpdateSearchForward)
		UI_UPDATE_ITEM(ID_VIEW_SEARCH_BACKWARD,OnUIUpdateSearchBackward)
	END_ORIGINAL_UPDATE_UI_MAP()

private:
	LRESULT OnCursorUp(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);		//ړ 1s
	LRESULT OnCursorDown(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);		//ړ 1s
	LRESULT OnCursorLeft(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);		//ړ 1
	LRESULT OnCursorRight(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);	//ړ 1E
	LRESULT OnCursorPageUp(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);	//ړ 1y[W
	LRESULT OnCursorPageDown(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);	//ړ 1y[W
	LRESULT OnCursorHead(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);		//ړ 擪
	LRESULT OnCursorTail(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);		//ړ 

	LRESULT OnSelectAll(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);		//SĂI
	LRESULT OnSelectRelease(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);	//I
	LRESULT OnJump(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);			//Wv
	LRESULT OnSearch(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);			//
	LRESULT OnSearchForward(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);	//
	LRESULT OnSearchBackward(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);	//O

	void OnUIUpdateFileRead( CUIItem& item );
	void OnUIUpdateSearchForward( CUIItem& item );
	void OnUIUpdateSearchBackward( CUIItem& item );

	void MoveCursor(int dx, int dy);
	void MoveRange(int dx, int dy);
	void ForceScroll(int dy);
	void AdjustScroll();
	ulong CalcDestinationPoint(int sourcepoint, int dx, int dy) const;

	void SetHome();
	void SetEnd();
	void SetHead();
	void SetTail();

	bool IsShiftPressed() const;
	bool IsCtrlPressed() const;

	void SetCursorPosition(ulong position);
	void SetCursorRange(ulong position, ulong anchor);

};