/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.reports.processor;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.bbreak.excella.core.BookController;
import org.bbreak.excella.core.BookData;
import org.bbreak.excella.core.SheetData;
import org.bbreak.excella.core.exporter.book.BookExporter;
import org.bbreak.excella.core.listener.SheetParseListener;
import org.bbreak.excella.reports.exporter.ReportBookExporter;
import org.bbreak.excella.reports.listener.RemoveAdapter;
import org.bbreak.excella.reports.listener.ReportProcessListener;
import org.bbreak.excella.reports.model.ConvertConfiguration;
import org.bbreak.excella.reports.model.ReportBook;
import org.bbreak.excella.reports.model.ReportSheet;
import org.bbreak.excella.reports.processor.ReportCreateHelper;
import org.bbreak.excella.reports.processor.ReportsParserInfo;
import org.bbreak.excella.reports.tag.ReportsTagParser;
import org.bbreak.excella.reports.util.ReportsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportProcessor {
    private Map<String, ReportsTagParser<?>> parsers = new HashMap();
    private Map<String, ReportBookExporter> exporters = new HashMap<String, ReportBookExporter>();
    private List<ReportProcessListener> listeners = new ArrayList<ReportProcessListener>();

    public ReportProcessor() {
        this.parsers.putAll(ReportCreateHelper.createDefaultParsers());
        this.exporters.putAll(ReportCreateHelper.createDefaultExporters());
    }

    public void process(ReportBook ... reportBooks) throws Exception {
        for (ReportBook reportBook : reportBooks) {
            this.processBook(reportBook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBook(ReportBook reportBook) throws Exception {
        if (reportBook == null) {
            return;
        }
        Workbook workbook = this.getTemplateWorkbook(reportBook.getTemplateFileName());
        for (ReportProcessListener listener : this.listeners) {
            listener.preBookParse(workbook, reportBook);
        }
        this.checkReportBook(reportBook);
        Set<Integer> delTemplateIndexs = this.expandTemplate(workbook, reportBook);
        BookController controller = new BookController(workbook);
        for (ReportsTagParser<?> tagParser : this.parsers.values()) {
            controller.addTagParser(tagParser);
        }
        controller.addSheetParseListener((SheetParseListener)new RemoveAdapter());
        for (ReportProcessListener listener : this.listeners) {
            controller.addSheetParseListener((SheetParseListener)listener);
        }
        for (ConvertConfiguration configuration : reportBook.getConfigurations()) {
            if (configuration == null) continue;
            for (ReportBookExporter reportExporter : this.exporters.values()) {
                if (!configuration.getFormatType().equals(reportExporter.getFormatType())) continue;
                reportExporter.setConfiguration(configuration);
                reportExporter.setFilePath(reportBook.getOutputFileName() + reportExporter.getExtention());
                controller.addBookExporter((BookExporter)reportExporter);
            }
        }
        ReportsParserInfo reportsParserInfo = new ReportsParserInfo();
        reportsParserInfo.setReportParsers(new ArrayList(this.parsers.values()));
        reportsParserInfo.setReportBook(reportBook);
        BookData bookData = controller.getBookData();
        bookData.clear();
        for (String sheetName : controller.getSheetNames()) {
            ReportSheet reportSheet;
            if (sheetName.startsWith("-") || (reportSheet = ReportsUtil.getReportSheet(sheetName, reportBook)) == null) continue;
            reportsParserInfo.setParamInfo(reportSheet.getParamInfo());
            SheetData sheetData = controller.parseSheet(sheetName, (Object)reportsParserInfo);
            controller.getBookData().putSheetData(sheetName, sheetData);
        }
        for (Integer deleteSheetIndex : delTemplateIndexs) {
            workbook.removeSheetAt(deleteSheetIndex.intValue());
        }
        for (ReportProcessListener listener : this.listeners) {
            listener.postBookParse(workbook, reportBook);
        }
        for (BookExporter exporter : controller.getExporter()) {
            if (exporter == null) continue;
            exporter.setup();
            try {
                exporter.export(workbook, bookData);
            }
            finally {
                exporter.tearDown();
            }
        }
    }

    private void checkReportBook(ReportBook reportBook) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Workbook getTemplateWorkbook(String filepath) throws Exception {
        FileInputStream fileIn = null;
        Workbook wb = null;
        try {
            fileIn = new FileInputStream(filepath);
            wb = WorkbookFactory.create((InputStream)fileIn);
        }
        finally {
            if (fileIn != null) {
                fileIn.close();
            }
        }
        return wb;
    }

    public void addReportsTagParser(ReportsTagParser<?> tagParser) {
        this.parsers.put(tagParser.getTag(), tagParser);
    }

    public void removeReportsTagParser(String tag) {
        this.parsers.remove(tag);
    }

    public void clearReportsTagParser() {
        this.parsers.clear();
    }

    public void addReportBookExporter(ReportBookExporter exporter) {
        this.exporters.put(exporter.getFormatType(), exporter);
    }

    public void removeReportBookExporter(String formatType) {
        this.exporters.remove(formatType);
    }

    public void clearReportBookExporter() {
        this.exporters.clear();
    }

    public void addReportProcessListener(ReportProcessListener listener) {
        this.listeners.add(listener);
    }

    public void removeReportProcessListener(ReportProcessListener listener) {
        this.listeners.remove(listener);
    }

    private Set<Integer> expandTemplate(Workbook workbook, ReportBook reportBook) {
        TreeSet<Integer> delTemplateIndexs = new TreeSet<Integer>(Collections.reverseOrder());
        HashSet<Integer> useTemplateIndexs = new HashSet<Integer>();
        for (ReportSheet reportSheet : reportBook.getReportSheets()) {
            if (reportSheet == null) continue;
            if (reportSheet.getSheetName().equals(reportSheet.getTemplateName())) {
                int lastSheetIndex = workbook.getNumberOfSheets() - 1;
                workbook.setSheetOrder(reportSheet.getSheetName(), lastSheetIndex);
                useTemplateIndexs.add(lastSheetIndex);
                continue;
            }
            int tempIdx = workbook.getSheetIndex(reportSheet.getTemplateName());
            Sheet sheet = workbook.cloneSheet(tempIdx);
            workbook.setSheetName(workbook.getSheetIndex(sheet), reportSheet.getSheetName());
            delTemplateIndexs.add(tempIdx);
        }
        for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
            Sheet sheet = workbook.getSheetAt(i);
            if (this.isOutputSheet(sheet, reportBook)) continue;
            delTemplateIndexs.add(workbook.getSheetIndex(sheet));
        }
        delTemplateIndexs.removeAll(useTemplateIndexs);
        return delTemplateIndexs;
    }

    private boolean isOutputSheet(Sheet sheet, ReportBook reportBook) {
        for (ReportSheet reportSheet : reportBook.getReportSheets()) {
            if (reportSheet == null || !sheet.getSheetName().equals(reportSheet.getSheetName())) continue;
            return true;
        }
        return false;
    }
}

