/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.reports.tag;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.TagUtil;
import org.bbreak.excella.reports.model.ParamInfo;
import org.bbreak.excella.reports.model.ParsedReportInfo;
import org.bbreak.excella.reports.processor.ReportsParserInfo;
import org.bbreak.excella.reports.tag.ReportsTagParser;
import org.bbreak.excella.reports.util.ReportsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RowRepeatParamParser
extends ReportsTagParser<Object[]> {
    private static Log log = LogFactory.getLog(RowRepeatParamParser.class);
    public static final String DEFAULT_TAG = "$R[]";
    public static final String PARAM_VALUE = "";
    protected static final String PARAM_DUPLICATE = "hideDuplicate";
    public static final String PARAM_ROW_SHIFT = "rowShift";
    public static final String PARAM_BREAK_NUM = "breakNum";
    public static final String PARAM_CHANGE_BREAK = "changeBreak";
    public static final String PARAM_REPEAT_NUM = "repeatNum";
    public static final String PARAM_SHEET_LINK = "sheetLink";
    public static final String PARAM_PROPERTY = "property";

    public RowRepeatParamParser() {
        super(DEFAULT_TAG);
    }

    public RowRepeatParamParser(String tag) {
        super(tag);
    }

    @Override
    public ParsedReportInfo parse(Sheet sheet, Cell tagCell, Object data) throws ParseException {
        Map paramDef = TagUtil.getParams((String)tagCell.getStringCellValue());
        this.checkParam(paramDef, tagCell);
        String tag = tagCell.getStringCellValue();
        ReportsParserInfo reportsParserInfo = (ReportsParserInfo)data;
        Object[] paramValues = null;
        try {
            String replaceParam;
            boolean rowShift = false;
            if (paramDef.containsKey(PARAM_ROW_SHIFT)) {
                rowShift = Boolean.valueOf((String)paramDef.get(PARAM_ROW_SHIFT));
            }
            boolean duplicate = false;
            if (paramDef.containsKey(PARAM_DUPLICATE)) {
                duplicate = Boolean.valueOf((String)paramDef.get(PARAM_DUPLICATE));
            }
            Integer breakNum = null;
            if (paramDef.containsKey(PARAM_BREAK_NUM)) {
                breakNum = Integer.valueOf((String)paramDef.get(PARAM_BREAK_NUM));
            }
            boolean changeBreak = false;
            if (paramDef.containsKey(PARAM_CHANGE_BREAK)) {
                changeBreak = Boolean.valueOf((String)paramDef.get(PARAM_CHANGE_BREAK));
            }
            Integer repeatNum = null;
            if (paramDef.containsKey(PARAM_REPEAT_NUM)) {
                repeatNum = Integer.valueOf((String)paramDef.get(PARAM_REPEAT_NUM));
            }
            boolean sheetLink = false;
            if (paramDef.containsKey(PARAM_SHEET_LINK)) {
                sheetLink = Boolean.valueOf((String)paramDef.get(PARAM_SHEET_LINK));
            }
            String propertyName = null;
            if (paramDef.containsKey(PARAM_PROPERTY)) {
                propertyName = (String)paramDef.get(PARAM_PROPERTY);
            }
            if ("#SHEET_NAME[]".equals(replaceParam = (String)paramDef.get(PARAM_VALUE))) {
                paramValues = ReportsUtil.getSheetNames(reportsParserInfo.getReportBook()).toArray();
            } else if ("#SHEET_VALUE[]".equals(replaceParam)) {
                paramValues = ReportsUtil.getSheetValues(reportsParserInfo.getReportBook(), propertyName, reportsParserInfo.getReportParsers()).toArray();
            } else {
                ParamInfo paramInfo = reportsParserInfo.getParamInfo();
                if (paramInfo != null) {
                    paramValues = (Object[])this.getParamData(paramInfo, replaceParam);
                }
            }
            if (paramValues == null || paramValues.length == 0) {
                paramValues = new Object[]{null};
            }
            int shiftNum = paramValues.length;
            if (repeatNum != null && repeatNum < shiftNum) {
                shiftNum = repeatNum;
            }
            if (shiftNum > 1) {
                if (!rowShift) {
                    CellRangeAddress rangeAddress = new CellRangeAddress(tagCell.getRowIndex(), tagCell.getRowIndex() + shiftNum - 2, tagCell.getColumnIndex(), tagCell.getColumnIndex());
                    PoiUtil.insertRangeDown((Sheet)sheet, (CellRangeAddress)rangeAddress);
                } else {
                    sheet.shiftRows(tagCell.getRowIndex() + 1, sheet.getLastRowNum(), shiftNum - 1);
                }
            }
            Workbook workbook = sheet.getWorkbook();
            String sheetName = workbook.getSheetName(workbook.getSheetIndex(sheet));
            List<String> sheetNames = ReportsUtil.getSheetNames(reportsParserInfo.getReportBook());
            ArrayList<Object> resultValues = new ArrayList<Object>();
            Object beforeValue = null;
            for (int i = 0; i < shiftNum; ++i) {
                Cell cell;
                Row row = sheet.getRow(tagCell.getRowIndex() + i);
                if (row == null) {
                    row = sheet.createRow(tagCell.getRowIndex() + i);
                }
                if ((cell = row.getCell(tagCell.getColumnIndex())) == null) {
                    cell = row.createCell(tagCell.getColumnIndex());
                }
                PoiUtil.copyCell((Cell)tagCell, (Cell)cell);
                Object value = null;
                if (beforeValue == null || !duplicate || !beforeValue.equals(paramValues[i])) {
                    value = paramValues[i];
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("[\u30b7\u30fc\u30c8\u540d=" + sheetName + ",\u30bb\u30eb=(" + cell.getRowIndex() + "," + cell.getColumnIndex() + ")]  " + tag + " \u21d2 " + value));
                }
                PoiUtil.setCellValue((Cell)cell, (Object)value);
                resultValues.add(value);
                if (sheetLink && i < sheetNames.size()) {
                    PoiUtil.setHyperlink((Cell)cell, (int)2, (String)("'" + sheetNames.get(i) + "'!A1"));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("[\u30b7\u30fc\u30c8\u540d=" + sheetName + ",\u30bb\u30eb=(" + cell.getRowIndex() + "," + cell.getColumnIndex() + ")]  Hyperlink \u21d2 " + "'" + sheetNames.get(i) + "'!A1"));
                    }
                }
                if (cell instanceof HSSFCell) {
                    if (breakNum != null && (i + 1) % breakNum == 0) {
                        sheet.setRowBreak(row.getRowNum());
                    }
                    if (changeBreak && beforeValue != null && beforeValue.equals(paramValues[i])) {
                        sheet.setRowBreak(row.getRowNum());
                    }
                }
                beforeValue = paramValues[i];
            }
            ParsedReportInfo parsedReportInfo = new ParsedReportInfo();
            parsedReportInfo.setParsedObject(resultValues);
            parsedReportInfo.setDefaultRowIndex(tagCell.getRowIndex());
            parsedReportInfo.setDefaultColumnIndex(tagCell.getColumnIndex());
            parsedReportInfo.setRowIndex(tagCell.getRowIndex() + shiftNum - 1);
            parsedReportInfo.setColumnIndex(tagCell.getColumnIndex());
            if (log.isDebugEnabled()) {
                log.debug((Object)parsedReportInfo);
            }
            return parsedReportInfo;
        }
        catch (Exception e) {
            throw new ParseException(tagCell, (Throwable)e);
        }
    }

    private void checkParam(Map<String, String> paramDef, Cell tagCell) throws ParseException {
        if (paramDef.containsKey(PARAM_DUPLICATE) && paramDef.containsKey(PARAM_SHEET_LINK)) {
            throw new ParseException(tagCell, "\u4e8c\u91cd\u5b9a\u7fa9\uff1ahideDuplicate,sheetLink");
        }
    }

    @Override
    public boolean useControlRow() {
        return false;
    }
}

