/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.core.handler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFAnchor;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.handler.ParseErrorHandler;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.StringUtil;

public class DebugErrorHandler
implements ParseErrorHandler {
    private static final short ERROR_COMENT_COL_SIZE = 7;
    private static final short ERROR_COMENT_ROW_SIZE = 2;
    private static Log log = LogFactory.getLog(DebugErrorHandler.class);
    private String errorFilePath = null;

    public void notifyException(Workbook workbook, Sheet sheet, ParseException exception) {
        if (exception != null) {
            this.markupErrorCell(workbook, exception);
        }
        this.writeErrorBook(workbook);
    }

    protected void markupErrorCell(Workbook workbook, ParseException exception) {
        Cell errorCell = exception.getCell();
        if (errorCell == null) {
            return;
        }
        workbook.setActiveSheet(workbook.getSheetIndex(errorCell.getSheet()));
        errorCell.setAsActiveCell();
        if (workbook instanceof XSSFWorkbook) {
            XSSFWorkbook xssfWorkbook = (XSSFWorkbook)workbook;
            XSSFCellStyle errorCellStyle = xssfWorkbook.createCellStyle();
            errorCellStyle.setFillForegroundColor((short)45);
            errorCellStyle.setFillPattern((short)1);
            errorCell.setCellStyle((CellStyle)errorCellStyle);
        } else {
            HSSFWorkbook hssfWorkbook = (HSSFWorkbook)workbook;
            int sheetNum = hssfWorkbook.getNumberOfSheets();
            for (int cnt = 0; cnt < sheetNum; ++cnt) {
                hssfWorkbook.getSheetAt(cnt).setSelected(false);
            }
            HSSFCellStyle errorCellStyle = hssfWorkbook.createCellStyle();
            errorCellStyle.setFillForegroundColor((short)45);
            errorCellStyle.setFillPattern((short)1);
            errorCell.setCellStyle((CellStyle)errorCellStyle);
            short commentColFrom = (short)(errorCell.getColumnIndex() + 1);
            short commentColTo = (short)(errorCell.getColumnIndex() + 7);
            int commentRowFrom = errorCell.getRowIndex();
            int commentRowTo = errorCell.getRowIndex() + 2;
            HSSFSheet hssfSheet = (HSSFSheet)errorCell.getSheet();
            HSSFPatriarch patr = hssfSheet.createDrawingPatriarch();
            hssfSheet.setSelected(true);
            HSSFComment comment = patr.createComment((HSSFAnchor)new HSSFClientAnchor(0, 0, 0, 0, commentColFrom, commentRowFrom, commentColTo, commentRowTo));
            comment.setVisible(true);
            comment.setString((RichTextString)new HSSFRichTextString(this.createCommentMessage(exception)));
            errorCell.setCellComment((Comment)comment);
        }
    }

    protected String createCommentMessage(ParseException exception) {
        StringBuilder commentMessageBuf = new StringBuilder();
        if (exception.getMessage() != null) {
            commentMessageBuf.append(exception.getMessage());
        }
        if (exception.getCause() != null) {
            commentMessageBuf.append("\n");
            commentMessageBuf.append(StringUtil.getPrintStackTrace(exception.getCause()));
        }
        return commentMessageBuf.toString();
    }

    protected void writeErrorBook(Workbook workbook) {
        String resultFileName = this.errorFilePath;
        if (resultFileName == null) {
            resultFileName = "./" + System.currentTimeMillis();
            resultFileName = workbook instanceof XSSFWorkbook ? resultFileName + ".xlsx" : resultFileName + ".xls";
        }
        try {
            PoiUtil.writeBook(workbook, resultFileName);
            System.out.println("\n" + resultFileName + "\u306b\u30a8\u30e9\u30fc\u30d5\u30a1\u30a4\u30eb\u3092\u751f\u6210\u3057\u307e\u3057\u305f");
        }
        catch (Exception e) {
            log.warn((Object)"\u30a8\u30e9\u30fc\u30d5\u30a1\u30a4\u30eb\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f", (Throwable)e);
        }
    }

    public String getErrorFilePath() {
        return this.errorFilePath;
    }

    public void setErrorFilePath(String errorFilePath) {
        this.errorFilePath = errorFilePath;
    }
}

