/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.reports.exporter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.bbreak.excella.core.BookData;
import org.bbreak.excella.core.exception.ExportException;
import org.bbreak.excella.reports.exporter.ReportBookExporter;
import org.bbreak.excella.reports.exporter.XLSExporter;
import org.bbreak.excella.reports.exporter.XLSMExporter;
import org.bbreak.excella.reports.exporter.XLSXExporter;
import org.bbreak.excella.reports.model.ConvertConfiguration;

public class ExcelExporter
extends ReportBookExporter {
    private static Log log = LogFactory.getLog(ExcelExporter.class);
    public static final String FORMAT_TYPE = "EXCEL";
    public static final String EXTENTION_XLS = ".xls";
    public static final String EXTENTION_XLSX = ".xlsx";
    public static final String EXTENTION_XLSM = ".xlsm";
    private boolean macroAvailable;

    @Override
    public void output(Workbook book, BookData bookdata, ConvertConfiguration configuration) throws ExportException {
        if (book instanceof HSSFWorkbook) {
            if (log.isInfoEnabled()) {
                log.info((Object)"XLSExporter\u547c\u51fa");
            }
            XLSExporter exporter = new XLSExporter();
            exporter.setConfiguration(configuration);
            exporter.setFilePath(this.getFilePath() + EXTENTION_XLS);
            exporter.output(book, bookdata, configuration);
            this.setFilePath(this.getFilePath() + EXTENTION_XLS);
        } else if (book instanceof XSSFWorkbook) {
            if (log.isInfoEnabled()) {
                log.info((Object)"XLSXExporter\u547c\u51fa");
            }
            if (this.macroAvailable) {
                XLSMExporter exporter = new XLSMExporter();
                exporter.setConfiguration(configuration);
                exporter.setFilePath(this.getFilePath() + EXTENTION_XLSM);
                exporter.output(book, bookdata, configuration);
                this.setFilePath(this.getFilePath() + EXTENTION_XLSM);
            } else {
                XLSXExporter exporter = new XLSXExporter();
                exporter.setConfiguration(configuration);
                exporter.setFilePath(this.getFilePath() + EXTENTION_XLSX);
                exporter.output(book, bookdata, configuration);
                this.setFilePath(this.getFilePath() + EXTENTION_XLSX);
            }
        }
    }

    @Override
    public String getFormatType() {
        return FORMAT_TYPE;
    }

    @Override
    public String getExtention() {
        return "";
    }

    public boolean isMacroAvailable() {
        return this.macroAvailable;
    }

    public void setMacroAvailable(boolean macroAvailable) {
        this.macroAvailable = macroAvailable;
    }
}

