/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.reports.tag;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.tag.TagParser;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.TagUtil;
import org.bbreak.excella.reports.model.ParamInfo;
import org.bbreak.excella.reports.model.ParsedReportInfo;
import org.bbreak.excella.reports.processor.ReportsParserInfo;
import org.bbreak.excella.reports.tag.BlockColRepeatParamParser;
import org.bbreak.excella.reports.tag.ReportsTagParser;
import org.bbreak.excella.reports.tag.RowRepeatParamParser;
import org.bbreak.excella.reports.tag.SingleParamParser;
import org.bbreak.excella.reports.util.ReportsUtil;

public class BlockRowRepeatParamParser
extends ReportsTagParser<Object[]> {
    private static Log log = LogFactory.getLog(BlockRowRepeatParamParser.class);
    public static final String DEFAULT_TAG = "$BR[]";
    public static final String PARAM_VALUE = "";
    public static final String PARAM_FROM_CELL = "fromCell";
    public static final String PARAM_TO_CELL = "toCell";
    public static final String PARAM_REPEAT_NUM = "repeatNum";
    public static final String PARAM_TURN_NUM = "turnNum";
    public static final String PARAM_DUPLICATE = "hideDuplicate";
    public static final String PARAM_REMOVE_TAG = "removeTag";

    public BlockRowRepeatParamParser() {
        super(DEFAULT_TAG);
    }

    public BlockRowRepeatParamParser(String tag) {
        super(tag);
    }

    @Override
    public boolean useControlRow() {
        return true;
    }

    @Override
    public ParsedReportInfo parse(Sheet sheet, Cell tagCell, Object data) throws ParseException {
        try {
            Object[] paramInfos;
            Map paramDef = TagUtil.getParams((String)tagCell.getStringCellValue());
            this.checkParam(sheet, paramDef, tagCell);
            ReportsParserInfo reportsParserInfo = (ReportsParserInfo)data;
            ParamInfo paramInfo = reportsParserInfo.getParamInfo();
            ParsedReportInfo parsedReportInfo = new ParsedReportInfo();
            ArrayList<Object> resultList = new ArrayList<Object>();
            int finalBlockRowIndex = 0;
            int finalBlockColIndex = 0;
            String brTagName = (String)paramDef.get(PARAM_VALUE);
            if (log.isDebugEnabled()) {
                log.debug((Object)("BR\u30d1\u30e9\u30e1\u30fc\u30bf\u540d: " + brTagName));
            }
            if ((paramInfos = (Object[])this.getParamData(paramInfo, brTagName)) == null) {
                return parsedReportInfo;
            }
            List<SingleParamParser> singleParsers = this.getSingleReplaceParsers(reportsParserInfo);
            ArrayList<ParamInfo> paramInfoList = new ArrayList<ParamInfo>();
            for (Object obj : paramInfos) {
                if (obj instanceof ParamInfo) {
                    paramInfoList.add((ParamInfo)obj);
                    continue;
                }
                ParamInfo childParamInfo = new ParamInfo();
                Map map = PropertyUtils.describe((Object)obj);
                for (Map.Entry entry : map.entrySet()) {
                    for (SingleParamParser parser : singleParsers) {
                        childParamInfo.addParam(parser.getTag(), (String)entry.getKey(), entry.getValue());
                    }
                }
                paramInfoList.add(childParamInfo);
            }
            paramInfos = paramInfoList.toArray(new ParamInfo[paramInfoList.size()]);
            Integer repeatNum = paramInfos.length;
            if (paramDef.containsKey(PARAM_REPEAT_NUM) && Integer.valueOf((String)paramDef.get(PARAM_REPEAT_NUM)) < repeatNum) {
                repeatNum = Integer.valueOf((String)paramDef.get(PARAM_REPEAT_NUM));
            }
            HashMap<String, Object> unduplicableParamMap = new HashMap<String, Object>();
            if (paramDef.containsKey(PARAM_DUPLICATE)) {
                String[] params;
                for (String param : params = ((String)paramDef.get(PARAM_DUPLICATE)).split(";")) {
                    for (SingleParamParser parser : singleParsers) {
                        param = parser.getTag() + "{" + param + "}";
                        unduplicableParamMap.put(param, PARAM_VALUE);
                    }
                }
            }
            boolean removeTag = false;
            if (paramDef.containsKey(PARAM_REMOVE_TAG)) {
                removeTag = Boolean.valueOf((String)paramDef.get(PARAM_REMOVE_TAG));
            }
            int tagCellRowIndex = tagCell.getRowIndex();
            int tagCellColIndex = tagCell.getColumnIndex();
            String fromCellParamDef = (String)paramDef.get(PARAM_FROM_CELL);
            int[] fromCellPosition = ReportsUtil.getCellIndex(fromCellParamDef, PARAM_FROM_CELL);
            int defaultFromCellRowIndex = tagCellRowIndex + fromCellPosition[0];
            int defaultFromCellColIndex = tagCellColIndex + fromCellPosition[1];
            String toCellParamDef = (String)paramDef.get(PARAM_TO_CELL);
            int[] toCellPosition = ReportsUtil.getCellIndex(toCellParamDef, PARAM_TO_CELL);
            int defaultToCellRowIndex = tagCellRowIndex + toCellPosition[0];
            int defaultToCellColIndex = tagCellColIndex + toCellPosition[1];
            Object[][] blockCellValues = ReportsUtil.getBlockCellValue(sheet, defaultFromCellRowIndex, defaultToCellRowIndex, defaultFromCellColIndex, defaultToCellColIndex);
            CellStyle[][] blockCellStyles = ReportsUtil.getBlockCellStyle(sheet, defaultFromCellRowIndex, defaultToCellRowIndex, defaultFromCellColIndex, defaultToCellColIndex);
            int[][] blockCellTypes = ReportsUtil.getBlockCellType(sheet, defaultFromCellRowIndex, defaultToCellRowIndex, defaultFromCellColIndex, defaultToCellColIndex);
            float[] rowHeight = ReportsUtil.getRowHeight(sheet, defaultFromCellRowIndex, defaultToCellRowIndex);
            CellRangeAddress[] margedCells = ReportsUtil.getMargedCells(sheet, defaultFromCellRowIndex, defaultToCellRowIndex, defaultFromCellColIndex, defaultToCellColIndex);
            int defaultBlockHeight = defaultToCellRowIndex - defaultFromCellRowIndex + 1;
            int defaultBlockWidth = defaultToCellColIndex - defaultFromCellColIndex + 1;
            int rowlen = defaultBlockHeight;
            int collen = defaultBlockWidth;
            int blockStartRowIndex = defaultFromCellRowIndex;
            int blockStartColIndex = defaultFromCellColIndex;
            int blockEndRowIndex = defaultToCellRowIndex;
            int blockEndColIndex = defaultToCellColIndex;
            int maxblockEndRowIndex = blockEndRowIndex;
            parsedReportInfo.setDefaultRowIndex(defaultToCellRowIndex);
            parsedReportInfo.setDefaultColumnIndex(defaultToCellColIndex);
            for (int repeatCount = 0; repeatCount < repeatNum; ++repeatCount) {
                if (repeatCount > 0) {
                    blockStartRowIndex = blockEndRowIndex + 1;
                    blockEndRowIndex = blockStartRowIndex + rowlen - 1;
                    CellRangeAddress rangeAddress = new CellRangeAddress(blockStartRowIndex, blockEndRowIndex, blockStartColIndex, PoiUtil.getLastColNum((Sheet)sheet));
                    PoiUtil.insertRangeDown((Sheet)sheet, (CellRangeAddress)rangeAddress);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u633f\u5165");
                        log.debug((Object)("\u633f\u5165\u7bc4\u56f2 : " + blockStartRowIndex + ":" + (blockStartRowIndex + rowlen - 1) + ":" + blockStartColIndex + ":" + PoiUtil.getLastColNum((Sheet)sheet)));
                    }
                    int targetRowNum = maxblockEndRowIndex - (defaultFromCellRowIndex - 1);
                    for (CellRangeAddress address : margedCells) {
                        int firstRowNum = address.getFirstRow() + targetRowNum;
                        int lastRowNum = address.getLastRow() + targetRowNum;
                        int firstColumnNum = address.getFirstColumn();
                        int lastColumnNum = address.getLastColumn();
                        CellRangeAddress copyAddress = new CellRangeAddress(firstRowNum, lastRowNum, firstColumnNum, lastColumnNum);
                        sheet.addMergedRegion(copyAddress);
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("repeatCount = " + repeatCount));
                    log.debug((Object)("blockStartRowIndex = " + blockStartRowIndex));
                    log.debug((Object)("blockStartColIndex = " + blockStartColIndex));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\u25cf\u25cf\u25cf\u30d6\u30ed\u30c3\u30af\u60c5\u5831\u3092\u30b3\u30d4\u30fc\u25cf\u25cf\u25cf \u30c7\u30fc\u30bf\u30eb\u30fc\u30d7=" + repeatCount));
                }
                for (int rowIdx = 0; rowIdx < defaultBlockHeight; ++rowIdx) {
                    Row row = sheet.getRow(blockStartRowIndex + rowIdx);
                    if (row == null && !ReportsUtil.isEmptyRow(blockCellTypes[rowIdx], blockCellValues[rowIdx], blockCellStyles[rowIdx])) {
                        row = sheet.createRow(blockStartRowIndex + rowIdx);
                    }
                    if (row == null) continue;
                    row.setHeightInPoints(rowHeight[rowIdx]);
                    for (int colIdx = 0; colIdx < defaultBlockWidth; ++colIdx) {
                        Cell cell = row.getCell(blockStartColIndex + colIdx);
                        int cellType = blockCellTypes[rowIdx][colIdx];
                        Object cellValue = blockCellValues[rowIdx][colIdx];
                        CellStyle cellStyle = blockCellStyles[rowIdx][colIdx];
                        if (cell == null && !ReportsUtil.isEmptyCell(cellType, cellValue, cellStyle)) {
                            cell = row.createCell(blockStartColIndex + colIdx);
                        }
                        if (cell == null) continue;
                        cell.setCellType(cellType);
                        PoiUtil.setCellValue((Cell)cell, (Object)cellValue);
                        if (cellStyle == null) {
                            log.info((Object)("Cell Style at [" + rowIdx + "," + colIdx + "] is not available. Skipping setCellValue()"));
                        } else {
                            cell.setCellStyle(cellStyle);
                        }
                        log.debug((Object)("row=" + (blockStartRowIndex + rowIdx) + " col" + (blockStartColIndex + colIdx) + ">>>>>>" + blockCellValues[rowIdx][colIdx]));
                    }
                }
                int currentBlockHeight = rowlen;
                int currentBlockWidth = collen;
                int plusRowNum = 0;
                int plusColNum = 0;
                collen = defaultBlockWidth;
                for (int targetRow = blockStartRowIndex; targetRow < blockStartRowIndex + rowlen + plusRowNum; ++targetRow) {
                    if (finalBlockRowIndex < targetRow) {
                        finalBlockRowIndex = targetRow;
                    }
                    if (sheet.getRow(targetRow) == null) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("row=" + targetRow + " : row is not available. continued..."));
                        continue;
                    }
                    for (int targetCol = blockStartColIndex; targetCol <= blockStartColIndex + collen + plusColNum - 1; ++targetCol) {
                        Cell targetCell;
                        if (finalBlockColIndex < targetCol) {
                            finalBlockColIndex = targetCol;
                        }
                        if ((targetCell = sheet.getRow(targetRow).getCell(targetCol)) == null) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("row=" + targetRow + " col=" + targetCol + " : cell is not available. continued..."));
                            continue;
                        }
                        TagParser<?> parser = reportsParserInfo.getMatchTagParser(sheet, targetCell);
                        if (parser == null) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("row=" + targetRow + " col=" + targetCol + " parser is not available. continued..."));
                            continue;
                        }
                        String targetCellTag = targetCell.getStringCellValue();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("########## \u30bf\u30b0\u30bb\u30eb\u5ea7\u6a19 row=" + targetRow + " col=" + targetCol + " \u30bf\u30b0\u6587\u5b57=" + targetCellTag + " ##########"));
                        }
                        ParsedReportInfo result = (ParsedReportInfo)parser.parse(sheet, targetCell, (Object)reportsParserInfo.createChildParserInfo((ParamInfo)paramInfos[repeatCount]));
                        resultList.add(result.getParsedObject());
                        plusRowNum += result.getRowIndex() - result.getDefaultRowIndex();
                        plusColNum += result.getColumnIndex() - result.getDefaultColumnIndex();
                        int additionalHeight = result.getRowIndex() - result.getDefaultRowIndex();
                        int additionalWidth = result.getColumnIndex() - result.getDefaultColumnIndex();
                        currentBlockHeight += additionalHeight;
                        currentBlockWidth += additionalWidth;
                        if (parser instanceof SingleParamParser && unduplicableParamMap.containsKey(targetCellTag)) {
                            if (unduplicableParamMap.get(targetCellTag).equals(result.getParsedObject())) {
                                PoiUtil.setCellValue((Cell)targetCell, (Object)PARAM_VALUE);
                            } else {
                                unduplicableParamMap.put(targetCellTag, result.getParsedObject());
                            }
                        }
                        if (defaultFromCellColIndex != result.getDefaultColumnIndex() && result.getRowIndex() > result.getDefaultRowIndex()) {
                            CellRangeAddress preRangeAddress = new CellRangeAddress(blockEndRowIndex + 1, blockEndRowIndex + (result.getRowIndex() - result.getDefaultRowIndex()), blockStartColIndex, targetCol - 1);
                            PoiUtil.insertRangeDown((Sheet)sheet, (CellRangeAddress)preRangeAddress);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"***\u7e26\u88dc\u6b63***");
                                log.debug((Object)("\u633f\u5165\u7bc4\u56f21 : " + (blockEndRowIndex + 1) + ":" + (blockEndRowIndex + (result.getRowIndex() - result.getDefaultRowIndex())) + ":" + blockStartColIndex + ":" + (targetCol - 1)));
                            }
                        }
                        if (parser instanceof RowRepeatParamParser && result.getRowIndex() > result.getDefaultRowIndex()) {
                            CellRangeAddress rearRangeAddress = new CellRangeAddress(blockEndRowIndex + 1, blockEndRowIndex + (result.getRowIndex() - result.getDefaultRowIndex()), result.getDefaultColumnIndex() + 1, PoiUtil.getLastColNum((Sheet)sheet));
                            PoiUtil.insertRangeDown((Sheet)sheet, (CellRangeAddress)rearRangeAddress);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"***\u7e26\u88dc\u6b63***");
                                log.debug((Object)("\u633f\u5165\u7bc4\u56f22 : " + (blockEndRowIndex + 1) + ":" + (blockEndRowIndex + (result.getRowIndex() - result.getDefaultRowIndex())) + ":" + (result.getDefaultColumnIndex() + 1) + ":" + PoiUtil.getLastColNum((Sheet)sheet)));
                            }
                        }
                        blockEndRowIndex += result.getRowIndex() - result.getDefaultRowIndex();
                        if (parser instanceof BlockColRepeatParamParser || parser instanceof BlockRowRepeatParamParser) {
                            collen += result.getColumnIndex() - result.getDefaultColumnIndex();
                            plusColNum -= result.getColumnIndex() - result.getDefaultColumnIndex();
                        }
                        if (blockStartColIndex + collen + plusColNum - 1 <= blockEndColIndex) continue;
                        int beforeLastColIndex = blockEndColIndex;
                        blockEndColIndex = blockStartColIndex + collen + plusColNum - 1;
                        CellRangeAddress preRangeAddress = new CellRangeAddress(tagCell.getRowIndex(), targetRow - 1, beforeLastColIndex + 1, blockEndColIndex);
                        PoiUtil.insertRangeRight((Sheet)sheet, (CellRangeAddress)preRangeAddress);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)"***\u6a2a\u88dc\u6b63***");
                        log.debug((Object)("\u633f\u5165\u7bc4\u56f21 : " + tagCell.getRowIndex() + ":" + (targetRow - 1) + ":" + (beforeLastColIndex + 1) + ":" + blockEndColIndex));
                    }
                    if (blockStartColIndex + collen + plusColNum - 1 < blockEndColIndex) {
                        CellRangeAddress rearRangeAddress = new CellRangeAddress(targetRow, targetRow, blockStartColIndex + collen + plusColNum, blockEndColIndex);
                        PoiUtil.insertRangeRight((Sheet)sheet, (CellRangeAddress)rearRangeAddress);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"***\u6a2a\u88dc\u6b63***");
                            log.debug((Object)("\u633f\u5165\u7bc4\u56f22 : " + targetRow + ":" + targetRow + ":" + (blockStartColIndex + collen + plusColNum) + ":" + blockEndColIndex));
                        }
                    }
                    plusColNum = 0;
                }
                CellRangeAddress rearRangeAddress = new CellRangeAddress(maxblockEndRowIndex + 1, blockEndRowIndex, blockEndColIndex + 1, PoiUtil.getLastColNum((Sheet)sheet));
                PoiUtil.insertRangeDown((Sheet)sheet, (CellRangeAddress)rearRangeAddress);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\u633f\u5165\u7bc4\u56f22 : " + (maxblockEndRowIndex + 1) + ":" + blockEndRowIndex + ":" + (blockEndColIndex + 1) + ":" + PoiUtil.getLastColNum((Sheet)sheet)));
                }
                maxblockEndRowIndex = blockEndRowIndex;
            }
            if (removeTag) {
                tagCell.setCellType(3);
            }
            parsedReportInfo.setColumnIndex(finalBlockColIndex);
            parsedReportInfo.setRowIndex(finalBlockRowIndex);
            parsedReportInfo.setParsedObject(resultList);
            parsedReportInfo.setDefaultRowIndex(defaultToCellRowIndex);
            parsedReportInfo.setDefaultColumnIndex(defaultToCellColIndex);
            if (log.isDebugEnabled()) {
                log.debug((Object)("finalBlockRowIndex= " + finalBlockRowIndex));
                log.debug((Object)("finalBlockColIndex=" + finalBlockColIndex));
            }
            return parsedReportInfo;
        }
        catch (Exception e) {
            throw new ParseException(tagCell, (Throwable)e);
        }
    }

    private List<SingleParamParser> getSingleReplaceParsers(ReportsParserInfo reportsParserInfo) {
        List<ReportsTagParser<?>> parsers = reportsParserInfo.getReportParsers();
        ArrayList<SingleParamParser> singleParsers = new ArrayList<SingleParamParser>();
        for (ReportsTagParser<?> reportsParser : parsers) {
            if (!(reportsParser instanceof SingleParamParser)) continue;
            singleParsers.add((SingleParamParser)reportsParser);
        }
        return singleParsers;
    }

    private void checkParam(Sheet sheet, Map<String, String> paramDef, Cell tagCell) throws ParseException {
        if (!paramDef.containsKey(PARAM_FROM_CELL)) {
            throw new ParseException(tagCell, "\u5fc5\u9808\u30d1\u30e9\u30e1\u30fc\u30bf\u306a\u3057\uff1afromCell");
        }
        if (!paramDef.containsKey(PARAM_TO_CELL)) {
            throw new ParseException(tagCell, "\u5fc5\u9808\u30d1\u30e9\u30e1\u30fc\u30bf\u306a\u3057\uff1atoCell");
        }
        if (paramDef.get(PARAM_FROM_CELL).split(":").length != 2) {
            throw new ParseException(tagCell + "\u30d1\u30e9\u30e1\u30fc\u30bf\u5024\u4e0d\u6b63\uff1a" + PARAM_FROM_CELL);
        }
        if (paramDef.get(PARAM_TO_CELL).split(":").length != 2) {
            throw new ParseException(tagCell + "\u30d1\u30e9\u30e1\u30fc\u30bf\u5024\u4e0d\u6b63\uff1a" + PARAM_TO_CELL);
        }
        int[] fromCellIndex = ReportsUtil.getCellIndex(paramDef.get(PARAM_FROM_CELL), PARAM_FROM_CELL);
        int[] toCellIndex = ReportsUtil.getCellIndex(paramDef.get(PARAM_TO_CELL), PARAM_TO_CELL);
        if (fromCellIndex[0] < 0 || fromCellIndex[1] < 0) {
            throw new ParseException(tagCell, "\u30d1\u30e9\u30e1\u30fc\u30bf\u5024\u4e0d\u6b63\uff1afromCell");
        }
        if (toCellIndex[0] < 0 || toCellIndex[1] < 0) {
            throw new ParseException(tagCell, "\u30d1\u30e9\u30e1\u30fc\u30bf\u5024\u4e0d\u6b63\uff1atoCell");
        }
        if (fromCellIndex[0] > toCellIndex[0]) {
            throw new ParseException(tagCell, "\u30d1\u30e9\u30e1\u30fc\u30bf\u4e0d\u6b63\uff08\u884c\uff09\uff1afromCell,toCell");
        }
        if (fromCellIndex[1] > toCellIndex[1]) {
            throw new ParseException(tagCell, "\u30d1\u30e9\u30e1\u30fc\u30bf\u4e0d\u6b63\uff08\u5217\uff09\uff1afromCell,toCell");
        }
        if (paramDef.containsKey(PARAM_REPEAT_NUM)) {
            try {
                if (Integer.valueOf(paramDef.get(PARAM_REPEAT_NUM)) < 0) {
                    throw new ParseException(tagCell, "\u30d1\u30e9\u30e1\u30fc\u30bf\u5024\u4e0d\u6b63\uff1arepeatNum");
                }
            }
            catch (NumberFormatException e) {
                throw new ParseException(tagCell + "\u30d1\u30e9\u30e1\u30fc\u30bf\u4e0d\u6b63\uff1a" + PARAM_REPEAT_NUM);
            }
        }
    }
}

