/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.reports.tag;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.bbreak.excella.core.CellClone;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.TagUtil;
import org.bbreak.excella.reports.model.ParamInfo;
import org.bbreak.excella.reports.model.ParsedReportInfo;
import org.bbreak.excella.reports.processor.ReportsParserInfo;
import org.bbreak.excella.reports.tag.ReportsTagParser;
import org.bbreak.excella.reports.util.ReportsUtil;

public class ImageParamParser
extends ReportsTagParser<String> {
    private static Log log = LogFactory.getLog(ImageParamParser.class);
    private static final String JPEG_SUFFIX = ".jpeg";
    private static final String JPG_SUFFIX = ".jpg";
    private static final String PNG_SUFFIX = ".png";
    public static final String DEFAULT_TAG = "$I";
    public static final String PARAM_VALUE = "";
    public static final String PARAM_WIDTH = "widthAdjustment";
    public static final String PARAM_HEIGHT = "heightAdjustment";
    public static final String PARAM_SCALE = "scale";
    private Map<Sheet, Drawing> drawingCash = new HashMap<Sheet, Drawing>();

    public ImageParamParser() {
        super(DEFAULT_TAG);
    }

    public ImageParamParser(String tag) {
        super(tag);
    }

    @Override
    public ParsedReportInfo parse(Sheet sheet, Cell tagCell, Object data) throws ParseException {
        Map paramDef = TagUtil.getParams((String)tagCell.getStringCellValue());
        if (this.hasComments(sheet)) {
            throw new ParseException("\u4e0d\u6b63\u30b7\u30fc\u30c8[" + sheet.getWorkbook().getSheetName(sheet.getWorkbook().getSheetIndex(sheet)) + "]\uff1a\u30b3\u30e1\u30f3\u30c8\u6709");
        }
        this.checkParam(paramDef, tagCell);
        ReportsParserInfo reportsParserInfo = (ReportsParserInfo)data;
        ParamInfo paramInfo = reportsParserInfo.getParamInfo();
        String paramValue = null;
        if (paramInfo != null) {
            String replaceParam = (String)paramDef.get(PARAM_VALUE);
            paramValue = (String)this.getParamData(paramInfo, replaceParam);
            Integer dx1 = null;
            if (paramDef.containsKey(PARAM_WIDTH)) {
                dx1 = Integer.valueOf((String)paramDef.get(PARAM_WIDTH));
            }
            Integer dy1 = null;
            if (paramDef.containsKey(PARAM_HEIGHT)) {
                dy1 = Integer.valueOf((String)paramDef.get(PARAM_HEIGHT));
            }
            Double scale = 1.0;
            if (paramDef.containsKey(PARAM_SCALE)) {
                scale = Double.valueOf((String)paramDef.get(PARAM_SCALE));
            }
            if (ReportsUtil.getMergedAddress(sheet, tagCell.getRowIndex(), tagCell.getColumnIndex()) != null) {
                CellStyle cellStyle = tagCell.getCellStyle();
                tagCell.setCellType(3);
                tagCell.setCellStyle(cellStyle);
            } else {
                tagCell = new CellClone(tagCell);
                PoiUtil.clearCell((Sheet)sheet, (CellRangeAddress)new CellRangeAddress(tagCell.getRowIndex(), tagCell.getRowIndex(), tagCell.getColumnIndex(), tagCell.getColumnIndex()));
            }
            if (log.isDebugEnabled()) {
                Workbook workbook = sheet.getWorkbook();
                String sheetName = workbook.getSheetName(workbook.getSheetIndex(sheet));
                log.debug((Object)("[\u30b7\u30fc\u30c8\u540d=" + sheetName + ",\u30bb\u30eb=(" + tagCell.getRowIndex() + "," + tagCell.getColumnIndex() + ")]  " + tagCell.getStringCellValue() + " \u21d2 " + paramValue));
            }
            if (paramValue != null) {
                this.replaceImageValue(sheet, tagCell, paramValue, dx1, dy1, scale);
            }
        }
        ParsedReportInfo parsedReportInfo = new ParsedReportInfo();
        parsedReportInfo.setParsedObject(paramValue);
        parsedReportInfo.setRowIndex(tagCell.getRowIndex());
        parsedReportInfo.setColumnIndex(tagCell.getColumnIndex());
        parsedReportInfo.setDefaultRowIndex(tagCell.getRowIndex());
        parsedReportInfo.setDefaultColumnIndex(tagCell.getColumnIndex());
        return parsedReportInfo;
    }

    private void checkParam(Map<String, String> paramDef, Cell tagCell) throws ParseException {
        if (paramDef.containsKey(PARAM_WIDTH)) {
            try {
                Integer.parseInt(paramDef.get(PARAM_WIDTH));
            }
            catch (NumberFormatException e) {
                throw new ParseException(tagCell, "\u6574\u6570\u4ee5\u5916\u306e\u5024widthAdjustment:" + paramDef.get(PARAM_WIDTH), (Throwable)e);
            }
        }
        if (paramDef.containsKey(PARAM_HEIGHT)) {
            try {
                Integer.parseInt(paramDef.get(PARAM_HEIGHT));
            }
            catch (NumberFormatException e) {
                throw new ParseException(tagCell, "\u6574\u6570\u4ee5\u5916\u306e\u5024heightAdjustment:" + paramDef.get(PARAM_HEIGHT), (Throwable)e);
            }
        }
        if (paramDef.containsKey(PARAM_SCALE)) {
            try {
                Double.parseDouble(paramDef.get(PARAM_SCALE));
            }
            catch (NumberFormatException e) {
                throw new ParseException(tagCell, "\u5b9f\u6570\u4ee5\u5916\u306e\u5024scale:" + paramDef.get(PARAM_SCALE), (Throwable)e);
            }
        }
    }

    private boolean hasComments(Sheet sheet) {
        if (sheet instanceof XSSFSheet) {
            XSSFSheet xssfSheet = (XSSFSheet)sheet;
            return xssfSheet.hasComments();
        }
        if (sheet instanceof HSSFSheet) {
            for (Row row : sheet) {
                for (Cell cell : row) {
                    Comment comment = cell.getCellComment();
                    if (comment == null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void replaceImageValue(Sheet sheet, Cell cell, String filePath, Integer dx1, Integer dy1, Double scale) throws ParseException {
        Workbook workbook = sheet.getWorkbook();
        int format = -1;
        if (filePath.toLowerCase().endsWith(JPEG_SUFFIX) || filePath.toLowerCase().endsWith(JPG_SUFFIX)) {
            format = 5;
        } else if (filePath.toLowerCase().endsWith(PNG_SUFFIX)) {
            format = 6;
        }
        if (format == -1) {
            throw new ParseException(cell, "\u672a\u5bfe\u5fdc\u306e\u753b\u50cf\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u30d5\u30a1\u30a4\u30eb\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\u3002" + filePath);
        }
        byte[] bytes = null;
        FileInputStream is = null;
        try {
            is = new FileInputStream(filePath);
            bytes = IOUtils.toByteArray((InputStream)is);
        }
        catch (Exception e) {
            throw new ParseException(cell, (Throwable)e);
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException e) {
                throw new ParseException(cell, (Throwable)e);
            }
        }
        int pictureIdx = workbook.addPicture(bytes, format);
        CreationHelper helper = workbook.getCreationHelper();
        Drawing drawing = this.drawingCash.get(sheet);
        if (drawing == null) {
            drawing = sheet.createDrawingPatriarch();
            this.drawingCash.put(sheet, drawing);
        }
        ClientAnchor anchor = helper.createClientAnchor();
        anchor.setRow1(cell.getRowIndex());
        anchor.setCol1(cell.getColumnIndex());
        anchor.setRow2(cell.getRowIndex() + 1);
        anchor.setCol2(cell.getColumnIndex() + 1);
        if (dx1 != null) {
            anchor.setDx1(dx1.intValue());
        }
        if (dy1 != null) {
            anchor.setDy1(dy1.intValue());
        }
        Picture picture = drawing.createPicture(anchor, pictureIdx);
        picture.resize(scale.doubleValue());
    }

    @Override
    public boolean useControlRow() {
        return false;
    }
}

