/*
 * Decompiled with CFR 0.152.
 */
package net.w_horse.excelpojo.excel;

import java.lang.annotation.Annotation;
import java.util.LinkedHashMap;
import java.util.Map;
import net.w_horse.excelpojo.annotation.ExcelPOJOAnnotationParser;
import net.w_horse.excelpojo.excel.AbstractCellSeeker;
import net.w_horse.excelpojo.excel.CellNotFoundException;
import net.w_horse.excelpojo.excel.LabeledCellSeeker;
import net.w_horse.excelpojo.excel.PointedCellSeeker;
import net.w_horse.excelpojo.xml.ExcelPOJOXmlParser;
import net.w_horse.excelpojo.xml.tag.DataDirection;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.w3c.dom.Element;

public class MappedCellSeeker
extends AbstractCellSeeker {
    private static final String DATA_DIRECTION_DOWN = DataDirection.DOWN.getValue();
    private static final String DATA_DIRECTION_RIGHT = DataDirection.RIGHT.getValue();
    private String previousLabel;
    private String position;
    private String retrieveFrom;
    private String terminate;
    private String margedLabel;
    private String dataDirection = DATA_DIRECTION_RIGHT;

    @Override
    public void set(Element element, ExcelPOJOXmlParser excelPOJOXmlParser) {
        excelPOJOXmlParser.setCellSeeker(element, this);
    }

    @Override
    public void set(Annotation annotation, ExcelPOJOAnnotationParser excelPOJOAnnotationParser) {
        excelPOJOAnnotationParser.setCellSeeker(annotation, this);
    }

    @Override
    public boolean verify() throws IllegalArgumentException {
        if ((this.getPreviousLabel() == null || this.getPreviousLabel().isEmpty()) && (this.getPosition() == null || this.getPosition().isEmpty())) {
            throw new IllegalArgumentException("Neither the label nor the position are specified.");
        }
        return true;
    }

    @Override
    public Map<String, Object> seekCellValue(HSSFSheet hSSFSheet, Class<?> clazz) throws ClassNotFoundException, LinkageError, CellNotFoundException {
        return this.seekCellValue(hSSFSheet, new AbstractCellSeeker.Offset(0, 0), new AbstractCellSeeker.Offset(0, 0), new AbstractCellSeeker.Offset(0, 0));
    }

    protected Map<String, Object> seekCellValue(HSSFSheet hSSFSheet, AbstractCellSeeker.Offset offset, AbstractCellSeeker.Offset offset2, AbstractCellSeeker.Offset offset3) throws ClassNotFoundException, LinkageError, CellNotFoundException {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        AbstractCellSeeker.Offset offset4 = this.seekCellPosition(hSSFSheet, offset, offset2);
        if (offset4 == null) {
            return linkedHashMap;
        }
        int n = this.getRowLimit(hSSFSheet, offset4);
        for (int i = 0; i <= n; ++i) {
            AbstractCellSeeker.Offset offset5 = this.getOffsetKey(i);
            AbstractCellSeeker.Offset offset6 = this.getOffsetValue(i).add(offset3);
            String string = this.getCellValue(hSSFSheet, offset4, offset5, String.class);
            if (string == null || string.isEmpty()) break;
            String string2 = this.getCellValue(hSSFSheet, offset4, offset6, String.class);
            linkedHashMap.put(string, string2);
        }
        return linkedHashMap;
    }

    @Override
    protected AbstractCellSeeker.Offset seekCellPosition(HSSFSheet hSSFSheet) throws CellNotFoundException {
        return this.seekCellPosition(hSSFSheet, new AbstractCellSeeker.Offset(), new AbstractCellSeeker.Offset());
    }

    @Override
    protected AbstractCellSeeker.Offset seekCellPosition(HSSFSheet hSSFSheet, AbstractCellSeeker.Offset offset, AbstractCellSeeker.Offset offset2) throws CellNotFoundException {
        AbstractCellSeeker abstractCellSeeker;
        if (!this.getPreviousLabel().isEmpty()) {
            LabeledCellSeeker labeledCellSeeker = new LabeledCellSeeker();
            labeledCellSeeker.setLabel(this.getPreviousLabel());
            labeledCellSeeker.setMargedLabel(this.getMargedLabel());
            labeledCellSeeker.setRetrieveFrom(this.getRetrieveFrom());
            labeledCellSeeker.setUse(this.getUse());
            abstractCellSeeker = labeledCellSeeker;
        } else {
            PointedCellSeeker pointedCellSeeker = new PointedCellSeeker();
            pointedCellSeeker.setPosition(this.getPosition());
            abstractCellSeeker = pointedCellSeeker;
            pointedCellSeeker.setUse(this.getUse());
        }
        return ((AbstractCellSeeker)abstractCellSeeker).seekCellPosition(hSSFSheet, offset, offset2);
    }

    @Override
    public void setValue(HSSFSheet hSSFSheet, Object object) throws CellNotFoundException {
        AbstractCellSeeker.Offset offset = this.seekCellPosition(hSSFSheet);
        int n = 0;
        for (String string : ((Map)object).keySet()) {
            String string2 = (String)((Map)object).get(string);
            HSSFCell hSSFCell = this.createCell(hSSFSheet, offset, this.getOffsetKey(n));
            this.setCellValue(hSSFCell, string);
            HSSFCell hSSFCell2 = this.createCell(hSSFSheet, offset, this.getOffsetValue(n));
            this.setCellValue(hSSFCell2, string2);
            ++n;
        }
    }

    @Override
    protected void setValue(HSSFSheet hSSFSheet, AbstractCellSeeker.Offset offset, AbstractCellSeeker.Offset offset2, Object object) {
    }

    protected void setValue(HSSFSheet hSSFSheet, AbstractCellSeeker.Offset offset, AbstractCellSeeker.Offset offset2, AbstractCellSeeker.Offset offset3, Object object) throws CellNotFoundException {
        AbstractCellSeeker.Offset offset4 = this.seekCellPosition(hSSFSheet, offset, offset2);
        int n = 0;
        for (String string : ((Map)object).keySet()) {
            HSSFCell hSSFCell = this.createCell(hSSFSheet, offset4, this.getOffsetKey(n));
            this.setCellValue(hSSFCell, string);
            HSSFCell hSSFCell2 = this.createCell(hSSFSheet, offset4, this.getOffsetValue(n).add(offset3));
            this.setCellValue(hSSFCell2, ((Map)object).get(string));
            ++n;
        }
    }

    public void setPreviousLabel(String string) {
        this.previousLabel = string;
    }

    public String getPreviousLabel() {
        return this.previousLabel;
    }

    public void setPosition(String string) {
        this.position = string;
    }

    public String getPosition() {
        return this.position;
    }

    public void setRetrieveFrom(String string) {
        this.retrieveFrom = string;
    }

    public String getRetrieveFrom() {
        return this.retrieveFrom;
    }

    public void setTerminate(String string) {
        this.terminate = string;
    }

    public String getTerminate() {
        return this.terminate;
    }

    public void setMargedLabel(String string) {
        this.margedLabel = string;
    }

    public String getMargedLabel() {
        return this.margedLabel;
    }

    public void setDataDirection(String string) {
        this.dataDirection = string;
    }

    public String getDataDirection() {
        return this.dataDirection;
    }

    private int getRowLimit(HSSFSheet hSSFSheet, AbstractCellSeeker.Offset offset) {
        if (this.getDataDirection().equals(DATA_DIRECTION_DOWN)) {
            return hSSFSheet.getLastRowNum() - offset.rowIndex;
        }
        short s = 0;
        for (int i = 0; i < hSSFSheet.getLastRowNum(); ++i) {
            short s2;
            HSSFRow hSSFRow = hSSFSheet.getRow(i);
            if (hSSFRow == null || (s2 = hSSFRow.getLastCellNum()) <= s) continue;
            s = s2;
        }
        return s - offset.colIndex;
    }

    private AbstractCellSeeker.Offset getOffsetKey(int n) {
        AbstractCellSeeker.Offset offset = this.getDataDirection().equals(DATA_DIRECTION_DOWN) ? new AbstractCellSeeker.Offset(n, 0) : new AbstractCellSeeker.Offset(0, n);
        return offset;
    }

    private AbstractCellSeeker.Offset getOffsetValue(int n) {
        AbstractCellSeeker.Offset offset = this.getDataDirection().equals(DATA_DIRECTION_DOWN) ? new AbstractCellSeeker.Offset(n, 1) : new AbstractCellSeeker.Offset(1, n);
        return offset;
    }

    public void setMargedRows(boolean bl) {
    }
}

