/*
 * Decompiled with CFR 0.152.
 */
package net.w_horse.excelpojo.excel;

import java.lang.annotation.Annotation;
import java.util.regex.Pattern;
import net.w_horse.excelpojo.ExcelPOJOBridge;
import net.w_horse.excelpojo.ExcelPOJOException;
import net.w_horse.excelpojo.annotation.ExcelPOJOAnnotationParser;
import net.w_horse.excelpojo.excel.CellNotFoundException;
import net.w_horse.excelpojo.excel.ExcelUtils;
import net.w_horse.excelpojo.xml.ExcelPOJOXmlParser;
import net.w_horse.excelpojo.xml.tag.Use;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.w3c.dom.Element;

public abstract class AbstractCellSeeker {
    private ExcelPOJOBridge excelPOJOBridge;
    private String use = Use.NONE.getValue();
    private String range;

    public abstract void set(Element var1, ExcelPOJOXmlParser var2);

    public abstract void set(Annotation var1, ExcelPOJOAnnotationParser var2) throws ClassNotFoundException, LinkageError;

    public abstract Object seekCellValue(Sheet var1, Class<?> var2) throws ClassNotFoundException, LinkageError, CellNotFoundException, IllegalArgumentException, ExcelPOJOException;

    protected abstract Offset seekCellPosition(Sheet var1) throws CellNotFoundException, IllegalArgumentException, ExcelPOJOException;

    protected abstract Offset seekCellPosition(Sheet var1, Offset var2, Offset var3) throws CellNotFoundException, IllegalArgumentException, ExcelPOJOException;

    public abstract void setValue(Sheet var1, Object var2) throws CellNotFoundException, IllegalArgumentException, ExcelPOJOException;

    protected abstract void setValue(Sheet var1, Offset var2, Offset var3, Object var4) throws CellNotFoundException;

    public boolean verify() throws IllegalArgumentException, ExcelPOJOException {
        Pattern pattern = Pattern.compile("\\(\\s?-?[0-9]+\\s?,\\s?-?[0-9]+\\s?\\)-\\(\\s?-?[0-9]+\\s?,\\s?-?[0-9]+\\s?\\)");
        if (this.getRange() != null && !this.getRange().isEmpty() && !pattern.matcher(this.getRange()).matches()) {
            throw new IllegalArgumentException("There is a mistake in the format of the range specification. \nFormat:(startRowIndex, startColIndex)-(endRowIndex, endColIndex)  rowIndex={1,2,3,...}, colIndex={1,2,3,...}");
        }
        return true;
    }

    protected <T> T getCellValue(Sheet sheet, Offset offset, Class<T> clazz) {
        return this.getCellValue(sheet, offset, new Offset(), clazz);
    }

    protected <T> T getCellValue(Sheet sheet, Offset offset, Offset offset2, Class<T> clazz) {
        return this.getCellValue(this.getCell(sheet, offset, offset2), clazz);
    }

    public <T> T getCellValue(Cell cell, Class<T> clazz) {
        return ExcelUtils.getCellValue(cell, clazz);
    }

    protected Cell createCell(Sheet sheet, Offset offset, Offset offset2) {
        Cell cell;
        Row row = sheet.getRow(offset.rowIndex + offset2.rowIndex);
        if (row == null) {
            row = sheet.createRow(offset.rowIndex + offset2.rowIndex);
        }
        if ((cell = row.getCell(offset.colIndex + offset2.colIndex)) == null) {
            cell = row.createCell(offset.colIndex + offset2.colIndex);
        }
        return cell;
    }

    protected Cell getCell(Sheet sheet, Offset offset) {
        return this.getCell(sheet, offset, new Offset());
    }

    protected Cell getCell(Sheet sheet, Offset offset, Offset offset2) {
        if (offset == null) {
            return null;
        }
        return this.createCell(sheet, offset, offset2);
    }

    protected void setCellValue(Cell cell, Object object) {
        ExcelUtils.setCellValue(cell, object);
    }

    public void setExcelPOJOBridge(ExcelPOJOBridge excelPOJOBridge) {
        this.excelPOJOBridge = excelPOJOBridge;
    }

    public ExcelPOJOBridge getExcelPOJOBridge() {
        return this.excelPOJOBridge;
    }

    public void setUse(String string) {
        this.use = string;
    }

    public String getUse() {
        return this.use;
    }

    public void setRange(String string) {
        this.range = string;
    }

    public String getRange() {
        return this.range;
    }

    protected Offset getRangeStartCell() {
        return this.convRangeString2Offset(true);
    }

    protected Offset getRangeEndCell() {
        return this.convRangeString2Offset(false);
    }

    private Offset convRangeString2Offset(boolean bl) {
        String[] stringArray = this.getRange().split("\\)-\\(");
        String string = bl ? stringArray[0] : stringArray[1];
        String[] stringArray2 = bl ? string.substring(1).split(",") : string.substring(0, string.length() - 1).split(",");
        int n = Integer.valueOf(stringArray2[0].trim()) - 1;
        int n2 = Integer.valueOf(stringArray2[1].trim()) - 1;
        return new Offset(n, n2);
    }

    protected String convertOffset2RangeString(Offset offset, Offset offset2) {
        int n = offset.rowIndex;
        int n2 = offset.colIndex;
        int n3 = offset2.rowIndex < 0 ? -1 : n + offset2.rowIndex;
        int n4 = offset2.colIndex < 0 ? -1 : n2 + offset2.colIndex;
        String string = String.format("(%d,%d)", n + 1, n2 + 1);
        String string2 = String.format("(%d,%d)", n3 + 1, n4 + 1);
        return string + "-" + string2;
    }

    protected int getStartRowIndex(int n, int n2) {
        int n3;
        int n4 = n3 = n > n2 ? n : n2;
        if (this.getRange() != null && !this.getRange().isEmpty() && this.getRangeStartCell().rowIndex > 0) {
            n3 = n3 > this.getRangeStartCell().rowIndex ? n3 : this.getRangeStartCell().rowIndex;
        }
        return n3;
    }

    protected int getLimitRowIndex(int n) {
        int n2 = n;
        if (this.getRange() != null && !this.getRange().isEmpty() && this.getRangeEndCell().rowIndex > 0) {
            n2 = n2 < this.getRangeEndCell().rowIndex ? n2 : this.getRangeEndCell().rowIndex;
        }
        return n2;
    }

    protected int getStartColIndex(int n, int n2) {
        int n3;
        int n4 = n3 = n > n2 ? n : n2;
        if (this.getRange() != null && !this.getRange().isEmpty() && this.getRangeStartCell().colIndex > 0) {
            n3 = n3 > this.getRangeStartCell().colIndex ? n3 : this.getRangeStartCell().colIndex;
        }
        return n3;
    }

    protected int getLimitColumnIndex(int n) {
        int n2 = n;
        if (this.getRange() != null && !this.getRange().isEmpty() && this.getRangeEndCell().colIndex > 0) {
            n2 = n2 < this.getRangeEndCell().colIndex ? n2 : this.getRangeEndCell().colIndex;
        }
        return n2;
    }

    protected class Offset {
        public int rowIndex = 0;
        public int colIndex = 0;

        public Offset() {
        }

        public Offset(Offset offset) {
            this.rowIndex = offset.rowIndex;
            this.colIndex = offset.colIndex;
        }

        public Offset(int n, int n2) {
            this.rowIndex = n;
            this.colIndex = n2;
        }

        public Offset add(Offset offset) {
            this.rowIndex += offset.rowIndex;
            this.colIndex += offset.colIndex;
            return this;
        }

        public Offset negate() {
            return new Offset(-this.rowIndex, -this.colIndex);
        }
    }
}

