/*
 * Decompiled with CFR 0.152.
 */
package net.w_horse.excelpojo.excel;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.text.DateFormat;
import java.util.Date;
import net.w_horse.excelpojo.bean.Utils;
import net.w_horse.excelpojo.excel.CellDateFormat;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.springframework.util.ReflectionUtils;

public class ExcelUtils {
    public static Object getCellValue(Cell cell) {
        if (cell == null) {
            return null;
        }
        switch (cell.getCellType()) {
            case 3: {
                return "";
            }
            case 1: {
                return cell.getRichStringCellValue().getString();
            }
            case 0: {
                if (DateUtil.isCellDateFormatted((Cell)cell) || CellDateFormat.contains(cell.getCellStyle().getDataFormat())) {
                    return ExcelUtils.getDateType(cell);
                }
                return ExcelUtils.getNumericType(cell);
            }
            case 4: {
                return cell.getBooleanCellValue();
            }
            case 2: {
                return ExcelUtils.getFormulaType(cell);
            }
        }
        return "";
    }

    public static <T> T getCellValue(Cell cell, Class<T> clazz) {
        Object object;
        if (cell == null) {
            return (T)Utils.convertIfNecessary(null, clazz);
        }
        switch (cell.getCellType()) {
            case 3: {
                object = "";
                break;
            }
            case 1: {
                object = cell.getRichStringCellValue().getString();
                break;
            }
            case 0: {
                if (DateUtil.isCellDateFormatted((Cell)cell) || CellDateFormat.contains(cell.getCellStyle().getDataFormat())) {
                    object = ExcelUtils.getDateType(cell, clazz);
                    break;
                }
                if (clazz.equals(String.class)) {
                    DataFormatter dataFormatter = new DataFormatter();
                    String string = dataFormatter.formatCellValue(cell);
                    if (string.endsWith("_ ")) {
                        string = string.substring(0, string.length() - 2);
                    }
                    return (T)string.trim();
                }
                object = ExcelUtils.getNumericType(cell);
                break;
            }
            case 4: {
                object = cell.getBooleanCellValue();
                break;
            }
            case 2: {
                object = ExcelUtils.getFormulaType(cell, clazz);
                break;
            }
            default: {
                object = "";
            }
        }
        return (T)Utils.convertIfNecessary(object, clazz);
    }

    private static <T> T getFormulaType(Cell cell, Class<T> clazz) {
        FormulaEvaluator formulaEvaluator = cell.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator();
        return ExcelUtils.getCellValue(formulaEvaluator.evaluateInCell(cell), clazz);
    }

    private static Object getFormulaType(Cell cell) {
        FormulaEvaluator formulaEvaluator = cell.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator();
        return ExcelUtils.getCellValue(formulaEvaluator.evaluateInCell(cell));
    }

    private static <T> T getDateType(Cell cell, Class<T> clazz) {
        if (clazz.equals(String.class)) {
            return (T)ExcelUtils.getDateTypeString(cell);
        }
        return (T)ExcelUtils.getDateType(cell);
    }

    private static Date getDateType(Cell cell) {
        return cell.getDateCellValue();
    }

    private static String getDateTypeString(Cell cell) {
        CellStyle cellStyle = cell.getCellStyle();
        Date date = ExcelUtils.getDateType(cell);
        DateFormat dateFormat = CellDateFormat.getFormt(cellStyle.getDataFormat()).getDateFormat();
        return dateFormat.format(date);
    }

    private static Object getNumericType(Cell cell) {
        BigDecimal bigDecimal = new BigDecimal(cell.getNumericCellValue(), new MathContext(17));
        try {
            BigInteger bigInteger = bigDecimal.toBigIntegerExact();
            if (bigInteger.compareTo(BigInteger.valueOf(bigInteger.intValue())) == 0) {
                return bigInteger.intValue();
            }
            return bigInteger;
        }
        catch (ArithmeticException arithmeticException) {
            return cell.getNumericCellValue();
        }
    }

    public static void setCellValue(Cell cell, Object object) {
        Class<Object> clazz;
        if (cell == null) {
            return;
        }
        if (object == null) {
            object = "";
        }
        if ((clazz = object.getClass()).equals(Integer.TYPE) || clazz.equals(Double.TYPE) || clazz.equals(Short.TYPE) || clazz.equals(Long.TYPE) || clazz.equals(Float.TYPE)) {
            clazz = Double.TYPE;
        }
        try {
            ReflectionUtils.invokeMethod((Method)cell.getClass().getDeclaredMethod("setCellValue", clazz), (Object)cell, (Object[])new Object[]{object});
        }
        catch (NoSuchMethodException noSuchMethodException) {
            cell.setCellValue(String.valueOf(object));
        }
    }
}

