/*
 * Decompiled with CFR 0.152.
 */
package net.w_horse.excelpojo.excel;

import java.lang.annotation.Annotation;
import java.util.regex.Pattern;
import net.w_horse.excelpojo.ExcelPOJOException;
import net.w_horse.excelpojo.annotation.ExcelPOJOAnnotationParser;
import net.w_horse.excelpojo.excel.AbstractCellSeeker;
import net.w_horse.excelpojo.xml.ExcelPOJOXmlParser;
import org.apache.poi.ss.usermodel.Sheet;
import org.w3c.dom.Element;

public class PointedCellSeeker
extends AbstractCellSeeker {
    private String position;

    @Override
    public void set(Element element, ExcelPOJOXmlParser excelPOJOXmlParser) {
        excelPOJOXmlParser.setCellSeeker(element, this);
    }

    @Override
    public void set(Annotation annotation, ExcelPOJOAnnotationParser excelPOJOAnnotationParser) {
        excelPOJOAnnotationParser.setCellSeeker(annotation, this);
    }

    @Override
    public boolean verify() throws IllegalArgumentException, ExcelPOJOException {
        super.verify();
        if (this.getPosition() == null || this.getPosition().isEmpty()) {
            throw new IllegalArgumentException("The position is not specified.");
        }
        Pattern pattern = Pattern.compile("\\(\\s?[0-9]+\\s?,\\s?[0-9]+\\s?\\)");
        if (!pattern.matcher(this.getPosition()).matches()) {
            throw new IllegalArgumentException("There is a mistake in the format of the position specification. \nFormat:(rowIndex, colIndex)  rowIndex={1,2,3,...}, colIndex={1,2,3,...}");
        }
        return true;
    }

    @Override
    public Object seekCellValue(Sheet sheet, Class<?> clazz) {
        return this.getCellValue(sheet, this.seekCellPosition(sheet), clazz);
    }

    @Override
    protected AbstractCellSeeker.Offset seekCellPosition(Sheet sheet) {
        return this.seekCellPosition(sheet, new AbstractCellSeeker.Offset(), new AbstractCellSeeker.Offset());
    }

    @Override
    protected AbstractCellSeeker.Offset seekCellPosition(Sheet sheet, AbstractCellSeeker.Offset offset, AbstractCellSeeker.Offset offset2) {
        return this.parsePosition(offset).add(offset2);
    }

    @Override
    public void setValue(Sheet sheet, Object object) {
        this.setCellValue(this.getCell(sheet, this.seekCellPosition(sheet)), object);
    }

    @Override
    protected void setValue(Sheet sheet, AbstractCellSeeker.Offset offset, AbstractCellSeeker.Offset offset2, Object object) {
        this.setCellValue(this.getCell(sheet, this.seekCellPosition(sheet, offset, offset2)), object);
    }

    private AbstractCellSeeker.Offset parsePosition(AbstractCellSeeker.Offset offset) {
        String string = this.getPosition();
        String[] stringArray = string.substring(1, string.length() - 1).split(",");
        int n = Integer.valueOf(stringArray[0].trim()) - 1 + offset.rowIndex;
        int n2 = Integer.valueOf(stringArray[1].trim()) - 1 + offset.colIndex;
        return new AbstractCellSeeker.Offset(n, n2);
    }

    public void setPosition(String string) {
        this.position = string;
    }

    public String getPosition() {
        return this.position;
    }

    public void setMargedRows(boolean bl) {
    }
}

