/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jca.endpoint;

import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.Lifecycle;

public class GenericMessageEndpointManager
implements InitializingBean,
Lifecycle,
DisposableBean {
    private ResourceAdapter resourceAdapter;
    private MessageEndpointFactory messageEndpointFactory;
    private ActivationSpec activationSpec;
    private boolean autoStartup = true;
    private boolean running = false;
    private final Object lifecycleMonitor = new Object();

    public void setResourceAdapter(ResourceAdapter resourceAdapter) {
        this.resourceAdapter = resourceAdapter;
    }

    public ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    public void setMessageEndpointFactory(MessageEndpointFactory messageEndpointFactory) {
        this.messageEndpointFactory = messageEndpointFactory;
    }

    public MessageEndpointFactory getMessageEndpointFactory() {
        return this.messageEndpointFactory;
    }

    public void setActivationSpec(ActivationSpec activationSpec) {
        this.activationSpec = activationSpec;
    }

    public ActivationSpec getActivationSpec() {
        return this.activationSpec;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void afterPropertiesSet() throws ResourceException {
        if (this.getResourceAdapter() == null) {
            throw new IllegalArgumentException("Property 'resourceAdapter' is required");
        }
        if (this.getMessageEndpointFactory() == null) {
            throw new IllegalArgumentException("Property 'messageEndpointFactory' is required");
        }
        ActivationSpec activationSpec = this.getActivationSpec();
        if (activationSpec == null) {
            throw new IllegalArgumentException("Property 'activationSpec' is required");
        }
        if (activationSpec.getResourceAdapter() == null) {
            activationSpec.setResourceAdapter(this.getResourceAdapter());
        } else if (activationSpec.getResourceAdapter() != this.getResourceAdapter()) {
            throw new IllegalArgumentException("ActivationSpec [" + activationSpec + "] is associated with a different ResourceAdapter: " + activationSpec.getResourceAdapter());
        }
        if (this.autoStartup) {
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (!this.running) {
                try {
                    this.getResourceAdapter().endpointActivation(this.getMessageEndpointFactory(), this.getActivationSpec());
                }
                catch (ResourceException ex) {
                    IllegalStateException wrapped = new IllegalStateException("Could not activate message endpoint");
                    wrapped.initCause(ex);
                    throw wrapped;
                }
                this.running = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.running) {
                this.getResourceAdapter().endpointDeactivation(this.getMessageEndpointFactory(), this.getActivationSpec());
                this.running = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.running;
        }
    }

    public void destroy() {
        this.stop();
    }
}

